/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.xml.IXmlTagElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.XmlNsDescriptorUtil;
import com.intellij.xml.util.XmlPsiUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDocumentImpl
extends XmlElementImpl
implements XmlDocument {
    private static final AtomicFieldUpdater<XmlDocumentImpl, XmlProlog> MY_PROLOG_UPDATER = AtomicFieldUpdater.forFieldOfType(XmlDocumentImpl.class, XmlProlog.class);
    private static final AtomicFieldUpdater<XmlDocumentImpl, XmlTag> MY_ROOT_TAG_UPDATER = AtomicFieldUpdater.forFieldOfType(XmlDocumentImpl.class, XmlTag.class);
    private volatile XmlProlog myProlog;
    private volatile XmlTag myRootTag;
    private volatile long myExtResourcesModCount = -1L;
    private ConcurrentMap<String, CachedValue<XmlNSDescriptor>> myDefaultDescriptorsCacheStrict = new ConcurrentHashMap<String, CachedValue<XmlNSDescriptor>>();
    private ConcurrentMap<String, CachedValue<XmlNSDescriptor>> myDefaultDescriptorsCacheNotStrict = new ConcurrentHashMap<String, CachedValue<XmlNSDescriptor>>();

    public XmlDocumentImpl() {
        this(XmlElementType.XML_DOCUMENT);
    }

    protected XmlDocumentImpl(IElementType type2) {
        super(type2);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlDocumentImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlDocument(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public XmlProlog getProlog() {
        XmlProlog prolog = this.myProlog;
        if (prolog == null && !MY_PROLOG_UPDATER.compareAndSet((Object)this, null, (Object)(prolog = (XmlProlog)this.findElementByTokenType(XmlElementType.XML_PROLOG)))) {
            prolog = (XmlProlog)MY_PROLOG_UPDATER.getVolatile((Object)this);
        }
        return prolog;
    }

    @Override
    public XmlTag getRootTag() {
        XmlTag rootTag = this.myRootTag;
        if (rootTag == null) {
            rootTag = (XmlTag)XmlPsiUtil.findElement(this, IXmlTagElementType.class::isInstance);
            if (!MY_ROOT_TAG_UPDATER.compareAndSet((Object)this, null, (Object)rootTag)) {
                rootTag = (XmlTag)MY_ROOT_TAG_UPDATER.getVolatile((Object)this);
            }
        }
        return rootTag;
    }

    @Override
    public XmlNSDescriptor getRootTagNSDescriptor() {
        XmlTag rootTag = this.getRootTag();
        return rootTag != null ? rootTag.getNSDescriptor(rootTag.getNamespace(), false) : null;
    }

    @Override
    public void clearCaches() {
        this.myDefaultDescriptorsCacheStrict.clear();
        this.myDefaultDescriptorsCacheNotStrict.clear();
        this.myRootTag = null;
        this.myProlog = null;
        super.clearCaches();
    }

    @Override
    @Nullable
    public XmlNSDescriptor getDefaultNSDescriptor(String namespace, boolean strict) {
        ConcurrentMap<String, CachedValue<XmlNSDescriptor>> defaultDescriptorsCache;
        CachedValue cachedValue;
        long curExtResourcesModCount = ExternalResourceManagerEx.getInstanceEx().getModificationCount(this.getProject());
        if (this.myExtResourcesModCount != curExtResourcesModCount) {
            this.myDefaultDescriptorsCacheNotStrict.clear();
            this.myDefaultDescriptorsCacheStrict.clear();
            this.myExtResourcesModCount = curExtResourcesModCount;
        }
        if ((cachedValue = (CachedValue)(defaultDescriptorsCache = strict ? this.myDefaultDescriptorsCacheStrict : this.myDefaultDescriptorsCacheNotStrict).get(namespace)) == null) {
            cachedValue = new PsiCachedValueImpl((PsiManager)this.getManager(), () -> {
                XmlNSDescriptor defaultNSDescriptorInner = XmlNsDescriptorUtil.getDefaultNSDescriptor(this, namespace, strict);
                if (XmlNsDescriptorUtil.isGeneratedFromDtd(this, defaultNSDescriptorInner)) {
                    return new CachedValueProvider.Result((Object)defaultNSDescriptorInner, new Object[]{this, ExternalResourceManager.getInstance()});
                }
                return new CachedValueProvider.Result((Object)defaultNSDescriptorInner, new Object[]{defaultNSDescriptorInner != null ? defaultNSDescriptorInner.getDependencies() : ExternalResourceManager.getInstance()});
            });
            defaultDescriptorsCache.put(namespace, (CachedValue<XmlNSDescriptor>)cachedValue);
        }
        return (XmlNSDescriptor)cachedValue.getValue();
    }

    @Nullable
    public static XmlNSDescriptor getCachedHtmlNsDescriptor(@NotNull XmlFile descriptorFile) {
        if (descriptorFile == null) {
            XmlDocumentImpl.$$$reportNull$$$0(1);
        }
        return XmlNsDescriptorUtil.getCachedHtmlNsDescriptor(descriptorFile, "");
    }

    @NotNull
    public CompositePsiElement clone() {
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheStrict);
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheNotStrict);
        XmlDocumentImpl copy = (XmlDocumentImpl)super.clone();
        this.updateSelfDependentDtdDescriptors(copy, cacheStrict, cacheNotStrict);
        XmlDocumentImpl xmlDocumentImpl = copy;
        if (xmlDocumentImpl == null) {
            XmlDocumentImpl.$$$reportNull$$$0(2);
        }
        return xmlDocumentImpl;
    }

    public PsiElement copy() {
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheStrict);
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheNotStrict);
        XmlDocumentImpl copy = (XmlDocumentImpl)super.copy();
        this.updateSelfDependentDtdDescriptors(copy, cacheStrict, cacheNotStrict);
        return copy;
    }

    private void updateSelfDependentDtdDescriptors(XmlDocumentImpl copy, HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict, HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict) {
        XmlNSDescriptor nsDescriptor;
        copy.myDefaultDescriptorsCacheNotStrict = new ConcurrentHashMap<String, CachedValue<XmlNSDescriptor>>();
        copy.myDefaultDescriptorsCacheStrict = new ConcurrentHashMap<String, CachedValue<XmlNSDescriptor>>();
        for (Map.Entry<String, CachedValue<XmlNSDescriptor>> e : cacheStrict.entrySet()) {
            if (!e.getValue().hasUpToDateValue() || XmlNsDescriptorUtil.isGeneratedFromDtd(this, nsDescriptor = (XmlNSDescriptor)e.getValue().getValue())) continue;
            copy.myDefaultDescriptorsCacheStrict.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, CachedValue<XmlNSDescriptor>> e : cacheNotStrict.entrySet()) {
            if (!e.getValue().hasUpToDateValue() || XmlNsDescriptorUtil.isGeneratedFromDtd(this, nsDescriptor = (XmlNSDescriptor)e.getValue().getValue())) continue;
            copy.myDefaultDescriptorsCacheNotStrict.put(e.getKey(), e.getValue());
        }
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta((PsiElement)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlDocumentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlDocumentImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedHtmlNsDescriptor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

