/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.SnapshotVisiblePackBuilder;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VcsLogFiltererImplKt;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import kotlin.Pair;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VisiblePackRefresherImpl
implements VisiblePackRefresher,
Disposable {
    private static final Logger LOG = Logger.getInstance(VisiblePackRefresherImpl.class);
    @NotNull
    private final String myLogId;
    @NotNull
    private final SingleTaskController<Request, State> myTaskController;
    @NotNull
    private final VcsLogFilterer myVcsLogFilterer;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogIndex.IndexingFinishedListener myIndexingFinishedListener;
    @NotNull
    private final List<VisiblePackChangeListener> myVisiblePackChangeListeners;
    @NotNull
    private volatile State myState;

    public VisiblePackRefresherImpl(final @NotNull Project project2, @NotNull VcsLogData logData, @NotNull VcsLogFilterCollection filters, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterer filterer, @NotNull String logId) {
        if (project2 == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(1);
        }
        if (filters == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(2);
        }
        if (sortType == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(3);
        }
        if (filterer == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(4);
        }
        if (logId == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(5);
        }
        this.myVisiblePackChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLogData = logData;
        this.myVcsLogFilterer = filterer;
        this.myLogId = logId;
        this.myState = new State(filters, sortType);
        this.myTaskController = new SingleTaskController<Request, State>("visible " + StringUtil.trimMiddle((String)logId, (int)40), (Disposable)this, state -> {
            boolean hasChanges = this.myState.getVisiblePack() != state.getVisiblePack();
            this.myState = state;
            if (hasChanges) {
                for (VisiblePackChangeListener listener2 : this.myVisiblePackChangeListeners) {
                    listener2.onVisiblePackChange(state.getVisiblePack());
                }
            }
        }){

            @Override
            @NotNull
            protected SingleTaskController.SingleTask startNewBackgroundTask() {
                ProgressIndicator indicator = VisiblePackRefresherImpl.this.myLogData.getProgress().createProgressIndicator(new VisiblePackProgressKey(VisiblePackRefresherImpl.this.myLogId, false));
                MyTask task2 = new MyTask(project2, VcsLogBundle.message("vcs.log.applying.filters.process", new Object[0]));
                Future future2 = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously((Task.Backgroundable)task2, indicator, null);
                return new SingleTaskController.SingleTaskImpl(future2, indicator);
            }

            @Override
            protected boolean cancelRunningTasks(@NotNull List<Request> requests) {
                if (requests == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ContainerUtil.findInstance(requests, IndexingFinishedRequest.class) != null || ContainerUtil.findInstance(requests, FilterRequest.class) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$1", "cancelRunningTasks"));
            }
        };
        this.myIndexingFinishedListener = root -> this.myTaskController.request((Request[])new Request[]{new IndexingFinishedRequest(root)});
        this.myLogData.getIndex().addListener(this.myIndexingFinishedListener);
    }

    @Override
    public void addVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        if (listener2 == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(6);
        }
        this.myVisiblePackChangeListeners.add(listener2);
    }

    @Override
    public void removeVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        if (listener2 == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(7);
        }
        this.myVisiblePackChangeListeners.remove(listener2);
    }

    @Override
    public void onRefresh() {
        this.myTaskController.request((Request[])new Request[]{new RefreshRequest()});
    }

    @Override
    public void setValid(boolean validate, boolean refresh2) {
        if (refresh2) {
            this.myTaskController.request((Request[])new Request[]{new RefreshRequest(), new ValidateRequest(validate)});
        } else {
            this.myTaskController.request((Request[])new Request[]{new ValidateRequest(validate)});
        }
    }

    @Override
    public void onFiltersChange(@NotNull VcsLogFilterCollection newFilters) {
        if (newFilters == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(8);
        }
        this.myTaskController.request((Request[])new Request[]{new FilterRequest(newFilters)});
    }

    @Override
    public void onSortTypeChange(@NotNull PermanentGraph.SortType sortType) {
        if (sortType == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(9);
        }
        this.myTaskController.request((Request[])new Request[]{new SortTypeRequest(sortType)});
    }

    @Override
    public void moreCommitsNeeded(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(10);
        }
        this.myTaskController.request((Request[])new Request[]{new MoreCommitsRequest(onLoaded)});
    }

    @Override
    public boolean isValid() {
        return this.myState.isValid();
    }

    public String toString() {
        return "VisiblePackRefresher '" + this.myLogId + "' state = " + this.myState;
    }

    public void dispose() {
        this.myLogData.getIndex().removeListener(this.myIndexingFinishedListener);
    }

    public static boolean isVisibleKeyFor(@NotNull VcsLogProgress.ProgressKey key2, @NotNull String logId) {
        if (key2 == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(11);
        }
        if (logId == null) {
            VisiblePackRefresherImpl.$$$reportNull$$$0(12);
        }
        if (key2 instanceof VisiblePackProgressKey) {
            VisiblePackProgressKey visiblePackProgressKey = (VisiblePackProgressKey)key2;
            return visiblePackProgressKey.getLogId().equals(logId) && visiblePackProgressKey.isVisible();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterer";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onLoaded";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addVisiblePackChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeVisiblePackChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "onFiltersChange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "onSortTypeChange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "moreCommitsNeeded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisibleKeyFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class State {
        @NotNull
        private final VcsLogFilterCollection myFilters;
        @NotNull
        private final PermanentGraph.SortType mySortType;
        @NotNull
        private final CommitCountStage myCommitCount;
        @NotNull
        private final List<MoreCommitsRequest> myRequestsToRun;
        @NotNull
        private final VisiblePack myVisiblePack;
        private final boolean myIsValid;

        State(@NotNull VcsLogFilterCollection filters, @NotNull PermanentGraph.SortType sortType) {
            if (filters == null) {
                State.$$$reportNull$$$0(0);
            }
            if (sortType == null) {
                State.$$$reportNull$$$0(1);
            }
            this(filters, sortType, CommitCountStage.INITIAL, new ArrayList<MoreCommitsRequest>(), VisiblePack.EMPTY, true);
        }

        State(@NotNull VcsLogFilterCollection filters, @NotNull PermanentGraph.SortType sortType, @NotNull CommitCountStage commitCountStage, @NotNull List<MoreCommitsRequest> requests, @NotNull VisiblePack visiblePack, boolean isValid) {
            if (filters == null) {
                State.$$$reportNull$$$0(2);
            }
            if (sortType == null) {
                State.$$$reportNull$$$0(3);
            }
            if (commitCountStage == null) {
                State.$$$reportNull$$$0(4);
            }
            if (requests == null) {
                State.$$$reportNull$$$0(5);
            }
            if (visiblePack == null) {
                State.$$$reportNull$$$0(6);
            }
            this.myFilters = filters;
            this.mySortType = sortType;
            this.myCommitCount = commitCountStage;
            this.myRequestsToRun = Collections.unmodifiableList(requests);
            this.myVisiblePack = visiblePack;
            this.myIsValid = isValid;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        @NotNull
        public VisiblePack getVisiblePack() {
            VisiblePack visiblePack = this.myVisiblePack;
            if (visiblePack == null) {
                State.$$$reportNull$$$0(7);
            }
            return visiblePack;
        }

        @NotNull
        public List<MoreCommitsRequest> getRequestsToRun() {
            List<MoreCommitsRequest> list = this.myRequestsToRun;
            if (list == null) {
                State.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        public VcsLogFilterCollection getFilters() {
            VcsLogFilterCollection vcsLogFilterCollection = this.myFilters;
            if (vcsLogFilterCollection == null) {
                State.$$$reportNull$$$0(9);
            }
            return vcsLogFilterCollection;
        }

        @NotNull
        public PermanentGraph.SortType getSortType() {
            PermanentGraph.SortType sortType = this.mySortType;
            if (sortType == null) {
                State.$$$reportNull$$$0(10);
            }
            return sortType;
        }

        @NotNull
        public CommitCountStage getCommitCount() {
            CommitCountStage commitCountStage = this.myCommitCount;
            if (commitCountStage == null) {
                State.$$$reportNull$$$0(11);
            }
            return commitCountStage;
        }

        @NotNull
        public State withValid(boolean valid) {
            return new State(this.myFilters, this.mySortType, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, valid);
        }

        @NotNull
        public State withVisiblePack(@NotNull VisiblePack visiblePack) {
            if (visiblePack == null) {
                State.$$$reportNull$$$0(12);
            }
            return new State(this.myFilters, this.mySortType, this.myCommitCount, this.myRequestsToRun, visiblePack, this.myIsValid);
        }

        @NotNull
        public State withCommitCount(@NotNull CommitCountStage commitCount) {
            if (commitCount == null) {
                State.$$$reportNull$$$0(13);
            }
            return new State(this.myFilters, this.mySortType, commitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
        }

        @NotNull
        public State withRequests(@NotNull List<MoreCommitsRequest> requests) {
            if (requests == null) {
                State.$$$reportNull$$$0(14);
            }
            return new State(this.myFilters, this.mySortType, this.myCommitCount, requests, this.myVisiblePack, this.myIsValid);
        }

        @NotNull
        public State withFilters(@NotNull VcsLogFilterCollection filters) {
            if (filters == null) {
                State.$$$reportNull$$$0(15);
            }
            return new State(filters, this.mySortType, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
        }

        @NotNull
        public State withSortType(@NotNull PermanentGraph.SortType type2) {
            if (type2 == null) {
                State.$$$reportNull$$$0(16);
            }
            return new State(this.myFilters, type2, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
        }

        @NonNls
        public String toString() {
            return "State{myFilters=" + this.myFilters + ", mySortType=" + this.mySortType + ", myCommitCount=" + this.myCommitCount + ", myRequestsToRun=" + this.myRequestsToRun + ", myVisiblePack=" + this.myVisiblePack + ", myIsValid=" + this.myIsValid + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitCountStage";
                    break;
                }
                case 5: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visiblePack";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$State";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitCount";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$State";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVisiblePack";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestsToRun";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilters";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortType";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommitCount";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "withVisiblePack";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "withCommitCount";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "withRequests";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "withFilters";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "withSortType";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 7, 8, 9, 10, 11 -> new IllegalStateException(string2);
            };
        }
    }

    private static interface Request {
    }

    private static final class RefreshRequest
    implements Request {
        private RefreshRequest() {
        }

        public String toString() {
            return "RefreshRequest";
        }
    }

    private static final class ValidateRequest
    implements Request {
        private final boolean validate;

        private ValidateRequest(boolean validate) {
            this.validate = validate;
        }

        public String toString() {
            return "ValidateRequest " + this.validate;
        }
    }

    private static final class FilterRequest
    implements Request {
        private final VcsLogFilterCollection filters;

        FilterRequest(VcsLogFilterCollection filters) {
            this.filters = filters;
        }

        public String toString() {
            return "FilterRequest by " + this.filters;
        }
    }

    private static final class SortTypeRequest
    implements Request {
        private final PermanentGraph.SortType sortType;

        SortTypeRequest(PermanentGraph.SortType sortType) {
            this.sortType = sortType;
        }

        public String toString() {
            return "SortTypeRequest " + this.sortType;
        }
    }

    private static final class MoreCommitsRequest
    implements Request {
        @NotNull
        private final Runnable onLoaded;

        MoreCommitsRequest(@NotNull Runnable onLoaded) {
            if (onLoaded == null) {
                MoreCommitsRequest.$$$reportNull$$$0(0);
            }
            this.onLoaded = onLoaded;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoaded", "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$MoreCommitsRequest", "<init>"));
        }
    }

    public static class VisiblePackProgressKey
    extends VcsLogProgress.ProgressKey {
        @NotNull
        private final String myLogId;
        private final boolean myVisible;

        public VisiblePackProgressKey(@NotNull String logId, boolean visible) {
            if (logId == null) {
                VisiblePackProgressKey.$$$reportNull$$$0(0);
            }
            super("visible pack for " + logId);
            this.myLogId = logId;
            this.myVisible = visible;
        }

        public boolean isVisible() {
            return this.myVisible;
        }

        @NotNull
        public String getLogId() {
            String string2 = this.myLogId;
            if (string2 == null) {
                VisiblePackProgressKey.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VisiblePackProgressKey key2 = (VisiblePackProgressKey)o;
            return this.myVisible == key2.myVisible && Objects.equals(this.myLogId, key2.myLogId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myLogId, this.myVisible);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$VisiblePackProgressKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$VisiblePackProgressKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class IndexingFinishedRequest
    implements Request {
        @NotNull
        private final VirtualFile root;

        IndexingFinishedRequest(@NotNull VirtualFile root) {
            if (root == null) {
                IndexingFinishedRequest.$$$reportNull$$$0(0);
            }
            this.root = root;
        }

        @NotNull
        public VirtualFile getRoot() {
            VirtualFile virtualFile = this.root;
            if (virtualFile == null) {
                IndexingFinishedRequest.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        public String toString() {
            return "IndexingFinishedRequest for " + this.root;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$IndexingFinishedRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$IndexingFinishedRequest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private class MyTask
    extends Task.Backgroundable {
        MyTask(@Nls(capitalization=Nls.Capitalization.Title) @NotNull Project project2, String title2) {
            if (title2 == null) {
                MyTask.$$$reportNull$$$0(0);
            }
            super(project2, title2, false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyTask.$$$reportNull$$$0(1);
            }
            State state = VisiblePackRefresherImpl.this.myState;
            List<Request> requests = VisiblePackRefresherImpl.this.myTaskController.peekRequests();
            if (!requests.isEmpty()) {
                try {
                    state = this.computeState(state, requests);
                    VisiblePackRefresherImpl.this.myTaskController.removeRequests(requests);
                }
                catch (ProcessCanceledException reThrown) {
                    LOG.debug("Filtering cancelled");
                    VisiblePackRefresherImpl.this.myTaskController.taskCompleted(null);
                    throw reThrown;
                }
                catch (Throwable t) {
                    LOG.error("Error while processing requests " + requests, t);
                    VisiblePackRefresherImpl.this.myTaskController.removeRequests(requests);
                }
            }
            ArrayList<MoreCommitsRequest> requestsToRun = new ArrayList<MoreCommitsRequest>();
            if (state.getVisiblePack() != VisiblePackRefresherImpl.this.myState.getVisiblePack() && state.isValid() && !(state.getVisiblePack() instanceof VisiblePack.ErrorVisiblePack)) {
                requestsToRun.addAll(state.getRequestsToRun());
                state = state.withRequests(new ArrayList<MoreCommitsRequest>());
            }
            VisiblePackRefresherImpl.this.myTaskController.taskCompleted(state);
            if (!requestsToRun.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (MoreCommitsRequest request : requestsToRun) {
                        request.onLoaded.run();
                    }
                });
            }
        }

        @NotNull
        private State computeState(@NotNull State state, @NotNull List<? extends Request> requests) {
            if (state == null) {
                MyTask.$$$reportNull$$$0(2);
            }
            if (requests == null) {
                MyTask.$$$reportNull$$$0(3);
            }
            ValidateRequest validateRequest = (ValidateRequest)ContainerUtil.findLastInstance(requests, ValidateRequest.class);
            FilterRequest filterRequest = (FilterRequest)ContainerUtil.findLastInstance(requests, FilterRequest.class);
            SortTypeRequest sortTypeRequest = (SortTypeRequest)ContainerUtil.findLastInstance(requests, SortTypeRequest.class);
            List moreCommitsRequests = ContainerUtil.findAll(requests, MoreCommitsRequest.class);
            List indexingRequests = ContainerUtil.findAll(requests, IndexingFinishedRequest.class);
            state = state.withRequests(ContainerUtil.concat(state.getRequestsToRun(), (List)moreCommitsRequests));
            if (filterRequest != null) {
                state = state.withFilters(filterRequest.filters);
            }
            if (sortTypeRequest != null) {
                state = state.withSortType(sortTypeRequest.sortType);
            }
            if (!state.isValid()) {
                if (validateRequest != null && validateRequest.validate) {
                    state = state.withValid(true);
                    return this.refresh(state, filterRequest != null, moreCommitsRequests);
                }
                State state2 = state;
                if (state2 == null) {
                    MyTask.$$$reportNull$$$0(4);
                }
                return state2;
            }
            if (validateRequest != null && !validateRequest.validate) {
                state = state.withValid(false);
                if (filterRequest != null) {
                    state = this.refresh(state, true, moreCommitsRequests);
                }
                State state3 = state.withVisiblePack(new SnapshotVisiblePackBuilder(VisiblePackRefresherImpl.this.myLogData.getStorage()).build(state.getVisiblePack()));
                if (state3 == null) {
                    MyTask.$$$reportNull$$$0(5);
                }
                return state3;
            }
            boolean indexingFinished = !indexingRequests.isEmpty() && VcsLogFiltererImplKt.areFiltersAffectedByIndexing(state.getFilters(), ContainerUtil.map((Collection)indexingRequests, IndexingFinishedRequest::getRoot));
            Request nonValidateRequest = (Request)ContainerUtil.find(requests, request -> !(request instanceof ValidateRequest) && !(request instanceof IndexingFinishedRequest));
            if (nonValidateRequest != null || indexingFinished) {
                return this.refresh(state, filterRequest != null, moreCommitsRequests);
            }
            State state4 = state;
            if (state4 == null) {
                MyTask.$$$reportNull$$$0(6);
            }
            return state4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private State refresh(@NotNull State state, boolean resetCommitCount, @NotNull List<MoreCommitsRequest> moreCommitsRequests) {
            State state2;
            DataPack dataPack;
            if (state == null) {
                MyTask.$$$reportNull$$$0(7);
            }
            if (moreCommitsRequests == null) {
                MyTask.$$$reportNull$$$0(8);
            }
            if ((dataPack = VisiblePackRefresherImpl.this.myLogData.getDataPack()) == DataPack.EMPTY && !VisiblePackRefresherImpl.this.myVcsLogFilterer.canFilterEmptyPack(state.getFilters())) {
                State state3 = state;
                if (state3 == null) {
                    MyTask.$$$reportNull$$$0(9);
                }
                return state3;
            }
            if (resetCommitCount) {
                state = state.withCommitCount(CommitCountStage.INITIAL);
            } else if (!moreCommitsRequests.isEmpty()) {
                state = state.withCommitCount(state.getCommitCount().next());
            }
            VcsLogProgress.updateCurrentKey(new VisiblePackProgressKey(VisiblePackRefresherImpl.this.myLogId, resetCommitCount || state.getVisiblePack().getDataPack() != dataPack || moreCommitsRequests.isEmpty()));
            try {
                Pair<VisiblePack, CommitCountStage> pair = VisiblePackRefresherImpl.this.myVcsLogFilterer.filter(dataPack, state.getVisiblePack(), state.getSortType(), state.getFilters(), state.getCommitCount());
                State state4 = state.withVisiblePack((VisiblePack)pair.getFirst()).withCommitCount((CommitCountStage)((Object)pair.getSecond()));
                state2 = state4;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                State state5 = state.withVisiblePack(new VisiblePack.ErrorVisiblePack(dataPack, state.getFilters(), t));
                State state6 = state5;
                if (state6 == null) {
                    MyTask.$$$reportNull$$$0(11);
                }
                return state6;
            }
            finally {
                VcsLogProgress.updateCurrentKey(new VisiblePackProgressKey(VisiblePackRefresherImpl.this.myLogId, false));
            }
            if (state2 == null) {
                MyTask.$$$reportNull$$$0(10);
            }
            return state2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$MyTask";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moreCommitsRequests";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePackRefresherImpl$MyTask";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeState";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "refresh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "computeState";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "refresh";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4, 5, 6, 9, 10, 11 -> new IllegalStateException(string2);
            };
        }
    }
}

