/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.parse;

import com.thaiopensource.xml.dtd.parse.Atom;
import com.thaiopensource.xml.dtd.parse.AtomParser;
import com.thaiopensource.xml.dtd.parse.AtomStream;
import com.thaiopensource.xml.dtd.parse.Decl;
import com.thaiopensource.xml.dtd.parse.Entity;
import com.thaiopensource.xml.dtd.parse.Notation;
import com.thaiopensource.xml.dtd.parse.PrologParser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DtdBuilder {
    private final Vector atoms;
    private final Vector decls = new Vector();
    private final Hashtable paramEntityTable = new Hashtable();
    private final Hashtable generalEntityTable = new Hashtable();
    private final Hashtable normalizedTable = new Hashtable();
    private final Hashtable notationTable = new Hashtable();
    private final Hashtable ambigNameTable = new Hashtable();

    DtdBuilder(Vector vector) {
        this.atoms = vector;
    }

    Vector getDecls() {
        return this.decls;
    }

    Entity lookupParamEntity(String string2) {
        return (Entity)this.paramEntityTable.get(string2);
    }

    Entity createParamEntity(String string2) {
        Entity entity = new Entity(string2, true);
        Entity entity2 = (Entity)this.paramEntityTable.get(string2);
        if (entity2 != null) {
            while (entity2.overrides != null) {
                entity2 = entity2.overrides;
            }
            entity2.overrides = entity;
            entity.overridden = true;
        } else {
            this.paramEntityTable.put(string2, entity);
        }
        return entity;
    }

    Entity lookupGeneralEntity(String string2) {
        return (Entity)this.generalEntityTable.get(string2);
    }

    Entity createGeneralEntity(String string2) {
        Entity entity = new Entity(string2, false);
        Entity entity2 = (Entity)this.generalEntityTable.get(string2);
        if (entity2 != null) {
            while (entity2.overrides != null) {
                entity2 = entity2.overrides;
            }
            entity2.overrides = entity;
            entity.overridden = true;
        } else {
            this.generalEntityTable.put(string2, entity);
        }
        return entity;
    }

    Notation lookupNotation(String string2) {
        return (Notation)this.notationTable.get(string2);
    }

    Notation createNotation(String string2) {
        Notation notation = (Notation)this.notationTable.get(string2);
        if (notation != null) {
            return null;
        }
        notation = new Notation(string2);
        this.notationTable.put(string2, notation);
        return notation;
    }

    void unexpandEntities() {
        Enumeration enumeration = this.paramEntityTable.elements();
        while (enumeration.hasMoreElements()) {
            ((Entity)enumeration.nextElement()).unexpandEntities();
        }
    }

    void createDecls() {
        new AtomParser(this, new AtomStream(this.atoms), new PrologParser(1), this.decls).parse();
    }

    void analyzeSemantics() {
        Object object;
        Enumeration enumeration = this.paramEntityTable.elements();
        while (enumeration.hasMoreElements()) {
            object = (Entity)enumeration.nextElement();
            String string2 = ((Entity)object).ambiguousNameSpec();
            if (string2 == null) continue;
            Entity entity = (Entity)this.ambigNameTable.get(string2);
            if (entity != null) {
                entity.maybeNameSpec = false;
                ((Entity)object).maybeNameSpec = false;
                continue;
            }
            this.ambigNameTable.put(string2, object);
        }
        Decl.examineElementNames(this, this.decls.elements());
        object = this.paramEntityTable.elements();
        while (object.hasMoreElements()) {
            ((Entity)object.nextElement()).analyzeSemantic();
        }
    }

    void noteElementName(String string2, Entity entity) {
        Entity entity2 = (Entity)this.ambigNameTable.get(string2);
        if (entity2 != null && entity2 != entity) {
            entity2.maybeNameSpec = false;
        }
    }

    Vector createTopLevel() {
        return Decl.declsToTopLevel(this, this.decls.elements());
    }

    void dump() {
        DtdBuilder.dumpEntity("#doc", this.atoms);
    }

    private static void dumpEntity(String string2, Vector vector) {
        System.out.println("<e name=\"" + string2 + "\">");
        DtdBuilder.dumpAtoms(vector);
        System.out.println("</e>");
    }

    private static void dumpAtoms(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Atom atom = (Atom)vector.elementAt(n2);
            Entity entity = atom.getEntity();
            if (entity != null) {
                DtdBuilder.dumpEntity(entity.name, entity.atoms);
            } else if (atom.getTokenType() != 18) {
                System.out.print("<t>");
                DtdBuilder.dumpString(atom.getToken());
                System.out.println("</t>");
            }
            ++n2;
        }
    }

    private static void dumpString(String string2) {
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            switch (string2.charAt(n2)) {
                case '<': {
                    System.out.print("&lt;");
                    break;
                }
                case '>': {
                    System.out.print("&gt;");
                    break;
                }
                case '&': {
                    System.out.print("&amp;");
                    break;
                }
                default: {
                    System.out.print(string2.charAt(n2));
                }
            }
            ++n2;
        }
    }

    void setNormalized(String string2, String string3) {
        this.normalizedTable.put(string2, string3);
    }

    String getNormalized(String string2) {
        return (String)this.normalizedTable.get(string2);
    }
}

