/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/debugger/ScriptDebuggerUrls;", "", "()V", "newLocalFileUrl", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "parse", "url", "asLocalIfNoScheme", "", "toFilePath", "toLocalFileUrl", "toUri", "absoluteOrRelativePath", "toUriPath", "intellij.platform.scriptDebugger.backend"})
public final class ScriptDebuggerUrls {
    @NotNull
    public static final ScriptDebuggerUrls INSTANCE = new ScriptDebuggerUrls();

    private ScriptDebuggerUrls() {
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String uriPath = INSTANCE.toUriPath(path2);
        if (((CharSequence)uriPath).length() > 0 && uriPath.charAt(0) != '/') {
            throw new URISyntaxException(path2, "Must be absolute");
        }
        return Urls.newUrl((String)"file", (String)"", (String)uriPath);
    }

    @Nullable
    public final String toFilePath(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (url.getScheme() != null && !Intrinsics.areEqual((Object)url.getScheme(), (Object)"file")) {
            return null;
        }
        String string2 = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.path");
        String path2 = string2;
        if (path2.length() >= 3 && path2.charAt(0) == '/' && path2.charAt(2) == ':') {
            String string3 = path2.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            path2 = string3;
        }
        return path2;
    }

    private final String toUriPath(String path2) {
        String string2 = FileUtilRt.toSystemIndependentName((String)path2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(path)");
        Object result2 = string2;
        if (((String)result2).length() >= 2 && ((String)result2).charAt(1) == ':') {
            result2 = "/" + (String)result2;
        }
        return result2;
    }

    private final Url toUri(String absoluteOrRelativePath) {
        String string2 = FileUtilRt.toSystemIndependentName((String)absoluteOrRelativePath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(absoluteOrRelativePath)");
        Object result2 = string2;
        if (((String)result2).length() >= 2 && ((String)result2).charAt(1) == ':') {
            result2 = "/" + (String)result2;
        }
        return ((CharSequence)result2).length() > 0 && ((String)result2).charAt(0) == '/' ? ScriptDebuggerUrls.newLocalFileUrl((String)result2) : Urls.newUnparsable((String)result2);
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
        return ScriptDebuggerUrls.newLocalFileUrl(string2);
    }

    @JvmStatic
    @Nullable
    public static final Url parse(@NotNull String url, boolean asLocalIfNoScheme) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return asLocalIfNoScheme && !URLUtil.containsScheme((String)url) ? INSTANCE.toUri(url) : (StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2, null) ? INSTANCE.toLocalFileUrl(url) : Urls.parse((String)url, (boolean)false));
    }

    @NotNull
    public final Url toLocalFileUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string2 = VfsUtilCore.toIdeaUrl((String)url, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toIdeaUrl(url, true)");
        String string3 = string2;
        int n = 7;
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        String canonicalPath = FileUtil.toCanonicalPath((String)string4, (char)'/');
        Intrinsics.checkNotNullExpressionValue((Object)canonicalPath, (String)"canonicalPath");
        return ScriptDebuggerUrls.newLocalFileUrl(canonicalPath);
    }
}

