/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.Url;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.Base64VLQ;
import org.jetbrains.debugger.sourcemap.CharSequenceIterator;
import org.jetbrains.debugger.sourcemap.FileBackedSourceMap;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.MutableEntry;
import org.jetbrains.debugger.sourcemap.NamedEntry;
import org.jetbrains.debugger.sourcemap.OneLevelSourceMap;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapData;
import org.jetbrains.debugger.sourcemap.SourceMapDataCache;
import org.jetbrains.debugger.sourcemap.SourceMapDataEx;
import org.jetbrains.debugger.sourcemap.SourceMapDataImpl;
import org.jetbrains.debugger.sourcemap.SourceMappingList;
import org.jetbrains.debugger.sourcemap.SourceResolver;
import org.jetbrains.debugger.sourcemap.UnmappedEntry;
import org.jetbrains.debugger.sourcemap.UnnamedEntry;
import org.jetbrains.io.JsonReaderEx;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000~\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u001d\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a9\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2'\u0010\f\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\r\u001a*\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0018\u001a*\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0018\u001a1\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0014\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e0\u00032\u0006\u0010!\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\"\u001a\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002\u001a\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0002\u001a\u001a\u0010*\u001a\u0004\u0018\u00010'2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010+\u001a\u0004\u0018\u00010\u000f\u001a.\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000f2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0002\u001a\u0010\u00101\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)H\u0002\u001a \u00102\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010(\u001a\u00020)2\b\u00103\u001a\u0004\u0018\u00010\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"UNMAPPED", "", "calculateReverseMappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "data", "Lorg/jetbrains/debugger/sourcemap/SourceMapData;", "(Lorg/jetbrains/debugger/sourcemap/SourceMapData;)[Lorg/jetbrains/debugger/sourcemap/MappingList;", "decodeSourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "sourceMapData", "", "sourceResolverFactory", "Lkotlin/Function1;", "", "", "Lkotlin/ParameterName;", "name", "sourceUrls", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "decodeSourceMapFromFile", "file", "Ljava/nio/file/Path;", "trimFileScheme", "", "baseUrl", "Lcom/intellij/util/Url;", "baseUrlIsFile", "decodeSourceMapSafely", "getMapping", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "reverseMappingsBySourceUrl", "sourceIndex", "([Ljava/util/List;I)Ljava/util/List;", "isSeparator", "charIterator", "Lorg/jetbrains/debugger/sourcemap/CharSequenceIterator;", "parseMap", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataImpl;", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "parseMapSafely", "mapDebugName", "readMappings", "", "value", "mappings", "names", "readSourcePath", "readSources", "sourceRoot", "intellij.platform.scriptDebugger.backend"})
@SourceDebugExtension(value={"SMAP\nSourceMapDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMapDecoder.kt\norg/jetbrains/debugger/sourcemap/SourceMapDecoderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,392:1\n10#2:393\n10#2:394\n10#2:395\n107#3:396\n79#3,22:397\n*S KotlinDebug\n*F\n+ 1 SourceMapDecoder.kt\norg/jetbrains/debugger/sourcemap/SourceMapDecoderKt\n*L\n61#1:393\n65#1:394\n168#1:395\n213#1:396\n213#1:397,22\n*E\n"})
public final class SourceMapDecoderKt {
    public static final int UNMAPPED = -1;

    @Nullable
    public static final SourceMap decodeSourceMapFromFile(@NotNull Path file, boolean trimFileScheme, @Nullable Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileBackedSourceMap.Companion.newFileBackedSourceMap(file, trimFileScheme, baseUrl, baseUrlIsFile);
    }

    @Nullable
    public static final SourceMap decodeSourceMapSafely(@NotNull CharSequence sourceMapData, boolean trimFileScheme, @Nullable Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        return SourceMapDecoderKt.decodeSourceMap(sourceMapData, (Function1<? super List<String>, SourceResolver>)((Function1)new Function1<List<? extends String>, SourceResolver>(trimFileScheme, baseUrl, baseUrlIsFile){
            final /* synthetic */ boolean $trimFileScheme;
            final /* synthetic */ Url $baseUrl;
            final /* synthetic */ boolean $baseUrlIsFile;
            {
                this.$trimFileScheme = $trimFileScheme;
                this.$baseUrl = $baseUrl;
                this.$baseUrlIsFile = $baseUrlIsFile;
                super(1);
            }

            @NotNull
            public final SourceResolver invoke(@NotNull List<String> sourceUrls) {
                Intrinsics.checkNotNullParameter(sourceUrls, (String)"sourceUrls");
                return new SourceResolver(sourceUrls, this.$trimFileScheme, this.$baseUrl, this.$baseUrlIsFile);
            }
        }));
    }

    @Nullable
    public static final SourceMapDataImpl parseMapSafely(@NotNull CharSequence sourceMapData, @Nullable String mapDebugName) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        try {
            if (sourceMapData.length() == 0) {
                throw new IOException("source map contents cannot be empty");
            }
            JsonReaderEx reader = new JsonReaderEx(sourceMapData);
            reader.setLenient(true);
            return SourceMapDecoderKt.parseMap(reader);
        }
        catch (JsonParseException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SourceMap.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.warn("Cannot decode sourcemap " + mapDebugName, (Throwable)e);
        }
        catch (Throwable t) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SourceMap.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            Attachment[] attachmentArray = new Attachment[]{new Attachment("sourceMap.txt", ((Object)sourceMapData).toString())};
            logger.error("Cannot decode sourcemap " + mapDebugName, t, attachmentArray);
        }
        return null;
    }

    @Nullable
    public static final SourceMap decodeSourceMap(@NotNull CharSequence sourceMapData, @NotNull Function1<? super List<String>, SourceResolver> sourceResolverFactory) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        Intrinsics.checkNotNullParameter(sourceResolverFactory, (String)"sourceResolverFactory");
        SourceMapDataEx sourceMapDataEx = SourceMapDataCache.getOrCreate$default(SourceMapDataCache.INSTANCE, ((Object)sourceMapData).toString(), null, 2, null);
        if (sourceMapDataEx == null) {
            return null;
        }
        SourceMapDataEx data2 = sourceMapDataEx;
        return new OneLevelSourceMap(data2, (SourceResolver)sourceResolverFactory.invoke(data2.getSourceMapData().getSources()));
    }

    @NotNull
    public static final MappingList[] calculateReverseMappings(@NotNull SourceMapData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        List[] reverseMappingsBySourceUrl = new List[data2.getSources().size()];
        for (MappingEntry entry2 : data2.getMappings()) {
            int sourceIndex = entry2.getSource();
            if (sourceIndex < 0) continue;
            List<MappingEntry> reverseMappings = SourceMapDecoderKt.getMapping(reverseMappingsBySourceUrl, sourceIndex);
            reverseMappings.add(entry2);
        }
        int n = reverseMappingsBySourceUrl.length;
        MappingList[] mappingListArray = new MappingList[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            List entries2 = reverseMappingsBySourceUrl[n2];
            mappingListArray[n2] = entries2 == null ? null : new SourceMappingList(entries2);
        }
        return mappingListArray;
    }

    /*
     * Unable to fully structure code
     */
    private static final SourceMapDataImpl parseMap(JsonReaderEx reader) {
        reader.beginObject();
        sourceRoot = null;
        sourcesReader = null;
        names = null;
        encodedMappings = null;
        file = null;
        version = -1;
        sourcesContent = null;
        mappings = new ArrayList<E>();
        while (reader.hasNext()) {
            block31: {
                block37: {
                    block35: {
                        block33: {
                            block34: {
                                block36: {
                                    block32: {
                                        var9_9 = reader.nextName();
                                        if (var9_9 == null) break block31;
                                        switch (var9_9.hashCode()) {
                                            case -1111500899: {
                                                if (!var9_9.equals("sourceRoot")) {
                                                    ** break;
                                                }
                                                break block32;
                                            }
                                            case 194445669: {
                                                if (!var9_9.equals("mappings")) {
                                                    ** break;
                                                }
                                                break block33;
                                            }
                                            case 104585032: {
                                                if (!var9_9.equals("names")) {
                                                    ** break;
                                                }
                                                break block34;
                                            }
                                            case 3143036: {
                                                if (!var9_9.equals("file")) {
                                                    ** break;
                                                }
                                                break block35;
                                            }
                                            case -2021876808: {
                                                if (!var9_9.equals("sources")) {
                                                    ** break;
                                                }
                                                break block36;
                                            }
                                            case -252243551: {
                                                if (!var9_9.equals("sourcesContent")) {
                                                    ** break;
                                                }
                                                break block37;
                                            }
                                            case 351608024: {
                                                if (var9_9.equals("version")) break;
                                                ** break;
                                            }
                                            case 947936814: {
                                                if (!var9_9.equals("sections")) ** break;
                                                throw new IOException("sections is not supported yet");
                                            }
                                        }
                                        version = reader.nextInt();
                                        continue;
                                    }
                                    sourceRoot = StringUtil.nullize((String)SourceMapDecoderKt.readSourcePath(reader));
                                    if (sourceRoot == null || Intrinsics.areEqual((Object)sourceRoot, (Object)"/")) continue;
                                    sourceRoot = UriUtil.trimTrailingSlashes((String)sourceRoot);
                                    continue;
                                }
                                sourcesReader = reader.subReader();
                                reader.skipValue();
                                continue;
                            }
                            reader.beginArray();
                            if (reader.hasNext()) {
                                names = new ArrayList<E>();
                                do {
                                    if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                                        reader.skipValue();
                                        ((ArrayList)names).add("POLYMER UNKNOWN NAME");
                                        continue;
                                    }
                                    ((ArrayList)names).add(reader.nextString(true));
                                } while (reader.hasNext());
                            } else {
                                names = CollectionsKt.emptyList();
                            }
                            reader.endArray();
                            continue;
                        }
                        encodedMappings = reader.nextString();
                        continue;
                    }
                    file = reader.nextNullableString();
                    continue;
                }
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    continue;
                }
                reader.beginArray();
                if (reader.peek() != JsonToken.END_ARRAY) {
                    sourcesContent = (List)new SmartList();
                    do {
                        if (reader.peek() == JsonToken.STRING) {
                            ((SmartList)sourcesContent).add((Object)StringUtilRt.convertLineSeparators((String)reader.nextString()));
                            continue;
                        }
                        if (reader.peek() == JsonToken.NULL) {
                            ((SmartList)sourcesContent).add(null);
                            reader.nextNull();
                            continue;
                        }
                        $i$f$logger = false;
                        v0 = Logger.getInstance(SourceMap.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(T::class.java)");
                        v0.warn("Unknown sourcesContent element: " + reader.peek().name());
                        reader.skipValue();
                    } while (reader.hasNext());
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.close();
        var9_9 = encodedMappings;
        if (var9_9 == null || var9_9.length() == 0) {
            return null;
        }
        if (Registry.is((String)"js.debugger.fix.jspm.source.maps", (boolean)false) && StringsKt.startsWith$default((String)encodedMappings, (String)";", (boolean)false, (int)2, null) && file != null && StringsKt.endsWith$default((String)file, (String)".ts!transpiled", (boolean)false, (int)2, null)) {
            v1 = encodedMappings.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as java.lang.String).substring(startIndex)");
            encodedMappings = v1;
        }
        if (version != 3) {
            throw new IOException("Unsupported sourcemap version: " + version);
        }
        if (sourcesReader == null) {
            throw new IOException("sources is not specified");
        }
        sources = SourceMapDecoderKt.readSources(sourcesReader, sourceRoot);
        if (sources.isEmpty()) {
            return null;
        }
        SourceMapDecoderKt.readMappings(encodedMappings, (List<MappingEntry>)mappings, names);
        var10_11 = names;
        return new SourceMapDataImpl(file, sources, sourcesContent, (var10_11 == null || var10_11.isEmpty() != false) == false, (List<? extends MappingEntry>)mappings);
    }

    private static final String readSourcePath(JsonReaderEx reader) {
        String string2 = reader.nextString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"reader.nextString()");
        String $this$trim$iv = string2;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string3 = PathUtil.toSystemIndependentName((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(\u2026ing().trim { it <= ' ' })");
        return string3;
    }

    private static final void readMappings(String value2, List<MappingEntry> mappings, List<String> names) {
        if (((CharSequence)value2).length() == 0) {
            return;
        }
        int line = 0;
        int column = 0;
        CharSequenceIterator charIterator = new CharSequenceIterator(value2);
        int sourceIndex = 0;
        int sourceLine = 0;
        int sourceColumn = 0;
        int nameIndex = 0;
        Ref.ObjectRef prevEntry = new Ref.ObjectRef();
        while (charIterator.hasNext()) {
            if (charIterator.peek$intellij_platform_scriptDebugger_backend() == ',') {
                charIterator.next();
            } else {
                while (charIterator.peek$intellij_platform_scriptDebugger_backend() == ';') {
                    ++line;
                    column = 0;
                    charIterator.next();
                    if (charIterator.hasNext()) continue;
                    return;
                }
            }
            column += Base64VLQ.decode(charIterator);
            if (SourceMapDecoderKt.isSeparator(charIterator)) {
                SourceMapDecoderKt.readMappings$addEntry((Ref.ObjectRef<MutableEntry>)prevEntry, mappings, new UnmappedEntry(line, column));
                continue;
            }
            int sourceIndexDelta = Base64VLQ.decode(charIterator);
            if (sourceIndexDelta != 0) {
                sourceIndex += sourceIndexDelta;
            }
            sourceLine += Base64VLQ.decode(charIterator);
            sourceColumn += Base64VLQ.decode(charIterator);
            MutableEntry entry2 = null;
            if (SourceMapDecoderKt.isSeparator(charIterator)) {
                entry2 = new UnnamedEntry(line, column, sourceIndex, sourceLine, sourceColumn);
            } else {
                boolean bl;
                nameIndex += Base64VLQ.decode(charIterator);
                boolean bl2 = bl = names != null;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                List<String> list = names;
                Intrinsics.checkNotNull(list);
                entry2 = new NamedEntry(list.get(nameIndex), line, column, sourceIndex, sourceLine, sourceColumn);
            }
            SourceMapDecoderKt.readMappings$addEntry((Ref.ObjectRef<MutableEntry>)prevEntry, mappings, entry2);
        }
    }

    private static final List<String> readSources(JsonReaderEx reader, String sourceRoot) {
        reader.beginArray();
        List sources = null;
        if (reader.peek() == JsonToken.END_ARRAY) {
            sources = CollectionsKt.emptyList();
        } else {
            sources = (List)new SmartList();
            do {
                Object sourceUrl = SourceMapDecoderKt.readSourcePath(reader);
                CharSequence charSequence = sourceRoot;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    sourceUrl = Intrinsics.areEqual((Object)sourceRoot, (Object)"/") ? "/" + (String)sourceUrl : sourceRoot + "/" + (String)sourceUrl;
                }
                ((SmartList)sources).add(sourceUrl);
            } while (reader.hasNext());
        }
        reader.endArray();
        return sources;
    }

    private static final List<MappingEntry> getMapping(List<MappingEntry>[] reverseMappingsBySourceUrl, int sourceIndex) {
        List reverseMappings = reverseMappingsBySourceUrl[sourceIndex];
        if (reverseMappings == null) {
            reverseMappingsBySourceUrl[sourceIndex] = reverseMappings = (List)new ArrayList();
        }
        return reverseMappings;
    }

    private static final boolean isSeparator(CharSequenceIterator charIterator) {
        if (!charIterator.hasNext()) {
            return true;
        }
        char current = charIterator.peek$intellij_platform_scriptDebugger_backend();
        return current == ',' || current == ';';
    }

    private static final void readMappings$addEntry(Ref.ObjectRef<MutableEntry> prevEntry, List<MappingEntry> $mappings, MutableEntry entry2) {
        if (prevEntry.element != null) {
            Object object = prevEntry.element;
            Intrinsics.checkNotNull((Object)object);
            ((MutableEntry)object).setNextGenerated(entry2);
        }
        prevEntry.element = entry2;
        $mappings.add(entry2);
    }
}

