/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.util;

public class ByteArrayBuffer {
    private final byte[] bytes;
    private int readPosition = 0;

    public ByteArrayBuffer(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte peekByte() throws RuntimeException {
        byte result = 0;
        if (this.readPosition >= this.bytes.length) {
            throw new RuntimeException("Cannot peekByte: Next byte not available!");
        }
        result = this.bytes[this.readPosition];
        return result;
    }

    public byte[] peekBytes(int length) throws RuntimeException {
        byte[] result = null;
        if (this.readPosition + length > this.bytes.length) {
            throw new RuntimeException("Cannot peekByte: Next " + length + " bytes not available!");
        }
        result = new byte[length];
        System.arraycopy(this.bytes, this.readPosition, result, 0, length);
        return result;
    }

    public byte readByte() throws RuntimeException {
        byte result = this.peekByte();
        ++this.readPosition;
        return result;
    }

    public byte[] readBytes(int length) throws RuntimeException {
        byte[] result = this.peekBytes(length);
        this.readPosition += length;
        return result;
    }

    public int getNumberOfRemainingBytes() {
        int numRemainingBytes = 0;
        if (this.readPosition < this.bytes.length) {
            numRemainingBytes = this.bytes.length - this.readPosition;
        }
        return numRemainingBytes;
    }

    public byte[] getRemainingBytes() throws RuntimeException {
        byte[] result = null;
        int numRemainingBytes = this.getNumberOfRemainingBytes();
        if (numRemainingBytes <= 0) {
            throw new RuntimeException("Cannot read remaining bytes since no bytes are left!");
        }
        result = this.peekBytes(numRemainingBytes);
        return result;
    }

    public int getNumberOfReadBytes() {
        return this.readPosition;
    }
}

