/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.compressor.RecordCompressor;
import de.rub.nds.tlsattacker.core.record.crypto.Encryptor;
import de.rub.nds.tlsattacker.core.record.preparator.AbstractRecordPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordPreparator
extends AbstractRecordPreparator<Record> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Record record;
    private final Encryptor encryptor;
    private final RecordCompressor compressor;

    public RecordPreparator(Chooser chooser, Record record, Encryptor encryptor, ProtocolMessageType type, RecordCompressor compressor) {
        super(chooser, record, type);
        this.record = record;
        this.encryptor = encryptor;
        this.compressor = compressor;
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing Record");
        this.record.prepareComputations();
        this.prepareContentType(this.record);
        this.prepareProtocolVersion(this.record);
        if (this.isDTLS()) {
            this.prepareEpoch(this.record);
        }
        this.prepareSequenceNumber(this.record);
        this.compressor.compress(this.record);
        if (this.chooser.getSelectedProtocolVersion().isTLS13() && this.record.getContentMessageType() == ProtocolMessageType.CHANGE_CIPHER_SPEC) {
            this.record.prepareComputations();
            this.record.setProtocolMessageBytes((byte[])this.record.getCleanProtocolMessageBytes().getValue());
        } else {
            this.encryptor.encrypt(this.record);
        }
        this.prepareLength(this.record);
    }

    private void prepareContentType(Record record) {
        record.setContentType(this.type.getValue());
        this.prepareConentMessageType(this.type);
        LOGGER.debug("ContentType: " + this.type.getValue());
    }

    private void prepareProtocolVersion(Record record) {
        if (this.chooser.getSelectedProtocolVersion().isTLS13() || this.chooser.getContext().getActiveKeySetTypeWrite() == Tls13KeySetType.EARLY_TRAFFIC_SECRETS) {
            record.setProtocolVersion(ProtocolVersion.TLS12.getValue());
        } else {
            record.setProtocolVersion(this.chooser.getSelectedProtocolVersion().getValue());
        }
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])record.getProtocolVersion().getValue())));
    }

    private boolean isDTLS() {
        return this.chooser.getSelectedProtocolVersion().isDTLS();
    }

    private void prepareEpoch(Record record) {
        record.setEpoch(this.chooser.getContext().getDtlsWriteEpoch());
        LOGGER.debug("Epoch: " + record.getEpoch().getValue());
    }

    private void prepareSequenceNumber(Record record) {
        record.setSequenceNumber(BigInteger.valueOf(this.chooser.getContext().getWriteSequenceNumber()));
        LOGGER.debug("SequenceNumber: " + record.getSequenceNumber().getValue());
    }

    private void prepareLength(Record record) {
        record.setLength(((byte[])record.getProtocolMessageBytes().getValue()).length);
        LOGGER.debug("Length: " + record.getLength().getValue());
    }
}

