/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import org.traccar.api.security.LoginService;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.LogAction;
import org.traccar.helper.WebHelper;
import org.traccar.model.User;
import org.traccar.storage.StorageException;

public class OpenIdProvider {
    private final Boolean force;
    private final ClientID clientId;
    private final ClientAuthentication clientAuth;
    private URI callbackUrl;
    private URI authUrl;
    private URI tokenUrl;
    private URI userInfoUrl;
    private URI baseUrl;
    private final String adminGroup;
    private final String allowGroup;
    private LoginService loginService;

    @Inject
    public OpenIdProvider(Config config, LoginService loginService, HttpClient httpClient, ObjectMapper objectMapper) throws InterruptedException, IOException, URISyntaxException {
        this.loginService = loginService;
        this.force = config.getBoolean(Keys.OPENID_FORCE);
        this.clientId = new ClientID(config.getString(Keys.OPENID_CLIENT_ID));
        this.clientAuth = new ClientSecretBasic(this.clientId, new Secret(config.getString(Keys.OPENID_CLIENT_SECRET)));
        this.baseUrl = new URI(WebHelper.retrieveWebUrl(config));
        this.callbackUrl = new URI(WebHelper.retrieveWebUrl(config) + "/api/session/openid/callback");
        if (config.hasKey(Keys.OPENID_ISSUER_URL)) {
            HttpRequest httpRequest = HttpRequest.newBuilder(URI.create(config.getString(Keys.OPENID_ISSUER_URL) + "/.well-known/openid-configuration")).header("Accept", "application/json").build();
            String httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString()).body();
            Map discoveryMap = (Map)objectMapper.readValue(httpResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
            this.authUrl = new URI((String)discoveryMap.get("authorization_endpoint"));
            this.tokenUrl = new URI((String)discoveryMap.get("token_endpoint"));
            this.userInfoUrl = new URI((String)discoveryMap.get("userinfo_endpoint"));
        } else {
            this.authUrl = new URI(config.getString(Keys.OPENID_AUTH_URL));
            this.tokenUrl = new URI(config.getString(Keys.OPENID_TOKEN_URL));
            this.userInfoUrl = new URI(config.getString(Keys.OPENID_USERINFO_URL));
        }
        this.adminGroup = config.getString(Keys.OPENID_ADMIN_GROUP);
        this.allowGroup = config.getString(Keys.OPENID_ALLOW_GROUP);
    }

    public URI createAuthUri() {
        Scope scope = new Scope(new String[]{"openid", "profile", "email"});
        if (this.adminGroup != null) {
            scope.add("groups");
        }
        AuthenticationRequest.Builder request = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), scope, this.clientId, this.callbackUrl);
        return request.endpointURI(this.authUrl).state(new State()).build().toURI();
    }

    private OIDCTokenResponse getToken(AuthorizationCode code) throws IOException, ParseException, GeneralSecurityException {
        AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant(code, this.callbackUrl);
        TokenRequest tokenRequest = new TokenRequest(this.tokenUrl, this.clientAuth, (AuthorizationGrant)codeGrant);
        HTTPResponse tokenResponse = tokenRequest.toHTTPRequest().send();
        TokenResponse token = OIDCTokenResponseParser.parse((HTTPResponse)tokenResponse);
        if (!token.indicatesSuccess()) {
            throw new GeneralSecurityException("Unable to authenticate with the OpenID Connect provider.");
        }
        return (OIDCTokenResponse)token.toSuccessResponse();
    }

    private UserInfo getUserInfo(BearerAccessToken token) throws IOException, ParseException, GeneralSecurityException {
        HTTPResponse httpResponse = new UserInfoRequest(this.userInfoUrl, (AccessToken)token).toHTTPRequest().send();
        UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
        if (!userInfoResponse.indicatesSuccess()) {
            throw new GeneralSecurityException("Failed to access OpenID Connect user info endpoint. Please contact your administrator.");
        }
        return userInfoResponse.toSuccessResponse().getUserInfo();
    }

    public URI handleCallback(URI requestUri, HttpServletRequest request) throws StorageException, ParseException, IOException, GeneralSecurityException {
        AuthorizationResponse response = AuthorizationResponse.parse((URI)requestUri);
        if (!response.indicatesSuccess()) {
            throw new GeneralSecurityException(response.toErrorResponse().getErrorObject().getDescription());
        }
        AuthorizationCode authCode = response.toSuccessResponse().getAuthorizationCode();
        if (authCode == null) {
            throw new GeneralSecurityException("Malformed OpenID callback.");
        }
        OIDCTokenResponse tokens = this.getToken(authCode);
        BearerAccessToken bearerToken = tokens.getOIDCTokens().getBearerAccessToken();
        UserInfo userInfo = this.getUserInfo(bearerToken);
        List userGroups = userInfo.getStringListClaim("groups");
        Boolean administrator = this.adminGroup != null && userGroups.contains(this.adminGroup);
        if (!administrator.booleanValue() && this.allowGroup != null && !userGroups.contains(this.allowGroup)) {
            throw new GeneralSecurityException("Your OpenID Groups do not permit access to Traccar.");
        }
        User user = this.loginService.login(userInfo.getEmailAddress(), userInfo.getName(), administrator);
        request.getSession().setAttribute("userId", (Object)user.getId());
        LogAction.login(user.getId(), WebHelper.retrieveRemoteAddress(request));
        return this.baseUrl;
    }

    public boolean getForce() {
        return this.force;
    }
}

