/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class WatchFrameDecoder
extends BaseFrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        int brackets = 0;
        int endIndex = -1;
        for (int i = buf.readerIndex(); i < buf.writerIndex(); ++i) {
            byte b = buf.getByte(i);
            switch (b) {
                case 91: {
                    ++brackets;
                    break;
                }
                case 93: {
                    --brackets;
                    break;
                }
            }
            if (brackets != 0 || i <= buf.readerIndex()) continue;
            endIndex = i + 1;
            break;
        }
        if (endIndex > 0) {
            ByteBuf frame = Unpooled.buffer();
            while (buf.readerIndex() < endIndex) {
                byte b1 = buf.readByte();
                if (b1 == 125) {
                    byte b2 = buf.readByte();
                    switch (b2) {
                        case 1: {
                            frame.writeByte(125);
                            break;
                        }
                        case 2: {
                            frame.writeByte(91);
                            break;
                        }
                        case 3: {
                            frame.writeByte(93);
                            break;
                        }
                        case 4: {
                            frame.writeByte(44);
                            break;
                        }
                        case 5: {
                            frame.writeByte(42);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("unexpected byte at %d: 0x%02x", buf.readerIndex() - 1, b2));
                        }
                    }
                    continue;
                }
                frame.writeByte((int)b1);
            }
            return frame;
        }
        return null;
    }
}

