<?php
// This file was auto-generated from sdk-root/src/data/securitylake/2018-05-10/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2018-05-10', 'endpointPrefix' => 'securitylake', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'Amazon Security Lake', 'serviceId' => 'SecurityLake', 'signatureVersion' => 'v4', 'signingName' => 'securitylake', 'uid' => 'securitylake-2018-05-10', ], 'operations' => [ 'CreateAwsLogSource' => [ 'name' => 'CreateAwsLogSource', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/logsources/aws', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateAwsLogSourceRequest', ], 'output' => [ 'shape' => 'CreateAwsLogSourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'S3Exception', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'CreateCustomLogSource' => [ 'name' => 'CreateCustomLogSource', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/logsources/custom', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateCustomLogSourceRequest', ], 'output' => [ 'shape' => 'CreateCustomLogSourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictSourceNamesException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'BucketNotFoundException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'CreateDatalake' => [ 'name' => 'CreateDatalake', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/datalake', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDatalakeRequest', ], 'output' => [ 'shape' => 'CreateDatalakeResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'CreateDatalakeAutoEnable' => [ 'name' => 'CreateDatalakeAutoEnable', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/datalake/autoenable', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDatalakeAutoEnableRequest', ], 'output' => [ 'shape' => 'CreateDatalakeAutoEnableResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'CreateDatalakeDelegatedAdmin' => [ 'name' => 'CreateDatalakeDelegatedAdmin', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/datalake/delegate', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDatalakeDelegatedAdminRequest', ], 'output' => [ 'shape' => 'CreateDatalakeDelegatedAdminResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'CreateDatalakeExceptionsSubscription' => [ 'name' => 'CreateDatalakeExceptionsSubscription', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/datalake/exceptions/subscription', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDatalakeExceptionsSubscriptionRequest', ], 'output' => [ 'shape' => 'CreateDatalakeExceptionsSubscriptionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'CreateSubscriber' => [ 'name' => 'CreateSubscriber', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/subscribers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateSubscriberRequest', ], 'output' => [ 'shape' => 'CreateSubscriberResponse', ], 'errors' => [ [ 'shape' => 'ConflictSubscriptionException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'BucketNotFoundException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'InvalidInputException', ], ], ], 'CreateSubscriptionNotificationConfiguration' => [ 'name' => 'CreateSubscriptionNotificationConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/subscription-notifications/{subscriptionId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateSubscriptionNotificationConfigurationRequest', ], 'output' => [ 'shape' => 'CreateSubscriptionNotificationConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'InvalidInputException', ], ], ], 'DeleteAwsLogSource' => [ 'name' => 'DeleteAwsLogSource', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/logsources/aws/delete', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteAwsLogSourceRequest', ], 'output' => [ 'shape' => 'DeleteAwsLogSourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'DeleteCustomLogSource' => [ 'name' => 'DeleteCustomLogSource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/logsources/custom', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteCustomLogSourceRequest', ], 'output' => [ 'shape' => 'DeleteCustomLogSourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictSourceNamesException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'BucketNotFoundException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], ], 'idempotent' => true, ], 'DeleteDatalake' => [ 'name' => 'DeleteDatalake', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/datalake', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDatalakeRequest', ], 'output' => [ 'shape' => 'DeleteDatalakeResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteDatalakeAutoEnable' => [ 'name' => 'DeleteDatalakeAutoEnable', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/datalake/autoenable/delete', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDatalakeAutoEnableRequest', ], 'output' => [ 'shape' => 'DeleteDatalakeAutoEnableResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'DeleteDatalakeDelegatedAdmin' => [ 'name' => 'DeleteDatalakeDelegatedAdmin', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/datalake/delegate/{account}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDatalakeDelegatedAdminRequest', ], 'output' => [ 'shape' => 'DeleteDatalakeDelegatedAdminResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'DeleteDatalakeExceptionsSubscription' => [ 'name' => 'DeleteDatalakeExceptionsSubscription', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/datalake/exceptions/subscription', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDatalakeExceptionsSubscriptionRequest', ], 'output' => [ 'shape' => 'DeleteDatalakeExceptionsSubscriptionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'DeleteSubscriber' => [ 'name' => 'DeleteSubscriber', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/subscribers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteSubscriberRequest', ], 'output' => [ 'shape' => 'DeleteSubscriberResponse', ], 'errors' => [ [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'BucketNotFoundException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'InvalidInputException', ], ], 'idempotent' => true, ], 'DeleteSubscriptionNotificationConfiguration' => [ 'name' => 'DeleteSubscriptionNotificationConfiguration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/subscription-notifications/{subscriptionId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteSubscriptionNotificationConfigurationRequest', ], 'output' => [ 'shape' => 'DeleteSubscriptionNotificationConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'InvalidInputException', ], ], 'idempotent' => true, ], 'GetDatalake' => [ 'name' => 'GetDatalake', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/datalake', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDatalakeRequest', ], 'output' => [ 'shape' => 'GetDatalakeResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'GetDatalakeAutoEnable' => [ 'name' => 'GetDatalakeAutoEnable', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/datalake/autoenable', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDatalakeAutoEnableRequest', ], 'output' => [ 'shape' => 'GetDatalakeAutoEnableResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'GetDatalakeExceptionsExpiry' => [ 'name' => 'GetDatalakeExceptionsExpiry', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/datalake/exceptions/expiry', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDatalakeExceptionsExpiryRequest', ], 'output' => [ 'shape' => 'GetDatalakeExceptionsExpiryResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'GetDatalakeExceptionsSubscription' => [ 'name' => 'GetDatalakeExceptionsSubscription', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/datalake/exceptions/subscription', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDatalakeExceptionsSubscriptionRequest', ], 'output' => [ 'shape' => 'GetDatalakeExceptionsSubscriptionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'GetDatalakeStatus' => [ 'name' => 'GetDatalakeStatus', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/datalake/status', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDatalakeStatusRequest', ], 'output' => [ 'shape' => 'GetDatalakeStatusResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'GetSubscriber' => [ 'name' => 'GetSubscriber', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/subscribers/{id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSubscriberRequest', ], 'output' => [ 'shape' => 'GetSubscriberResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'InvalidInputException', ], ], ], 'ListDatalakeExceptions' => [ 'name' => 'ListDatalakeExceptions', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/datalake/exceptions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDatalakeExceptionsRequest', ], 'output' => [ 'shape' => 'ListDatalakeExceptionsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'ListLogSources' => [ 'name' => 'ListLogSources', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/logsources/list', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListLogSourcesRequest', ], 'output' => [ 'shape' => 'ListLogSourcesResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'ListSubscribers' => [ 'name' => 'ListSubscribers', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/subscribers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSubscribersRequest', ], 'output' => [ 'shape' => 'ListSubscribersResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'InvalidInputException', ], ], ], 'UpdateDatalake' => [ 'name' => 'UpdateDatalake', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/datalake', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDatalakeRequest', ], 'output' => [ 'shape' => 'UpdateDatalakeResponse', ], 'errors' => [ [ 'shape' => 'EventBridgeException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateDatalakeExceptionsExpiry' => [ 'name' => 'UpdateDatalakeExceptionsExpiry', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/datalake/exceptions/expiry', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDatalakeExceptionsExpiryRequest', ], 'output' => [ 'shape' => 'UpdateDatalakeExceptionsExpiryResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'UpdateDatalakeExceptionsSubscription' => [ 'name' => 'UpdateDatalakeExceptionsSubscription', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/datalake/exceptions/subscription', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDatalakeExceptionsSubscriptionRequest', ], 'output' => [ 'shape' => 'UpdateDatalakeExceptionsSubscriptionResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], ], ], 'UpdateSubscriber' => [ 'name' => 'UpdateSubscriber', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/subscribers/{id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSubscriberRequest', ], 'output' => [ 'shape' => 'UpdateSubscriberResponse', ], 'errors' => [ [ 'shape' => 'ConflictSubscriptionException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'InvalidInputException', ], ], 'idempotent' => true, ], 'UpdateSubscriptionNotificationConfiguration' => [ 'name' => 'UpdateSubscriptionNotificationConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/subscription-notifications/{subscriptionId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSubscriptionNotificationConfigurationRequest', ], 'output' => [ 'shape' => 'UpdateSubscriptionNotificationConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccountNotFoundException', ], [ 'shape' => 'InvalidInputException', ], ], ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AccessType' => [ 'type' => 'string', 'enum' => [ 'LAKEFORMATION', 'S3', ], ], 'AccessTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccessType', ], ], 'AccountList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'AccountNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AccountSources' => [ 'type' => 'structure', 'required' => [ 'account', 'sourceType', ], 'members' => [ 'account' => [ 'shape' => 'String', ], 'eventClass' => [ 'shape' => 'OcsfEventClass', ], 'logsStatus' => [ 'shape' => 'LogsStatusList', ], 'sourceType' => [ 'shape' => 'String', ], ], ], 'AccountSourcesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountSources', ], ], 'AllDimensionsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'TwoDimensionsMap', ], ], 'AutoEnableNewRegionConfiguration' => [ 'type' => 'structure', 'required' => [ 'region', 'sources', ], 'members' => [ 'region' => [ 'shape' => 'Region', ], 'sources' => [ 'shape' => 'AwsSourceTypeList', ], ], ], 'AutoEnableNewRegionConfigurationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AutoEnableNewRegionConfiguration', ], ], 'AwsAccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '^\\d+$', ], 'AwsLogSourceType' => [ 'type' => 'string', 'enum' => [ 'ROUTE53', 'VPC_FLOW', 'CLOUD_TRAIL', 'SH_FINDINGS', ], ], 'AwsSourceTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsLogSourceType', ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'BucketNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ConcurrentModificationException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => false, ], ], 'ConflictException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceId', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ConflictSourceNamesException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ConflictSubscriptionException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'CreateAwsLogSourceRequest' => [ 'type' => 'structure', 'required' => [ 'inputOrder', ], 'members' => [ 'enableAllDimensions' => [ 'shape' => 'AllDimensionsMap', ], 'enableSingleDimension' => [ 'shape' => 'InputSet', ], 'enableTwoDimensions' => [ 'shape' => 'TwoDimensionsMap', ], 'inputOrder' => [ 'shape' => 'DimensionSet', ], ], ], 'CreateAwsLogSourceResponse' => [ 'type' => 'structure', 'members' => [ 'failed' => [ 'shape' => 'AccountList', ], 'processing' => [ 'shape' => 'AccountList', ], ], ], 'CreateCustomLogSourceRequest' => [ 'type' => 'structure', 'required' => [ 'customSourceName', 'eventClass', 'glueInvocationRoleArn', 'logProviderAccountId', ], 'members' => [ 'customSourceName' => [ 'shape' => 'CustomSourceType', ], 'eventClass' => [ 'shape' => 'OcsfEventClass', ], 'glueInvocationRoleArn' => [ 'shape' => 'RoleArn', ], 'logProviderAccountId' => [ 'shape' => 'AwsAccountId', ], ], ], 'CreateCustomLogSourceResponse' => [ 'type' => 'structure', 'required' => [ 'customDataLocation', 'glueCrawlerName', 'glueDatabaseName', 'glueTableName', 'logProviderAccessRoleArn', ], 'members' => [ 'customDataLocation' => [ 'shape' => 'String', ], 'glueCrawlerName' => [ 'shape' => 'String', ], 'glueDatabaseName' => [ 'shape' => 'String', ], 'glueTableName' => [ 'shape' => 'String', ], 'logProviderAccessRoleArn' => [ 'shape' => 'String', ], ], ], 'CreateDatalakeAutoEnableRequest' => [ 'type' => 'structure', 'required' => [ 'configurationForNewAccounts', ], 'members' => [ 'configurationForNewAccounts' => [ 'shape' => 'AutoEnableNewRegionConfigurationList', ], ], ], 'CreateDatalakeAutoEnableResponse' => [ 'type' => 'structure', 'members' => [], ], 'CreateDatalakeDelegatedAdminRequest' => [ 'type' => 'structure', 'required' => [ 'account', ], 'members' => [ 'account' => [ 'shape' => 'SafeString', ], ], ], 'CreateDatalakeDelegatedAdminResponse' => [ 'type' => 'structure', 'members' => [], ], 'CreateDatalakeExceptionsSubscriptionRequest' => [ 'type' => 'structure', 'required' => [ 'notificationEndpoint', 'subscriptionProtocol', ], 'members' => [ 'notificationEndpoint' => [ 'shape' => 'SafeString', ], 'subscriptionProtocol' => [ 'shape' => 'SubscriptionProtocolType', ], ], ], 'CreateDatalakeExceptionsSubscriptionResponse' => [ 'type' => 'structure', 'members' => [], ], 'CreateDatalakeRequest' => [ 'type' => 'structure', 'members' => [ 'configurations' => [ 'shape' => 'LakeConfigurationRequestMap', ], 'enableAll' => [ 'shape' => 'Boolean', ], 'metaStoreManagerRoleArn' => [ 'shape' => 'RoleArn', ], 'regions' => [ 'shape' => 'RegionSet', ], ], ], 'CreateDatalakeResponse' => [ 'type' => 'structure', 'members' => [], ], 'CreateSubscriberRequest' => [ 'type' => 'structure', 'required' => [ 'accountId', 'externalId', 'sourceTypes', 'subscriberName', ], 'members' => [ 'accessTypes' => [ 'shape' => 'AccessTypeList', ], 'accountId' => [ 'shape' => 'AwsAccountId', ], 'externalId' => [ 'shape' => 'SafeString', ], 'sourceTypes' => [ 'shape' => 'SourceTypeList', ], 'subscriberDescription' => [ 'shape' => 'DescriptionString', ], 'subscriberName' => [ 'shape' => 'CreateSubscriberRequestSubscriberNameString', ], ], ], 'CreateSubscriberRequestSubscriberNameString' => [ 'type' => 'string', 'max' => 64, 'min' => 0, ], 'CreateSubscriberResponse' => [ 'type' => 'structure', 'required' => [ 'subscriptionId', ], 'members' => [ 'roleArn' => [ 'shape' => 'RoleArn', ], 's3BucketArn' => [ 'shape' => 'S3BucketArn', ], 'snsArn' => [ 'shape' => 'SnsTopicArn', ], 'subscriptionId' => [ 'shape' => 'UUID', ], ], ], 'CreateSubscriptionNotificationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'subscriptionId', ], 'members' => [ 'createSqs' => [ 'shape' => 'Boolean', ], 'httpsApiKeyName' => [ 'shape' => 'String', ], 'httpsApiKeyValue' => [ 'shape' => 'String', ], 'httpsMethod' => [ 'shape' => 'HttpsMethod', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'subscriptionEndpoint' => [ 'shape' => 'CreateSubscriptionNotificationConfigurationRequestSubscriptionEndpointString', ], 'subscriptionId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'subscriptionId', ], ], ], 'CreateSubscriptionNotificationConfigurationRequestSubscriptionEndpointString' => [ 'type' => 'string', 'pattern' => '^(arn:aws:.+$|https?://.+$)', ], 'CreateSubscriptionNotificationConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'queueArn' => [ 'shape' => 'SafeString', ], ], ], 'CustomSourceType' => [ 'type' => 'string', 'pattern' => '^[\\\\\\w\\-_:/.]*$', ], 'DeleteAwsLogSourceRequest' => [ 'type' => 'structure', 'required' => [ 'inputOrder', ], 'members' => [ 'disableAllDimensions' => [ 'shape' => 'AllDimensionsMap', ], 'disableSingleDimension' => [ 'shape' => 'InputSet', ], 'disableTwoDimensions' => [ 'shape' => 'TwoDimensionsMap', ], 'inputOrder' => [ 'shape' => 'DimensionSet', ], ], ], 'DeleteAwsLogSourceResponse' => [ 'type' => 'structure', 'members' => [ 'failed' => [ 'shape' => 'AccountList', ], 'processing' => [ 'shape' => 'AccountList', ], ], ], 'DeleteCustomLogSourceRequest' => [ 'type' => 'structure', 'required' => [ 'customSourceName', ], 'members' => [ 'customSourceName' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'customSourceName', ], ], ], 'DeleteCustomLogSourceResponse' => [ 'type' => 'structure', 'required' => [ 'customDataLocation', ], 'members' => [ 'customDataLocation' => [ 'shape' => 'String', ], ], ], 'DeleteDatalakeAutoEnableRequest' => [ 'type' => 'structure', 'required' => [ 'removeFromConfigurationForNewAccounts', ], 'members' => [ 'removeFromConfigurationForNewAccounts' => [ 'shape' => 'AutoEnableNewRegionConfigurationList', ], ], ], 'DeleteDatalakeAutoEnableResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDatalakeDelegatedAdminRequest' => [ 'type' => 'structure', 'required' => [ 'account', ], 'members' => [ 'account' => [ 'shape' => 'SafeString', 'location' => 'uri', 'locationName' => 'account', ], ], ], 'DeleteDatalakeDelegatedAdminResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDatalakeExceptionsSubscriptionRequest' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDatalakeExceptionsSubscriptionResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'SafeString', ], ], ], 'DeleteDatalakeRequest' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDatalakeResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteSubscriberRequest' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'id', ], ], ], 'DeleteSubscriberResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteSubscriptionNotificationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'subscriptionId', ], 'members' => [ 'subscriptionId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'subscriptionId', ], ], ], 'DeleteSubscriptionNotificationConfigurationResponse' => [ 'type' => 'structure', 'members' => [], ], 'DescriptionString' => [ 'type' => 'string', 'pattern' => '^[\\\\\\w\\s\\-_:/,.@=+]*$', ], 'Dimension' => [ 'type' => 'string', 'enum' => [ 'REGION', 'SOURCE_TYPE', 'MEMBER', ], ], 'DimensionSet' => [ 'type' => 'list', 'member' => [ 'shape' => 'Dimension', ], ], 'EndpointProtocol' => [ 'type' => 'string', 'enum' => [ 'HTTPS', 'SQS', ], ], 'EventBridgeException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'Failures' => [ 'type' => 'structure', 'required' => [ 'exceptionMessage', 'remediation', 'timestamp', ], 'members' => [ 'exceptionMessage' => [ 'shape' => 'SafeString', ], 'remediation' => [ 'shape' => 'SafeString', ], 'timestamp' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], ], 'FailuresResponse' => [ 'type' => 'structure', 'members' => [ 'failures' => [ 'shape' => 'Failureslist', ], 'region' => [ 'shape' => 'SafeString', ], ], ], 'FailuresResponseList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FailuresResponse', ], ], 'Failureslist' => [ 'type' => 'list', 'member' => [ 'shape' => 'Failures', ], ], 'GetDatalakeAutoEnableRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetDatalakeAutoEnableResponse' => [ 'type' => 'structure', 'required' => [ 'autoEnableNewAccounts', ], 'members' => [ 'autoEnableNewAccounts' => [ 'shape' => 'AutoEnableNewRegionConfigurationList', ], ], ], 'GetDatalakeExceptionsExpiryRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetDatalakeExceptionsExpiryResponse' => [ 'type' => 'structure', 'required' => [ 'exceptionMessageExpiry', ], 'members' => [ 'exceptionMessageExpiry' => [ 'shape' => 'Long', ], ], ], 'GetDatalakeExceptionsSubscriptionRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetDatalakeExceptionsSubscriptionResponse' => [ 'type' => 'structure', 'required' => [ 'protocolAndNotificationEndpoint', ], 'members' => [ 'protocolAndNotificationEndpoint' => [ 'shape' => 'ProtocolAndNotificationEndpoint', ], ], ], 'GetDatalakeRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetDatalakeResponse' => [ 'type' => 'structure', 'required' => [ 'configurations', ], 'members' => [ 'configurations' => [ 'shape' => 'LakeConfigurationResponseMap', ], ], ], 'GetDatalakeStatusRequest' => [ 'type' => 'structure', 'members' => [ 'accountSet' => [ 'shape' => 'InputSet', ], 'maxAccountResults' => [ 'shape' => 'Integer', ], 'nextToken' => [ 'shape' => 'SafeString', ], ], ], 'GetDatalakeStatusResponse' => [ 'type' => 'structure', 'required' => [ 'accountSourcesList', ], 'members' => [ 'accountSourcesList' => [ 'shape' => 'AccountSourcesList', ], 'nextToken' => [ 'shape' => 'SafeString', ], ], ], 'GetSubscriberRequest' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'id', ], ], ], 'GetSubscriberResponse' => [ 'type' => 'structure', 'members' => [ 'subscriber' => [ 'shape' => 'SubscriberResource', ], ], ], 'HttpsMethod' => [ 'type' => 'string', 'enum' => [ 'POST', 'PUT', ], ], 'InputSet' => [ 'type' => 'list', 'member' => [ 'shape' => 'SafeString', ], ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServerException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'retryAfterSeconds' => [ 'shape' => 'Integer', 'location' => 'header', 'locationName' => 'Retry-After', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'InvalidInputException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'LakeConfigurationRequest' => [ 'type' => 'structure', 'members' => [ 'encryptionKey' => [ 'shape' => 'String', ], 'replicationDestinationRegions' => [ 'shape' => 'RegionSet', ], 'replicationRoleArn' => [ 'shape' => 'RoleArn', ], 'retentionSettings' => [ 'shape' => 'RetentionSettingList', ], 'tagsMap' => [ 'shape' => 'TagsMap', ], ], ], 'LakeConfigurationRequestMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'Region', ], 'value' => [ 'shape' => 'LakeConfigurationRequest', ], ], 'LakeConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'encryptionKey' => [ 'shape' => 'String', ], 'replicationDestinationRegions' => [ 'shape' => 'RegionSet', ], 'replicationRoleArn' => [ 'shape' => 'RoleArn', ], 'retentionSettings' => [ 'shape' => 'RetentionSettingList', ], 's3BucketArn' => [ 'shape' => 'S3BucketArn', ], 'status' => [ 'shape' => 'settingsStatus', ], 'tagsMap' => [ 'shape' => 'TagsMap', ], ], ], 'LakeConfigurationResponseMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'Region', ], 'value' => [ 'shape' => 'LakeConfigurationResponse', ], ], 'ListDatalakeExceptionsRequest' => [ 'type' => 'structure', 'members' => [ 'maxFailures' => [ 'shape' => 'Integer', ], 'nextToken' => [ 'shape' => 'SafeString', ], 'regionSet' => [ 'shape' => 'RegionSet', ], ], ], 'ListDatalakeExceptionsResponse' => [ 'type' => 'structure', 'required' => [ 'nonRetryableFailures', ], 'members' => [ 'nextToken' => [ 'shape' => 'SafeString', ], 'nonRetryableFailures' => [ 'shape' => 'FailuresResponseList', ], ], ], 'ListLogSourcesRequest' => [ 'type' => 'structure', 'members' => [ 'inputOrder' => [ 'shape' => 'DimensionSet', ], 'listAllDimensions' => [ 'shape' => 'AllDimensionsMap', ], 'listSingleDimension' => [ 'shape' => 'InputSet', ], 'listTwoDimensions' => [ 'shape' => 'TwoDimensionsMap', ], 'maxResults' => [ 'shape' => 'Integer', ], 'nextToken' => [ 'shape' => 'SafeString', ], ], ], 'ListLogSourcesResponse' => [ 'type' => 'structure', 'required' => [ 'regionSourceTypesAccountsList', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'regionSourceTypesAccountsList' => [ 'shape' => 'RegionSourceTypesAccountsList', ], ], ], 'ListSubscribersRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListSubscribersResponse' => [ 'type' => 'structure', 'required' => [ 'subscribers', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'subscribers' => [ 'shape' => 'SubscriberList', ], ], ], 'LogsStatus' => [ 'type' => 'structure', 'required' => [ 'healthStatus', 'pathToLogs', ], 'members' => [ 'healthStatus' => [ 'shape' => 'SourceStatus', ], 'pathToLogs' => [ 'shape' => 'String', ], ], ], 'LogsStatusList' => [ 'type' => 'list', 'member' => [ 'shape' => 'LogsStatus', ], ], 'Long' => [ 'type' => 'long', 'box' => true, ], 'OcsfEventClass' => [ 'type' => 'string', 'enum' => [ 'ACCESS_ACTIVITY', 'FILE_ACTIVITY', 'KERNEL_ACTIVITY', 'KERNEL_EXTENSION', 'MEMORY_ACTIVITY', 'MODULE_ACTIVITY', 'PROCESS_ACTIVITY', 'REGISTRY_KEY_ACTIVITY', 'REGISTRY_VALUE_ACTIVITY', 'RESOURCE_ACTIVITY', 'SCHEDULED_JOB_ACTIVITY', 'SECURITY_FINDING', 'ACCOUNT_CHANGE', 'AUTHENTICATION', 'AUTHORIZATION', 'ENTITY_MANAGEMENT_AUDIT', 'DHCP_ACTIVITY', 'NETWORK_ACTIVITY', 'DNS_ACTIVITY', 'FTP_ACTIVITY', 'HTTP_ACTIVITY', 'RDP_ACTIVITY', 'SMB_ACTIVITY', 'SSH_ACTIVITY', 'CLOUD_API', 'CONTAINER_LIFECYCLE', 'DATABASE_LIFECYCLE', 'CONFIG_STATE', 'CLOUD_STORAGE', 'INVENTORY_INFO', 'RFB_ACTIVITY', 'SMTP_ACTIVITY', 'VIRTUAL_MACHINE_ACTIVITY', ], ], 'ProtocolAndNotificationEndpoint' => [ 'type' => 'structure', 'members' => [ 'endpoint' => [ 'shape' => 'SafeString', ], 'protocol' => [ 'shape' => 'SafeString', ], ], ], 'Region' => [ 'type' => 'string', 'enum' => [ 'us-east-1', 'us-west-2', 'eu-central-1', 'us-east-2', 'eu-west-1', 'ap-northeast-1', 'ap-southeast-2', ], ], 'RegionSet' => [ 'type' => 'list', 'member' => [ 'shape' => 'Region', ], ], 'RegionSourceTypesAccountsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AllDimensionsMap', ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceId', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'RetentionSetting' => [ 'type' => 'structure', 'members' => [ 'retentionPeriod' => [ 'shape' => 'RetentionSettingRetentionPeriodInteger', ], 'storageClass' => [ 'shape' => 'StorageClass', ], ], ], 'RetentionSettingList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RetentionSetting', ], ], 'RetentionSettingRetentionPeriodInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 1, ], 'RoleArn' => [ 'type' => 'string', 'pattern' => '^arn:.*', ], 'S3BucketArn' => [ 'type' => 'string', ], 'S3Exception' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'SafeString' => [ 'type' => 'string', 'pattern' => '^[\\\\\\w\\-_:/.@=+]*$', ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'required' => [ 'message', 'quotaCode', 'resourceId', 'resourceType', 'serviceCode', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'quotaCode' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'String', ], 'serviceCode' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SnsTopicArn' => [ 'type' => 'string', ], 'SourceStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DEACTIVATED', 'PENDING', ], ], 'SourceType' => [ 'type' => 'structure', 'members' => [ 'awsSourceType' => [ 'shape' => 'AwsLogSourceType', ], 'customSourceType' => [ 'shape' => 'CustomSourceType', ], ], 'union' => true, ], 'SourceTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SourceType', ], ], 'StorageClass' => [ 'type' => 'string', 'enum' => [ 'STANDARD_IA', 'ONEZONE_IA', 'INTELLIGENT_TIERING', 'GLACIER_IR', 'GLACIER', 'DEEP_ARCHIVE', 'EXPIRE', ], ], 'String' => [ 'type' => 'string', ], 'SubscriberList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscriberResource', ], ], 'SubscriberResource' => [ 'type' => 'structure', 'required' => [ 'accountId', 'sourceTypes', 'subscriptionId', ], 'members' => [ 'accessTypes' => [ 'shape' => 'AccessTypeList', ], 'accountId' => [ 'shape' => 'AwsAccountId', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'externalId' => [ 'shape' => 'SafeString', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 's3BucketArn' => [ 'shape' => 'S3BucketArn', ], 'snsArn' => [ 'shape' => 'SnsTopicArn', ], 'sourceTypes' => [ 'shape' => 'SourceTypeList', ], 'subscriberDescription' => [ 'shape' => 'SafeString', ], 'subscriberName' => [ 'shape' => 'SafeString', ], 'subscriptionEndpoint' => [ 'shape' => 'String', ], 'subscriptionId' => [ 'shape' => 'UUID', ], 'subscriptionProtocol' => [ 'shape' => 'EndpointProtocol', ], 'subscriptionStatus' => [ 'shape' => 'SubscriptionStatus', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], ], 'SubscriptionProtocolType' => [ 'type' => 'string', 'enum' => [ 'HTTP', 'HTTPS', 'EMAIL', 'EMAIL_JSON', 'SMS', 'SQS', 'LAMBDA', 'APP', 'FIREHOSE', ], ], 'SubscriptionStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DEACTIVATED', 'PENDING', 'READY', ], ], 'SyntheticTimestamp_date_time' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'TagsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'ThrottlingException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'quotaCode' => [ 'shape' => 'String', ], 'retryAfterSeconds' => [ 'shape' => 'Integer', 'location' => 'header', 'locationName' => 'Retry-After', ], 'serviceCode' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => true, ], ], 'TwoDimensionsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'ValueSet', ], ], 'UUID' => [ 'type' => 'string', 'pattern' => '[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', ], 'UpdateDatalakeExceptionsExpiryRequest' => [ 'type' => 'structure', 'required' => [ 'exceptionMessageExpiry', ], 'members' => [ 'exceptionMessageExpiry' => [ 'shape' => 'UpdateDatalakeExceptionsExpiryRequestExceptionMessageExpiryLong', ], ], ], 'UpdateDatalakeExceptionsExpiryRequestExceptionMessageExpiryLong' => [ 'type' => 'long', 'box' => true, 'min' => 1, ], 'UpdateDatalakeExceptionsExpiryResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateDatalakeExceptionsSubscriptionRequest' => [ 'type' => 'structure', 'required' => [ 'notificationEndpoint', 'subscriptionProtocol', ], 'members' => [ 'notificationEndpoint' => [ 'shape' => 'SafeString', ], 'subscriptionProtocol' => [ 'shape' => 'SubscriptionProtocolType', ], ], ], 'UpdateDatalakeExceptionsSubscriptionResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateDatalakeRequest' => [ 'type' => 'structure', 'required' => [ 'configurations', ], 'members' => [ 'configurations' => [ 'shape' => 'LakeConfigurationRequestMap', ], ], ], 'UpdateDatalakeResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateSubscriberRequest' => [ 'type' => 'structure', 'required' => [ 'id', 'sourceTypes', ], 'members' => [ 'externalId' => [ 'shape' => 'SafeString', ], 'id' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'id', ], 'sourceTypes' => [ 'shape' => 'SourceTypeList', ], 'subscriberDescription' => [ 'shape' => 'DescriptionString', ], 'subscriberName' => [ 'shape' => 'UpdateSubscriberRequestSubscriberNameString', ], ], ], 'UpdateSubscriberRequestSubscriberNameString' => [ 'type' => 'string', 'max' => 64, 'min' => 0, 'pattern' => '^[\\\\\\w\\-_:/.@=+]*$', ], 'UpdateSubscriberResponse' => [ 'type' => 'structure', 'members' => [ 'subscriber' => [ 'shape' => 'SubscriberResource', ], ], ], 'UpdateSubscriptionNotificationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'subscriptionId', ], 'members' => [ 'createSqs' => [ 'shape' => 'Boolean', ], 'httpsApiKeyName' => [ 'shape' => 'String', ], 'httpsApiKeyValue' => [ 'shape' => 'String', ], 'httpsMethod' => [ 'shape' => 'HttpsMethod', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'subscriptionEndpoint' => [ 'shape' => 'UpdateSubscriptionNotificationConfigurationRequestSubscriptionEndpointString', ], 'subscriptionId' => [ 'shape' => 'UUID', 'location' => 'uri', 'locationName' => 'subscriptionId', ], ], ], 'UpdateSubscriptionNotificationConfigurationRequestSubscriptionEndpointString' => [ 'type' => 'string', 'pattern' => '^(arn:aws:.+$|https?://.+$)', ], 'UpdateSubscriptionNotificationConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'queueArn' => [ 'shape' => 'SafeString', ], ], ], 'ValidationException' => [ 'type' => 'structure', 'required' => [ 'message', 'reason', ], 'members' => [ 'fieldList' => [ 'shape' => 'ValidationExceptionFieldList', ], 'message' => [ 'shape' => 'String', ], 'reason' => [ 'shape' => 'ValidationExceptionReason', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'required' => [ 'message', 'name', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'name' => [ 'shape' => 'String', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'ValidationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'unknownOperation', 'cannotParse', 'fieldValidationFailed', 'other', ], ], 'ValueSet' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'settingsStatus' => [ 'type' => 'string', 'enum' => [ 'INITIALIZED', 'PENDING', 'COMPLETED', 'FAILED', ], ], ],];
