/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.mordant.internal.AnsiCodes;
import com.github.ajalt.mordant.internal.Chunk;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.TxtStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\u001a,\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0002\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0000\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u0002\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002\u001a \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\rH\u0000\u001a \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"LS", "", "NEL", "getAnsiColor", "Lkotlin/Pair;", "Lcom/github/ajalt/colormath/Color;", "", "i", "codes", "", "parseAnsi", "Lcom/github/ajalt/mordant/internal/Chunk;", "text", "", "defaultStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "parseText", "Lcom/github/ajalt/mordant/rendering/Lines;", "style", "splitLines", "Lcom/github/ajalt/mordant/rendering/Line;", "words", "", "splitWords", "chunk", "updateStyle", "existingStyle", "ansi", "updateStyleWithCsi", "updateStyleWithOsc", "mordant"})
public final class ParsingKt {
    private static final char NEL = '\u0085';
    private static final char LS = '\u2028';

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Lines parseText(@NotNull String text, @NotNull TextStyle style) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(style, "style");
        List<Chunk> parseAnsi = ParsingKt.parseAnsi(text, style);
        Iterable $this$flatMap$iv = parseAnsi;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Chunk it = (Chunk)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ParsingKt.splitWords(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List words2 = CollectionsKt.toList((List)destination$iv$iv);
        List<Line> splitLines = ParsingKt.splitLines(words2);
        return new Lines(splitLines);
    }

    private static final List<Chunk> parseAnsi(String text, TextStyle defaultStyle) {
        List<MatchResult> commands = SequencesKt.toList(Regex.findAll$default(ConstantsKt.getANSI_RE(), text, 0, 2, null));
        if (commands.isEmpty()) {
            return CollectionsKt.listOf(new Chunk(text, defaultStyle));
        }
        boolean bl = false;
        List parts = new ArrayList();
        int idxAfterLastCmd = 0;
        TextStyle style = defaultStyle;
        for (MatchResult command : commands) {
            if (command.getRange().getFirst() > idxAfterLastCmd) {
                Collection collection = parts;
                Object object = text;
                int n = command.getRange().getFirst();
                boolean bl2 = false;
                String string = object;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = string.substring(idxAfterLastCmd, n);
                Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object = new Chunk(string2, style);
                n = 0;
                collection.add(object);
            }
            idxAfterLastCmd = command.getRange().getLast() + 1;
            style = ParsingKt.updateStyle(style, defaultStyle, command.getValue());
        }
        if (idxAfterLastCmd < text.length()) {
            Collection collection = parts;
            Object object = text;
            boolean bl3 = false;
            String string = object;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string.substring(idxAfterLastCmd);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
            object = new Chunk(string3, style);
            bl3 = false;
            collection.add(object);
        }
        return parts;
    }

    private static final List<Chunk> splitWords(Chunk chunk) {
        int i;
        boolean bl = false;
        List chunks = new ArrayList();
        int start = 0;
        int chunkType = -1;
        String t = chunk.getText();
        for (i = 0; i < t.length(); ++i) {
            int type;
            char c = t.charAt(i);
            int n = c == '\r' ? 0 : (c == '\n' || c == '\t' || c == '\u0085' || c == '\u2028' ? 1 : (type = CharsKt.isWhitespace(c) ? 2 : 3));
            if (i == 0) {
                chunkType = type;
                continue;
            }
            if (type != 1 && chunkType == type) continue;
            Collection collection = chunks;
            Object object = t;
            boolean bl2 = false;
            String string = object;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.substring(start, i);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = Chunk.copy$default(chunk, string2, null, 2, null);
            bl2 = false;
            collection.add(object);
            start = i;
            chunkType = type;
        }
        if (start != i) {
            Collection collection = chunks;
            Object object = t;
            boolean bl3 = false;
            String string = object;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string.substring(start, i);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = Chunk.copy$default(chunk, string3, null, 2, null);
            bl3 = false;
            collection.add(object);
        }
        return chunks;
    }

    private static final List<Line> splitLines(Iterable<Chunk> words2) {
        boolean bl;
        boolean bl2 = false;
        List lines = new ArrayList();
        boolean bl3 = false;
        List line = new ArrayList();
        for (Chunk word : words2) {
            if (StringsKt.endsWith$default(word.getText(), "\n", false, 2, null)) {
                Collection collection = lines;
                Line line2 = new Line(line, word.getStyle());
                boolean bl4 = false;
                collection.add(line2);
                bl = false;
                line = new ArrayList();
                continue;
            }
            line.add(Span.Companion.word(word.getText(), word.getStyle()));
        }
        Object object = line;
        boolean bl5 = false;
        if (!object.isEmpty()) {
            object = lines;
            Line line3 = new Line(line);
            bl = false;
            object.add(line3);
        }
        return lines;
    }

    @NotNull
    public static final TextStyle updateStyle(@NotNull TextStyle existingStyle, @NotNull TextStyle defaultStyle, @NotNull String ansi) {
        Intrinsics.checkNotNullParameter(existingStyle, "existingStyle");
        Intrinsics.checkNotNullParameter(defaultStyle, "defaultStyle");
        Intrinsics.checkNotNullParameter(ansi, "ansi");
        if (StringsKt.startsWith$default(ansi, "\u001b]", false, 2, null)) {
            return ParsingKt.updateStyleWithOsc(ansi, existingStyle, defaultStyle);
        }
        if (StringsKt.startsWith$default(ansi, "\u001b[", false, 2, null)) {
            return ParsingKt.updateStyleWithCsi(ansi, existingStyle, defaultStyle);
        }
        return existingStyle;
    }

    private static final TextStyle updateStyleWithOsc(String ansi, TextStyle existingStyle, TextStyle defaultStyle) {
        String string;
        if (!StringsKt.startsWith$default((String)ansi, "\u001b]8", false, 2, null)) {
            return existingStyle;
        }
        String[] stringArray = ansi;
        int n = 3;
        int n2 = ansi.length() - 2;
        boolean bl = false;
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = stringArray.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        stringArray = new String[]{";"};
        List params = StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null);
        if (params.isEmpty()) {
            return existingStyle;
        }
        Object t = CollectionsKt.last(params);
        n2 = 0;
        bl = false;
        String it = (String)t;
        boolean bl2 = false;
        String hyperlink = (String)(!StringsKt.isBlank(it) ? t : null);
        if (hyperlink == null) {
            string = defaultStyle.getHyperlinkId();
        } else {
            Object v2;
            block6: {
                Iterable iterable = params;
                boolean bl3 = false;
                Iterable iterable2 = iterable;
                boolean bl4 = false;
                for (Object t2 : iterable2) {
                    String it2 = (String)t2;
                    boolean bl5 = false;
                    if (!StringsKt.startsWith$default(it2, "id=", false, 2, null)) continue;
                    v2 = t2;
                    break block6;
                }
                v2 = null;
            }
            String string3 = v2;
            string = string3 == null ? null : StringsKt.drop(string3, 3);
        }
        String id = string;
        String string4 = hyperlink;
        return TextStyleKt.copy$default(existingStyle, null, null, string4 == null ? defaultStyle.getHyperlink() : string4, id, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final TextStyle updateStyleWithCsi(String ansi, TextStyle existingStyle, TextStyle defaultStyle) {
        void $this$mapNotNullTo$iv$iv;
        if (!StringsKt.endsWith$default(ansi, "m", false, 2, null)) {
            return existingStyle;
        }
        String[] stringArray = new String[]{";"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default(ansi.subSequence(2, ansi.length() - 1), stringArray, false, 0, 6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer n;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence = it;
            boolean bl3 = false;
            if ((charSequence.length() == 0 ? Integer.valueOf(0) : StringsKt.toIntOrNull(it)) == null) continue;
            n = n;
            boolean bl4 = false;
            boolean bl5 = false;
            Integer it$iv$iv = n;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List codes = (List)destination$iv$iv;
        if (codes.isEmpty()) {
            return defaultStyle;
        }
        Color color = existingStyle.getColor();
        Color bgColor = existingStyle.getBgColor();
        boolean bold = existingStyle.getBold();
        boolean italic = existingStyle.getItalic();
        boolean underline = existingStyle.getUnderline();
        boolean dim = existingStyle.getDim();
        boolean inverse = existingStyle.getInverse();
        boolean strikethrough = existingStyle.getStrikethrough();
        for (int i = 0; i <= CollectionsKt.getLastIndex(codes); ++i) {
            int n;
            int consumed;
            boolean bl;
            boolean bl7;
            int code = ((Number)codes.get(i)).intValue();
            if (code == 0) {
                color = existingStyle.getColor();
                bgColor = existingStyle.getBgColor();
                bold = existingStyle.getBold();
                italic = existingStyle.getItalic();
                underline = existingStyle.getUnderline();
                dim = existingStyle.getDim();
                inverse = existingStyle.getInverse();
                strikethrough = existingStyle.getStrikethrough();
                continue;
            }
            if (code == 22) {
                bold = defaultStyle.getBold();
                dim = defaultStyle.getDim();
                continue;
            }
            if (code == 23) {
                italic = defaultStyle.getItalic();
                continue;
            }
            if (code == 24) {
                underline = defaultStyle.getUnderline();
                continue;
            }
            if (code == 27) {
                inverse = defaultStyle.getInverse();
                continue;
            }
            if (code == 29) {
                strikethrough = defaultStyle.getStrikethrough();
                continue;
            }
            if (code == 39) {
                color = defaultStyle.getColor();
                continue;
            }
            if (code == 49) {
                bgColor = defaultStyle.getBgColor();
                continue;
            }
            Pair<Color, Integer> pair2 = AnsiCodes.INSTANCE.getFg16Range();
            int it = ((IntProgression)((Object)pair2)).getFirst();
            boolean bl8 = code <= ((IntProgression)((Object)pair2)).getLast() ? it <= code : false;
            if (bl8) {
                bl7 = true;
            } else {
                pair2 = AnsiCodes.INSTANCE.getFg16BrightRange();
                it = ((IntProgression)((Object)pair2)).getFirst();
                bl7 = code <= ((IntProgression)((Object)pair2)).getLast() ? it <= code : false;
            }
            if (bl7) {
                color = new Ansi16(code);
                continue;
            }
            pair2 = AnsiCodes.INSTANCE.getBg16Range();
            it = ((IntProgression)((Object)pair2)).getFirst();
            boolean bl9 = code <= ((IntProgression)((Object)pair2)).getLast() ? it <= code : false;
            if (bl9) {
                bl = true;
            } else {
                pair2 = AnsiCodes.INSTANCE.getBg16BrightRange();
                it = ((IntProgression)((Object)pair2)).getFirst();
                bl = code <= ((IntProgression)((Object)pair2)).getLast() ? it <= code : false;
            }
            if (bl) {
                bgColor = new Ansi16(code - 10);
                continue;
            }
            if (code == 38) {
                pair2 = ParsingKt.getAnsiColor(i + 1, codes);
                Color c = (Color)pair2.component1();
                consumed = ((Number)pair2.component2()).intValue();
                if (c == null) break;
                color = c;
                i += consumed;
                continue;
            }
            if (code == 48) {
                pair2 = ParsingKt.getAnsiColor(i + 1, codes);
                Color c = pair2.component1();
                consumed = ((Number)pair2.component2()).intValue();
                if (c == null) break;
                bgColor = c;
                i += consumed;
                continue;
            }
            if (code == 1) {
                bold = true;
                continue;
            }
            if (code == 3) {
                italic = true;
                continue;
            }
            if (code == 4) {
                underline = true;
                continue;
            }
            if (code == 2) {
                dim = true;
                continue;
            }
            if (code == 7) {
                inverse = true;
                continue;
            }
            if (code == 9) {
                strikethrough = true;
                continue;
            }
            if (code != 58) continue;
            if (i == CollectionsKt.getLastIndex(codes)) {
                n = 0;
            } else {
                Integer n2 = (Integer)CollectionsKt.getOrNull(codes, i + 1);
                int n3 = 5;
                if (n2 != null && n2 == n3) {
                    n = 1;
                } else {
                    Integer n4 = (Integer)CollectionsKt.getOrNull(codes, i + 1);
                    n3 = 2;
                    if (n4 == null || n4 != n3) break;
                    n = 3;
                }
            }
            i = i + n;
        }
        return new TxtStyle(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, existingStyle.getHyperlink(), existingStyle.getHyperlinkId());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Pair<Color, Integer> getAnsiColor(int i, List<Integer> codes) {
        Pair<Object, Integer> pair2;
        int n = ((Number)codes.get(i)).intValue();
        switch (n) {
            case 5: {
                if (i + 1 <= CollectionsKt.getLastIndex(codes)) {
                    int n2 = ((Number)codes.get(i + 1)).intValue();
                    boolean bl = 0 <= n2 ? n2 <= 255 : false;
                    if (bl) {
                        pair2 = TuplesKt.to(new Ansi256(((Number)codes.get(i + 1)).intValue()), 2);
                        return pair2;
                    }
                }
                pair2 = TuplesKt.to(null, 0);
                return pair2;
            }
            case 2: {
                if (i + 3 <= CollectionsKt.getLastIndex(codes)) {
                    int n3 = ((Number)codes.get(i + 1)).intValue();
                    boolean bl = 0 <= n3 ? n3 <= 255 : false;
                    if (bl) {
                        n3 = ((Number)codes.get(i + 2)).intValue();
                        boolean bl2 = 0 <= n3 ? n3 <= 255 : false;
                        if (bl2) {
                            n3 = ((Number)codes.get(i + 3)).intValue();
                            boolean bl3 = 0 <= n3 ? n3 <= 255 : false;
                            if (bl3) {
                                pair2 = TuplesKt.to(RGBColorSpace.DefaultImpls.from255$default(RGB.Companion, ((Number)codes.get(i + 1)).intValue(), ((Number)codes.get(i + 2)).intValue(), ((Number)codes.get(i + 3)).intValue(), 0, 8, null), 4);
                                return pair2;
                            }
                        }
                    }
                }
                pair2 = TuplesKt.to(null, 0);
                return pair2;
            }
        }
        pair2 = TuplesKt.to(null, 0);
        return pair2;
    }
}

