"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiPaginationButton", {
  enumerable: true,
  get: function get() {
    return _pagination_button.EuiPaginationButton;
  }
});
exports.OuiPaginationButton = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _button = require("../button");

var _i18n = require("../i18n");

var _pagination_button = require("../../eui_components/pagination/pagination_button");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var OuiPaginationButton = function OuiPaginationButton(_ref) {
  var className = _ref.className,
      isActive = _ref.isActive,
      isPlaceholder = _ref.isPlaceholder,
      hideOnMobile = _ref.hideOnMobile,
      pageIndex = _ref.pageIndex,
      totalPages = _ref.totalPages,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "isActive", "isPlaceholder", "hideOnMobile", "pageIndex", "totalPages"]);
  var classes = (0, _classnames.default)('ouiPaginationButton', className, {
    'ouiPaginationButton-isActive': isActive,
    'ouiPaginationButton-isPlaceholder': isPlaceholder,
    'ouiPaginationButton--hideOnMobile': hideOnMobile
  });

  var props = _objectSpread(_objectSpread(_objectSpread({
    className: classes,
    size: 's',
    color: 'text',
    'data-test-subj': "pagination-button-".concat(pageIndex),
    isDisabled: isPlaceholder || isActive
  }, isActive && {
    'aria-current': true
  }), rest['aria-controls'] && {
    href: "#".concat(rest['aria-controls'])
  }), rest);

  var pageNumber = pageIndex + 1;
  return /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    token: "ouiPaginationButton.longPageString",
    default: "Page {page} of {totalPages}",
    values: {
      page: pageNumber,
      totalPages: totalPages
    }
  }, function (longPageString) {
    return /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      token: "ouiPaginationButton.shortPageString",
      default: "Page {page}",
      values: {
        page: pageNumber
      }
    }, function (shortPageString) {
      return /*#__PURE__*/_react.default.createElement(_button.OuiButtonEmpty, (0, _extends2.default)({
        "aria-label": totalPages ? longPageString : shortPageString
      }, props), pageNumber);
    });
  });
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiPaginationButton = OuiPaginationButton;
OuiPaginationButton.propTypes = {
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  isActive: _propTypes.default.bool,

  /**
     * For ellipsis or other non-clickable buttons.
     */

  /**
     * For ellipsis or other non-clickable buttons.
     */
  isPlaceholder: _propTypes.default.bool,
  hideOnMobile: _propTypes.default.bool,
  pageIndex: _propTypes.default.number.isRequired,
  totalPages: _propTypes.default.number
};