/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.openid.token;

import com.google.inject.Singleton;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class NonceService {
    private final SecureRandom random = new SecureRandom();
    private final Map<String, Long> nonces = new ConcurrentHashMap<String, Long>();
    private long lastSweep = System.currentTimeMillis();
    private static final long SWEEP_INTERVAL = 60000L;

    private void sweepExpiredNonces() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSweep < 60000L) {
            return;
        }
        this.lastSweep = currentTime;
        Iterator<Map.Entry<String, Long>> entries = this.nonces.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, Long> current = entries.next();
            if (current.getValue() > System.currentTimeMillis()) continue;
            entries.remove();
        }
    }

    public String generate(long maxAge) {
        this.sweepExpiredNonces();
        String nonce = new BigInteger(130, this.random).toString(32);
        this.nonces.put(nonce, System.currentTimeMillis() + maxAge);
        return nonce;
    }

    public boolean isValid(String nonce) {
        Long expires = this.nonces.remove(nonce);
        if (expires == null) {
            return false;
        }
        return expires > System.currentTimeMillis();
    }
}

