/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.saml.acs;

import com.google.inject.Inject;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.saml.acs.AuthenticationSession;
import org.apache.guacamole.auth.saml.acs.AuthenticationSessionManager;
import org.apache.guacamole.auth.saml.acs.SAMLService;
import org.apache.guacamole.auth.saml.conf.ConfigurationService;
import org.apache.guacamole.auth.sso.SSOResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionConsumerServiceResource
extends SSOResource {
    private static final Logger logger = LoggerFactory.getLogger(AssertionConsumerServiceResource.class);
    @Inject
    private ConfigurationService confService;
    @Inject
    private AuthenticationSessionManager sessionManager;
    @Inject
    private SAMLService saml;

    @POST
    @Path(value="callback")
    public Response processSamlResponse(@FormParam(value="RelayState") String relayState, @FormParam(value="SAMLResponse") String samlResponse, @Context HttpServletRequest consumedRequest) throws GuacamoleException {
        URI guacBase = this.confService.getCallbackUrl();
        try {
            AuthenticationSession session = this.saml.processResponse(consumedRequest.getRequestURL().toString(), relayState, samlResponse);
            String identifier = this.sessionManager.defer(session);
            return Response.seeOther((URI)UriBuilder.fromUri((URI)guacBase).queryParam("state", new Object[]{identifier}).build(new Object[0])).build();
        }
        catch (GuacamoleException e) {
            logger.warn("Authentication attempted with an invalid SAML response: {}", (Object)e.getMessage());
            logger.debug("Received SAML response failed validation.", (Throwable)e);
            return Response.seeOther((URI)guacBase).build();
        }
    }
}

