"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportsDashboardsPlugin = void 0;

var _configSchema = require("@osd/config-schema");

var _opensearchReportsPlugin = _interopRequireDefault(require("./backend/opensearch-reports-plugin"));

var _notificationsPlugin = require("./clusters/notificationsPlugin");

var _config = require("./config");

var _routes = _interopRequireDefault(require("./routes"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReportsDashboardsPlugin {
  constructor(context) {
    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "initializerContext", void 0);

    _defineProperty(this, "reportingConfig", void 0);

    this.logger = context.logger.get();
    this.initializerContext = context;
  }

  async setup(core) {
    this.logger.debug('reports-dashboards: Setup');
    core.uiSettings.register({
      'reporting:useOcr': {
        name: 'Reporting use OCR on PDF',
        value: false,
        description: 'Whether to run optical character recognition on PDF reports to make text selectable',
        schema: _configSchema.schema.boolean()
      },
      'reporting:useFOR': {
        name: 'Reporting use ForeignObject rendering',
        value: true,
        description: 'Whether to use ForeignObject rendering when generating reports. If it causes issues, try disabling this option.',
        schema: _configSchema.schema.boolean()
      }
    });

    try {
      const config = await (0, _config.buildConfig)(this.initializerContext, core, this.logger);
      this.reportingConfig = config;
      this.logger.debug('Setup complete');
    } catch (error) {
      this.logger.error(`Error in Reporting setup, reporting may not function properly`);
      this.logger.error(error);
    }

    if (!this.reportingConfig) {
      throw new Error('Reporting Config is not initialized');
    }

    const router = core.http.createRouter(); // Deprecated API. Switch to the new opensearch client as soon as https://github.com/elastic/kibana/issues/35508 done.

    const opensearchReportsClient = core.opensearch.legacy.createClient('opensearch_reports', {
      plugins: [_opensearchReportsPlugin.default, _notificationsPlugin.NotificationsPlugin]
    });
    const notificationsClient = core.opensearch.legacy.createClient('opensearch_notifications', {
      plugins: [_notificationsPlugin.NotificationsPlugin]
    }); // Register server side APIs

    (0, _routes.default)(router, this.reportingConfig); // put logger into route handler context, so that we don't need to pass through parameters

    core.http.registerRouteHandlerContext( //@ts-ignore
    'reporting_plugin', (context, request) => {
      return {
        logger: this.logger,
        opensearchReportsClient,
        notificationsClient
      };
    });
    return {};
  }

  start(core) {
    this.logger.debug('reports-dashboards: Started');
    return {};
  }

  stop() {}

}

exports.ReportsDashboardsPlugin = ReportsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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