/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.transforms;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xml.security.utils.JavaUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SampleTransformXPath2Filter {
    public static void main(String[] stringArray) throws Exception {
        Init.init();
        boolean bl = true;
        SampleTransformXPath2Filter.create("withComments.xml", true, bl);
        System.out.println();
        System.out.println();
        System.out.println();
        SampleTransformXPath2Filter.create("omitComments.xml", false, bl);
        System.out.println();
        System.out.println();
        System.out.println();
        SampleTransformXPath2Filter.check("withComments.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(String string, boolean bl, boolean bl2) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        String string2 = "<Document>\n     <ToBeSigned>\n       <!-- comment -->\n       <Data />\n       <NotToBeSigned>\n         <ReallyToBeSigned>\n           <!-- comment -->\n           <Data />\n         </ReallyToBeSigned>\n       </NotToBeSigned>\n     </ToBeSigned>\n     <ToBeSigned>\n       <Data />\n       <NotToBeSigned>\n         <Data />\n       </NotToBeSigned>\n     </ToBeSigned>\n</Document>";
        Document document = documentBuilder.parse(new ByteArrayInputStream(string2.getBytes()));
        XMLSignature xMLSignature = new XMLSignature(document, null, "http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        document.getDocumentElement().appendChild(xMLSignature.getElement());
        document.getDocumentElement().appendChild(document.createTextNode("\n"));
        Transforms transforms = new Transforms(document);
        String[][] stringArray = new String[][]{{"intersect", "//ToBeSigned"}, {"subtract", "//NotToBeSigned"}, {"union", "//ReallyToBeSigned"}};
        transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstances((Document)document, (String[][])stringArray));
        if (bl) {
            transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        }
        xMLSignature.addDocument("#xpointer(/)", transforms);
        String string3 = "secret";
        xMLSignature.getKeyInfo().addKeyName("The UTF-8 octets of \"" + string3 + "\" are used for signing (" + string3.length() + " octets)");
        xMLSignature.sign((Key)xMLSignature.createSecretKey(string3.getBytes()));
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        byte[] byArray = canonicalizer.canonicalizeSubtree((Node)document);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            fileOutputStream.write(byArray);
        }
        finally {
            fileOutputStream.close();
        }
        if (bl2) {
            System.out.println("-------------------------------------------------------------");
            System.out.println("Input to the transforms is");
            System.out.println("-------------------------------------------------------------");
            System.out.println(new String(xMLSignature.getSignedInfo().item(0).getContentsBeforeTransformation().getBytes()));
            System.out.println("-------------------------------------------------------------");
            System.out.println("The signed octets (output of the transforms) are ");
            System.out.println("-------------------------------------------------------------");
            System.out.println(new String(xMLSignature.getSignedInfo().item(0).getTransformsOutput().getBytes()));
            System.out.println("-------------------------------------------------------------");
            System.out.println("The document is ");
            System.out.println("-------------------------------------------------------------");
            System.out.println(new String(byArray));
            System.out.println("-------------------------------------------------------------");
        }
        JavaUtils.writeBytesToFilename((String)"xfilter2.html", (byte[])xMLSignature.getSignedInfo().item(0).getHTMLRepresentation().getBytes());
    }

    public static void check(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new FileInputStream(string));
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        XMLSignature xMLSignature = new XMLSignature((Element)nodeList.item(0), new File(string).toURL().toString());
        boolean bl = xMLSignature.checkSignatureValue((Key)xMLSignature.createSecretKey("secret".getBytes()));
        System.out.println("-------------------------------------------------------------");
        System.out.println("Verification of " + string + ": " + bl);
        System.out.println("-------------------------------------------------------------");
        System.out.println(new String(xMLSignature.getSignedInfo().item(0).getTransformsOutput().getBytes()));
        System.out.println("-------------------------------------------------------------");
    }
}

