/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.addressing;

import java.util.Iterator;
import org.codehaus.xfire.addressing.EndpointReference;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.ServiceInfo;

public class AddressingOperationInfo {
    private String inAction;
    private String outAction;
    private String to;
    private EndpointReference replyTo;
    private EndpointReference faultTo;
    private EndpointReference from;
    private OperationInfo operationInfo;
    public static final String ADDRESSING_OPERATION_KEY = "addressingOperationInfo";

    public AddressingOperationInfo() {
    }

    public AddressingOperationInfo(String inAction, OperationInfo op) {
        this(inAction, inAction + "Ack", op);
    }

    public AddressingOperationInfo(String inAction, String outAction, String to, OperationInfo op) {
        this.inAction = inAction;
        this.outAction = outAction;
        this.to = to;
        op.setProperty(ADDRESSING_OPERATION_KEY, this);
        this.operationInfo = op;
    }

    public AddressingOperationInfo(String inAction, String outAction, OperationInfo op) {
        this(inAction, outAction, null, op);
    }

    public AddressingOperationInfo(OperationInfo op) {
        this(op.getService().getService().getTargetNamespace() + "#" + op.getName(), op);
    }

    public static AddressingOperationInfo getAddressingOperationInfo(OperationInfo op) {
        return (AddressingOperationInfo)op.getProperty(ADDRESSING_OPERATION_KEY);
    }

    public static String getInAction(OperationInfo op) {
        AddressingOperationInfo aoi = AddressingOperationInfo.getAddressingOperationInfo(op);
        if (aoi == null) {
            return null;
        }
        return aoi.getInAction();
    }

    public static String getOutAction(OperationInfo op) {
        AddressingOperationInfo aoi = AddressingOperationInfo.getAddressingOperationInfo(op);
        if (aoi == null) {
            return null;
        }
        return aoi.getOutAction();
    }

    public static AddressingOperationInfo getOperationByInAction(ServiceInfo service, String name) {
        Iterator itr = service.getOperations().iterator();
        while (itr.hasNext()) {
            OperationInfo op = (OperationInfo)itr.next();
            AddressingOperationInfo aoi = AddressingOperationInfo.getAddressingOperationInfo(op);
            if (aoi == null || aoi.getInAction() == null || !aoi.getInAction().equals(name)) continue;
            return aoi;
        }
        if (!name.equals("*")) {
            return AddressingOperationInfo.getOperationByInAction(service, "*");
        }
        return null;
    }

    public static AddressingOperationInfo getOperationByOutAction(ServiceInfo service, String name) {
        Iterator itr = service.getOperations().iterator();
        while (itr.hasNext()) {
            OperationInfo op = (OperationInfo)itr.next();
            AddressingOperationInfo aoi = AddressingOperationInfo.getAddressingOperationInfo(op);
            if (aoi == null || aoi.getOutAction() == null || !aoi.getOutAction().equals(name)) continue;
            return aoi;
        }
        if (!name.equals("*")) {
            return AddressingOperationInfo.getOperationByOutAction(service, "*");
        }
        return null;
    }

    public String getInAction() {
        return this.inAction;
    }

    public void setInAction(String inAction) {
        this.inAction = inAction;
    }

    public String getOutAction() {
        return this.outAction;
    }

    public void setOutAction(String outAction) {
        this.outAction = outAction;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public OperationInfo getOperationInfo() {
        return this.operationInfo;
    }

    public void setOperationInfo(OperationInfo operationInfo) {
        this.operationInfo = operationInfo;
    }

    public EndpointReference getFaultTo() {
        return this.faultTo;
    }

    public void setFaultTo(EndpointReference faultTo) {
        this.faultTo = faultTo;
    }

    public EndpointReference getFrom() {
        return this.from;
    }

    public void setFrom(EndpointReference from) {
        this.from = from;
    }

    public EndpointReference getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(EndpointReference replyTo) {
        this.replyTo = replyTo;
    }
}

