// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func resourceAccessContextManagerAccessPolicy() *schema.Resource {
	return &schema.Resource{
		Create: resourceAccessContextManagerAccessPolicyCreate,
		Read:   resourceAccessContextManagerAccessPolicyRead,
		Update: resourceAccessContextManagerAccessPolicyUpdate,
		Delete: resourceAccessContextManagerAccessPolicyDelete,

		Importer: &schema.ResourceImporter{
			State: resourceAccessContextManagerAccessPolicyImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"org_id": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `The parent organization of this AccessPolicy in the Cloud Resource Hierarchy.`,
			},
			"title": {
				Type:        schema.TypeString,
				Required:    true,
				Description: `Human readable title. Does not affect behavior.`,
			},
			"scopes": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `Folder or project on which this policy is applicable.
Format: folders/{{folder_id}} or projects/{{project_id}}`,
				MaxItems: 1,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"create_time": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `Time the AccessPolicy was created in UTC.`,
			},
			"name": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `Resource name of the AccessPolicy. Format: {policy_id}`,
			},
			"update_time": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `Time the AccessPolicy was updated in UTC.`,
			},
		},
		UseJSONNumber: true,
	}
}

func resourceAccessContextManagerAccessPolicyCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	orgIdProp, err := expandAccessContextManagerAccessPolicyOrgId(d.Get("org_id"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("org_id"); !isEmptyValue(reflect.ValueOf(orgIdProp)) && (ok || !reflect.DeepEqual(v, orgIdProp)) {
		obj["parent"] = orgIdProp
	}
	titleProp, err := expandAccessContextManagerAccessPolicyTitle(d.Get("title"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("title"); !isEmptyValue(reflect.ValueOf(titleProp)) && (ok || !reflect.DeepEqual(v, titleProp)) {
		obj["title"] = titleProp
	}
	scopesProp, err := expandAccessContextManagerAccessPolicyScopes(d.Get("scopes"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("scopes"); !isEmptyValue(reflect.ValueOf(scopesProp)) && (ok || !reflect.DeepEqual(v, scopesProp)) {
		obj["scopes"] = scopesProp
	}

	url, err := replaceVars(d, config, "{{AccessContextManagerBasePath}}accessPolicies")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new AccessPolicy: %#v", obj)
	billingProject := ""

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating AccessPolicy: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// Use the resource in the operation response to populate
	// identity fields and d.Id() before read
	var opRes map[string]interface{}
	err = accessContextManagerOperationWaitTimeWithResponse(
		config, res, &opRes, "Creating AccessPolicy", userAgent,
		d.Timeout(schema.TimeoutCreate))
	if err != nil {
		// The resource didn't actually create
		d.SetId("")
		return fmt.Errorf("Error waiting to create AccessPolicy: %s", err)
	}

	if err := d.Set("name", flattenAccessContextManagerAccessPolicyName(opRes["name"], d, config)); err != nil {
		return err
	}

	// This may have caused the ID to update - update it if so.
	id, err = replaceVars(d, config, "{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// The operation for this resource contains the generated name that we need
	// in order to perform a READ. We need to access the object inside of it as
	// a map[string]interface, so let's do that.

	resp := res["response"].(map[string]interface{})
	name := GetResourceNameFromSelfLink(resp["name"].(string))
	log.Printf("[DEBUG] Setting AccessPolicy name, id to %s", name)
	if err := d.Set("name", name); err != nil {
		return fmt.Errorf("Error setting name: %s", err)
	}
	d.SetId(name)

	log.Printf("[DEBUG] Finished creating AccessPolicy %q: %#v", d.Id(), res)

	return resourceAccessContextManagerAccessPolicyRead(d, meta)
}

func resourceAccessContextManagerAccessPolicyRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{AccessContextManagerBasePath}}accessPolicies/{{name}}")
	if err != nil {
		return err
	}

	billingProject := ""

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("AccessContextManagerAccessPolicy %q", d.Id()))
	}

	if err := d.Set("name", flattenAccessContextManagerAccessPolicyName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading AccessPolicy: %s", err)
	}
	if err := d.Set("create_time", flattenAccessContextManagerAccessPolicyCreateTime(res["createTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading AccessPolicy: %s", err)
	}
	if err := d.Set("update_time", flattenAccessContextManagerAccessPolicyUpdateTime(res["updateTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading AccessPolicy: %s", err)
	}
	if err := d.Set("org_id", flattenAccessContextManagerAccessPolicyOrgId(res["parent"], d, config)); err != nil {
		return fmt.Errorf("Error reading AccessPolicy: %s", err)
	}
	if err := d.Set("title", flattenAccessContextManagerAccessPolicyTitle(res["title"], d, config)); err != nil {
		return fmt.Errorf("Error reading AccessPolicy: %s", err)
	}
	if err := d.Set("scopes", flattenAccessContextManagerAccessPolicyScopes(res["scopes"], d, config)); err != nil {
		return fmt.Errorf("Error reading AccessPolicy: %s", err)
	}

	return nil
}

func resourceAccessContextManagerAccessPolicyUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	obj := make(map[string]interface{})
	titleProp, err := expandAccessContextManagerAccessPolicyTitle(d.Get("title"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("title"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, titleProp)) {
		obj["title"] = titleProp
	}
	scopesProp, err := expandAccessContextManagerAccessPolicyScopes(d.Get("scopes"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("scopes"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, scopesProp)) {
		obj["scopes"] = scopesProp
	}

	url, err := replaceVars(d, config, "{{AccessContextManagerBasePath}}accessPolicies/{{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating AccessPolicy %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("title") {
		updateMask = append(updateMask, "title")
	}

	if d.HasChange("scopes") {
		updateMask = append(updateMask, "scopes")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating AccessPolicy %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating AccessPolicy %q: %#v", d.Id(), res)
	}

	err = accessContextManagerOperationWaitTime(
		config, res, "Updating AccessPolicy", userAgent,
		d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return err
	}

	return resourceAccessContextManagerAccessPolicyRead(d, meta)
}

func resourceAccessContextManagerAccessPolicyDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	url, err := replaceVars(d, config, "{{AccessContextManagerBasePath}}accessPolicies/{{name}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting AccessPolicy %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "AccessPolicy")
	}

	err = accessContextManagerOperationWaitTime(
		config, res, "Deleting AccessPolicy", userAgent,
		d.Timeout(schema.TimeoutDelete))

	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Finished deleting AccessPolicy %q: %#v", d.Id(), res)
	return nil
}

func resourceAccessContextManagerAccessPolicyImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"(?P<name>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "{{name}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	return []*schema.ResourceData{d}, nil
}

func flattenAccessContextManagerAccessPolicyName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	return NameFromSelfLinkStateFunc(v)
}

func flattenAccessContextManagerAccessPolicyCreateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessPolicyUpdateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessPolicyOrgId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if parent, ok := v.(string); ok {
		return strings.TrimPrefix(parent, "organizations/")
	}
	return nil
}

func flattenAccessContextManagerAccessPolicyTitle(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAccessContextManagerAccessPolicyScopes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandAccessContextManagerAccessPolicyOrgId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	if orgId, ok := v.(string); ok {
		return "organizations/" + orgId, nil
	}
	return v, nil
}

func expandAccessContextManagerAccessPolicyTitle(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAccessContextManagerAccessPolicyScopes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}
