/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.Namer;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.internal.AbstractValidatingNamedDomainObjectContainer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultConfiguration;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationFactory;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyFactory;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.DefaultRootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.reflect.Instantiator;

public class DefaultConfigurationContainer
extends AbstractValidatingNamedDomainObjectContainer<Configuration>
implements ConfigurationContainerInternal,
ConfigurationsProvider {
    public static final String DETACHED_CONFIGURATION_DEFAULT_NAME = "detachedConfiguration";
    private static final Pattern RESERVED_NAMES_FOR_DETACHED_CONFS = Pattern.compile("detachedConfiguration\\d*");
    private static final ConfigurationRole DEFAULT_ROLE_TO_CREATE = ConfigurationRoles.LEGACY;
    private static final boolean DEFAULT_LOCK_USAGE_AT_CREATION = false;
    private final AtomicInteger detachedConfigurationDefaultNameCounter = new AtomicInteger(1);
    private final Factory<ResolutionStrategyInternal> resolutionStrategyFactory;
    private final DefaultRootComponentMetadataBuilder rootComponentMetadataBuilder;
    private final DefaultConfigurationFactory defaultConfigurationFactory;

    public DefaultConfigurationContainer(Instantiator instantiator, CollectionCallbackActionDecorator callbackDecorator, DefaultRootComponentMetadataBuilder.Factory rootComponentMetadataBuilderFactory, DefaultConfigurationFactory defaultConfigurationFactory, ResolutionStrategyFactory resolutionStrategyFactory) {
        super(Configuration.class, instantiator, (Namer)new Configuration.Namer(), callbackDecorator);
        this.rootComponentMetadataBuilder = rootComponentMetadataBuilderFactory.create(this);
        this.defaultConfigurationFactory = defaultConfigurationFactory;
        this.resolutionStrategyFactory = resolutionStrategyFactory;
        this.getEventRegister().registerLazyAddAction(x -> this.rootComponentMetadataBuilder.getValidator().validateMutation(MutationValidator.MutationType.HIERARCHY));
        this.whenObjectRemoved(x -> this.rootComponentMetadataBuilder.getValidator().validateMutation(MutationValidator.MutationType.HIERARCHY));
    }

    protected Configuration doCreate(String name) {
        return this.doCreate(name, DEFAULT_ROLE_TO_CREATE, false);
    }

    @Override
    public Set<? extends ConfigurationInternal> getAll() {
        Set set = (Set)Cast.uncheckedCast((Object)this);
        return ImmutableSet.copyOf((Collection)set);
    }

    @Override
    public void visitAll(Consumer<ConfigurationInternal> visitor) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            visitor.accept((ConfigurationInternal)configuration);
        }
    }

    @Override
    public ConfigurationInternal findByName(String name) {
        return (ConfigurationInternal)super.findByName(name);
    }

    @Override
    public ConfigurationInternal getByName(String name) {
        return (ConfigurationInternal)super.getByName(name);
    }

    public String getTypeDisplayName() {
        return "configuration";
    }

    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownConfigurationException(String.format("Configuration with name '%s' not found.", name));
    }

    @Override
    public ConfigurationInternal detachedConfiguration(Dependency ... dependencies) {
        String name = this.nextDetachedConfigurationName();
        DetachedConfigurationsProvider detachedConfigurationsProvider = new DetachedConfigurationsProvider();
        DefaultConfiguration detachedConfiguration = this.newConfiguration(name, detachedConfigurationsProvider, this.rootComponentMetadataBuilder.withConfigurationsProvider(detachedConfigurationsProvider), ConfigurationRolesForMigration.LEGACY_TO_RESOLVABLE_BUCKET, false);
        this.copyAllTo(detachedConfiguration, dependencies);
        detachedConfigurationsProvider.setTheOnlyConfiguration(detachedConfiguration);
        return detachedConfiguration;
    }

    private String nextDetachedConfigurationName() {
        return DETACHED_CONFIGURATION_DEFAULT_NAME + this.detachedConfigurationDefaultNameCounter.getAndIncrement();
    }

    private void copyAllTo(DefaultConfiguration detachedConfiguration, Dependency[] dependencies) {
        DependencySet detachedDependencies = detachedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            detachedDependencies.add((Object)dependency.copy());
        }
    }

    private DefaultConfiguration newConfiguration(String name, ConfigurationsProvider detachedConfigurationsProvider, RootComponentMetadataBuilder componentMetadataBuilder, ConfigurationRole role, boolean lockUsage) {
        return this.defaultConfigurationFactory.create(name, detachedConfigurationsProvider, this.resolutionStrategyFactory, componentMetadataBuilder, role, lockUsage);
    }

    public Configuration createWithRole(String name, ConfigurationRole role, boolean lockUsage, Action<? super Configuration> configureAction) {
        this.assertMutable("createWithRole(String, ConfigurationRole, boolean, Action)");
        this.assertCanAdd(name);
        ConfigurationInternal object = this.doCreate(name, role, lockUsage);
        this.add(object);
        configureAction.execute((Object)object);
        return object;
    }

    private ConfigurationInternal doCreate(String name, ConfigurationRole role, boolean lockUsage) {
        this.validateNameIsAllowed(name);
        DefaultConfiguration configuration = this.newConfiguration(name, this, this.rootComponentMetadataBuilder, role, lockUsage);
        configuration.addMutationValidator(this.rootComponentMetadataBuilder.getValidator());
        return configuration;
    }

    private void validateNameIsAllowed(String name) {
        if (RESERVED_NAMES_FOR_DETACHED_CONFS.matcher(name).matches()) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateAction((String)"Creating a configuration with a name that starts with 'detachedConfiguration'").withAdvice(String.format("Use a different name for the configuration '%s'.", name)).willBeRemovedInGradle9().withUpgradeGuideSection(8, "reserved_configuration_names")).nagUser();
        }
    }
}

