/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.user;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ldap.connection.ConnectionService;
import org.apache.guacamole.auth.ldap.group.UserGroupService;
import org.apache.guacamole.auth.ldap.user.LDAPAuthenticatedUser;
import org.apache.guacamole.auth.ldap.user.UserService;
import org.apache.guacamole.net.auth.AbstractUserContext;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserGroup;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleConnectionGroup;
import org.apache.guacamole.net.auth.simple.SimpleDirectory;
import org.apache.guacamole.net.auth.simple.SimpleObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleUser;

public class LDAPUserContext
extends AbstractUserContext {
    @Inject
    private ConnectionService connectionService;
    @Inject
    private UserService userService;
    @Inject
    private UserGroupService userGroupService;
    @Inject
    private AuthenticationProvider authProvider;
    private User self;
    private Directory<User> userDirectory;
    private Directory<UserGroup> userGroupDirectory;
    private Directory<Connection> connectionDirectory;
    private ConnectionGroup rootGroup;

    public void init(LDAPAuthenticatedUser user) throws GuacamoleException {
        this.userDirectory = new SimpleDirectory(this.userService.getUsers(user));
        this.userGroupDirectory = new SimpleDirectory(this.userGroupService.getUserGroups(user));
        this.connectionDirectory = new SimpleDirectory(this.connectionService.getConnections(user));
        this.rootGroup = new SimpleConnectionGroup("ROOT", "ROOT", (Collection)this.connectionDirectory.getIdentifiers(), Collections.emptyList());
        this.self = new SimpleUser(user.getIdentifier()){

            public ObjectPermissionSet getUserPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet((Collection)LDAPUserContext.this.userDirectory.getIdentifiers());
            }

            public ObjectPermissionSet getUserGroupPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet((Collection)LDAPUserContext.this.userGroupDirectory.getIdentifiers());
            }

            public ObjectPermissionSet getConnectionPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet((Collection)LDAPUserContext.this.connectionDirectory.getIdentifiers());
            }

            public ObjectPermissionSet getConnectionGroupPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet(Collections.singleton("ROOT"));
            }
        };
    }

    public User self() {
        return this.self;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authProvider;
    }

    public Directory<User> getUserDirectory() throws GuacamoleException {
        return this.userDirectory;
    }

    public Directory<UserGroup> getUserGroupDirectory() throws GuacamoleException {
        return this.userGroupDirectory;
    }

    public Directory<Connection> getConnectionDirectory() throws GuacamoleException {
        return this.connectionDirectory;
    }

    public ConnectionGroup getRootConnectionGroup() throws GuacamoleException {
        return this.rootGroup;
    }
}

