/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.graph;

import org.eclipse.jetty.start.graph.Node;
import org.eclipse.jetty.start.graph.Predicate;
import org.eclipse.jetty.start.graph.Selection;

public class UniqueCriteriaPredicate
implements Predicate {
    private final String criteria;

    public UniqueCriteriaPredicate(String criteria) {
        this.criteria = criteria;
    }

    @Override
    public boolean match(Node<?> node) {
        if (node.getSelections().isEmpty()) {
            return false;
        }
        boolean ret = false;
        for (Selection selection : node.getSelections()) {
            if (this.criteria.equalsIgnoreCase(selection.getCriteria())) {
                ret = true;
                continue;
            }
            if (!selection.isExplicit()) continue;
            return false;
        }
        return ret;
    }
}

