/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.jndi;

import com.ca.commons.jndi.BasicOps;
import com.ca.commons.jndi.ConnectionData;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXOps;
import com.ca.commons.naming.LdifUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;

public class TestJNDIOps {
    BufferedReader in;
    PrintStream out;
    DXOps myOps = null;
    LdifUtility ldifutil = new LdifUtility();
    boolean debug = true;
    boolean terminating = false;
    boolean printstack = false;
    public static int OK = 0;
    public static int ERROR = -1;
    public static int FINISHED = 1;

    public static void main(String[] args) {
        String fileName = null;
        String url = null;
        String user = null;
        String pwd = null;
        String version = "3";
        String referral = "follow";
        boolean useSSL = false;
        boolean tracing = false;
        boolean debugFlag = true;
        boolean terminateFlag = false;
        boolean printstackFlag = false;
        try {
            block16: for (int i = 0; i < args.length; ++i) {
                String arg = args[i].charAt(0) != '-' ? args[i] : args[i].substring(1);
                switch (arg.charAt(0)) {
                    case '?': 
                    case 'H': 
                    case 'h': {
                        if (args.length > i + 1) {
                            TestJNDIOps.printHelp(args[i + 1]);
                        } else {
                            TestJNDIOps.printHelp(null);
                        }
                        return;
                    }
                    case 'C': 
                    case 'c': {
                        url = args[++i];
                        continue block16;
                    }
                    case 'D': 
                    case 'd': {
                        debugFlag = true;
                        continue block16;
                    }
                    case 'E': 
                    case 'e': {
                        terminateFlag = true;
                        continue block16;
                    }
                    case 'F': 
                    case 'f': {
                        fileName = args[++i];
                        continue block16;
                    }
                    case 'P': 
                    case 'p': {
                        pwd = args[++i];
                        continue block16;
                    }
                    case 'R': 
                    case 'r': {
                        referral = args[++i];
                        continue block16;
                    }
                    case 'S': 
                    case 's': {
                        useSSL = true;
                        continue block16;
                    }
                    case 'T': 
                    case 't': {
                        tracing = true;
                        continue block16;
                    }
                    case 'U': 
                    case 'u': {
                        user = args[++i];
                        continue block16;
                    }
                    case 'V': 
                    case 'v': {
                        version = args[++i];
                        continue block16;
                    }
                    case 'X': 
                    case 'x': {
                        printstackFlag = true;
                        continue block16;
                    }
                    default: {
                        System.out.println("\n\nInvalid command line argument: -" + arg);
                        TestJNDIOps.printHelp(null);
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error reading command line arguments.");
            TestJNDIOps.printHelp("");
            System.exit(-1);
        }
        TestJNDIOps tester = new TestJNDIOps(fileName, url, user, pwd, tracing, version, debugFlag, terminateFlag, referral, useSSL, printstackFlag);
        tester.processInput();
        tester.out.println("\nnormal finish\n");
    }

    public static void printHelp(String subject) {
        if ("full".equalsIgnoreCase(subject)) {
            TestJNDIOps.printFullHelp();
            return;
        }
        if ("changetype".equalsIgnoreCase(subject)) {
            TestJNDIOps.printChangeTypeHelp();
            return;
        }
        System.out.println("\n\njndiTest is a small utility/test program designed to check the ldap/jndi\nfunctionality of JXplorer.  It reads input or files in ldif change file format\nwith some extra commands added to test searching and attribute reading.\n\n usage: java jnditest [<options>]\n\n options:\n -c            an optional connection url of the form ldap:\\host:port\n -d            debug (verbose) mode\n -e            exit on error, returning -1\n -f filename   name of an ldif changes input file\n -h [subject]  this help message [full|changetype]\n -p password   an option password\n -r referral   the jndi referral type [follow|ignore|throw]\n -t            set BER tracing on\n -u userdn     an optional user dn\n -v            set ldap version (default 3)\n\n -x            print stack trace\n\nin addition to normal ldif changes commands (cf draft-good-ldap-ldif-04.html) a:\nnew keyword 'actiontype' with values [list|search|read|connect|disconnect]\nis defined, with a usage similar to 'changetype'");
    }

    protected static void printFullHelp() {
        TestJNDIOps.printChangeTypeHelp();
    }

    protected static void printChangeTypeHelp() {
        System.out.println(" *    This is a general test bed interface to test the various jndi calls \n *    used by JXplorer.  It used ldif change file format requests, and can \n *    be run directly from the command line, or given an ldif change file\n *    to process.<p>\n *\n *    Requests are either standard ldif change file requests, such as:\n *\n *    version: 1\n *    # Add a new entry\n *     changetype: add\n *     objectclass: top\n *     objectclass: person\n *     objectclass: organizationalPerson\n *     cn: Fiona Jensen\n *     sn: Jensen\n *     uid: fiona\n *     telephonenumber: +1 408 555 1212\n *     jpegphoto:< file:///usr/local/directory/photos/fiona.jpg\n *    <pre>\n *    where valid 'changetype' values are [add|delete|modrdn|modify] \n *    This is extended by jnditest to include extra (non-standard) changetype\n *    commands, such as [connect|disconnect|list|search|searchOneLevel|read], to allow\n *    general directory access and testing.\n *    The 'connect' command takes the attributes; 'url', and the optional \n *    attributes: 'user','pwd','tracing','ldapVersion','referral' and 'useSSL' \n *\n *    XXX coming soon - [copyTree|deleteTree|moveTree]\n *");
    }

    public TestJNDIOps(String fileName, String url, String user, String pwd, boolean tracing, String version, boolean debugFlag, boolean terminateFlag, String referral, boolean useSSL, boolean printstackFlag) {
        this.out = System.out;
        this.debug = debugFlag;
        this.terminating = terminateFlag;
        this.printstack = printstackFlag;
        if (url != null) {
            this.openConnection(url, user, pwd, tracing, version, referral, useSSL);
        }
        this.in = fileName != null ? this.openFile(fileName) : new BufferedReader(new InputStreamReader(System.in));
    }

    public void openConnection(String url, String user, String pwd, boolean tracing, String version, String referralType, boolean useSSL) {
        if (referralType == null) {
            referralType = "follow";
        }
        if ("ignorefollowthrow".indexOf(referralType) == -1) {
            this.error("unknown referraltype " + referralType, null);
            referralType = "follow";
        }
        if (!url.toLowerCase().startsWith("ldap://")) {
            url = "ldap://" + url;
        }
        try {
            if (this.debug) {
                this.out.println("opening connection with :\n url: " + url + "\n user: " + user + "\n pwd: " + pwd + "\n tracing: " + tracing + "\n version: " + version + "\n referral: " + referralType);
            }
            if (url == null || url.length() == 0) {
                this.error("unable to open connection - no url supplied", null);
                return;
            }
            if (version == null || version.length() == 0) {
                version = "3";
            }
            char[] password = pwd == null || pwd.length() == 0 ? null : pwd.toCharArray();
            int versn = Integer.parseInt(version);
            ConnectionData cData = new ConnectionData(versn, url, user, password, tracing, null, null);
            DirContext ctx = BasicOps.openContext(cData);
            if (ctx != null) {
                this.myOps = new DXOps(ctx);
            }
            if (this.myOps == null) {
                this.error("unable to open connection " + url, null);
            } else if (this.debug) {
                this.out.println("connection " + url + " open. ");
            }
        }
        catch (Exception e) {
            this.error("error opening connection " + url + "\n  ", e);
        }
    }

    public BufferedReader openFile(String fileName) {
        try {
            File myFile = new File(fileName);
            this.ldifutil.setFileDir(myFile.getParent());
            return new BufferedReader(new InputStreamReader(new FileInputStream(myFile)));
        }
        catch (Exception e) {
            this.error("unable to open file : " + fileName + "\n  ", e);
            System.exit(-1);
            return null;
        }
    }

    public void processInput() {
        try {
            DXEntry commandSet;
            while ((commandSet = this.ldifutil.readLdifEntry(this.in)) != null) {
                if (commandSet == null) {
                    this.error("internal error in jnditest - parsed ldif command set null", null);
                }
                if (this.processCommand(commandSet) != FINISHED) continue;
                return;
            }
        }
        catch (Exception e) {
            this.error("error reading input - program stopped.\n  ", e);
            System.exit(-1);
        }
    }

    public int processCommand(DXEntry entry) {
        DXAttribute command;
        if (entry.size() == 0) {
            if (this.debug) {
                this.out.println("\n\nEnding on double blank line");
            }
            return FINISHED;
        }
        if (entry.get("version") != null) {
            entry.remove("version");
        }
        if (entry.getDN().size() == 0) {
            DXAttribute temp = (DXAttribute)entry.get("changetype");
            String test = "";
            try {
                test = temp.get().toString();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!test.equalsIgnoreCase("connect") && !test.equalsIgnoreCase("disconnect")) {
                this.error("error reading input - no dn attribute in entry!\n*******\n" + entry + "******\n", null);
                return ERROR;
            }
        }
        if ((command = (DXAttribute)entry.get("changetype")) == null || command.size() == 0) {
            this.error("error reading input - no 'changetype' attribute in entry.\n******\n" + entry + "******\n", null);
            return ERROR;
        }
        String commandString = "";
        try {
            commandString = command.get().toString();
        }
        catch (NamingException e) {
            this.error("internal error in processCommand()\n  ", e);
            return ERROR;
        }
        if (this.debug) {
            System.out.println("\n\nCOMMAND= " + commandString);
        }
        entry.remove("changetype");
        if (this.myOps == null && !commandString.equalsIgnoreCase("connect") && !commandString.equalsIgnoreCase("disconnect")) {
            this.error("Attempting operation " + commandString + " without an open connection!", null);
        }
        try {
            if (commandString.equalsIgnoreCase("add")) {
                this.addEntry(entry, this.returnType(entry));
            } else if (commandString.equalsIgnoreCase("delete")) {
                this.deleteEntry(entry, this.returnType(entry));
            } else if (commandString.equalsIgnoreCase("modrdn")) {
                this.modrdnEntry(entry, this.modRDN(entry));
            } else if (commandString.equalsIgnoreCase("modify")) {
                this.modifyEntry(entry, this.returnType(entry));
            } else if (commandString.equalsIgnoreCase("list")) {
                this.listEntry(entry, this.list(entry));
            } else if (commandString.equalsIgnoreCase("search")) {
                this.searchEntry(entry, this.search(entry));
            } else if (commandString.equalsIgnoreCase("searchOneLevel")) {
                this.searchOneLevelEntry(entry, this.search(entry));
            } else if (commandString.equalsIgnoreCase("read")) {
                this.readEntry(entry, this.read(entry));
            } else if (commandString.equalsIgnoreCase("connect")) {
                this.connect(entry);
            } else if (commandString.equalsIgnoreCase("disconnect")) {
                this.disconnect(entry);
            } else if (commandString.equalsIgnoreCase("copy")) {
                this.copy(entry, this.copy(entry, command));
            } else if (commandString.equalsIgnoreCase("cut")) {
                this.cut(entry, this.cut(entry, command));
            }
        }
        catch (NamingException e) {
            this.error("Naming Exception in " + commandString + "\n  ", e);
            return ERROR;
        }
        return OK;
    }

    public boolean returnType(DXEntry entry) {
        DXAttribute returnType = (DXAttribute)entry.get("returntype");
        String myType = "";
        try {
            myType = returnType.get().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean expectedVal = "true".equalsIgnoreCase(myType);
        if (returnType != null) {
            if (this.debug) {
                System.out.println("\n\nparsed returntype: " + myType + "\n as: " + expectedVal + "\n");
            }
            entry.remove("returntype");
        }
        return expectedVal;
    }

    public void addEntry(DXEntry entry, boolean expectedValue) {
        if (this.debug) {
            System.out.println("\nADD: " + entry);
        }
        boolean ret = false;
        try {
            this.myOps.addEntry(entry.getDN(), (Attributes)entry);
            ret = true;
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (ret != expectedValue) {
            if (this.debug) {
                System.out.println("\nret equals expectedValue: " + (ret == expectedValue) + "\n");
            }
            if (this.debug) {
                System.out.println("\n&&&& RET: " + ret + "  &&&& EXPECTEDVALUE: " + expectedValue);
            }
            this.error("\nadd operation failed for: " + entry + "\n", null);
        }
    }

    public void deleteEntry(DXEntry entry, boolean expectedValue) {
        if (this.debug) {
            System.out.println("\nDELETE: " + entry);
        }
        boolean ret = false;
        try {
            this.myOps.deleteEntry(entry.getDN());
            ret = true;
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (ret != expectedValue) {
            if (this.debug) {
                System.out.println("\n\nRET  " + ret + "  EXPECTEDVALUE  " + expectedValue);
            }
            if (this.debug) {
                System.out.println("\nret equals expectedValue: " + (ret == expectedValue) + "\n");
            }
            this.error("\ndelete operation failed for: " + entry + "\n", null);
        }
    }

    public String modRDN(DXEntry entry) {
        DXAttribute modRdnResult = (DXAttribute)entry.get("modrdnresult");
        String myModRdnCn = "";
        try {
            myModRdnCn = modRdnResult.get().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (modRdnResult != null) {
            if (this.debug) {
                System.out.println("\n\nparsed modrdnresult (DXAttribute): " + modRdnResult + "\n to mymodrdnCn(String): " + myModRdnCn);
            }
            entry.remove("modrdnresult");
        }
        return myModRdnCn;
    }

    public void modrdnEntry(DXEntry entry, String expectedModrdn) {
        String newDNString = entry.getString("newrdn");
        DN newDN = new DN(newDNString);
        if (this.debug) {
            System.out.println("modrdn: " + entry.getDN() + "\n  to: " + newDN);
        }
        boolean ret = false;
        try {
            this.myOps.renameEntry(entry.getDN(), newDN);
            ret = true;
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (!ret) {
            this.error("modrdn operation failed for: " + entry, null);
        }
        int compare = -2;
        compare = expectedModrdn.compareTo(newDNString);
        if (compare != 0) {
            if (this.debug) {
                System.out.println("\n\nnewDN CN String: " + newDNString);
            }
            if (this.debug) {
                System.out.println("EXPECTEDVALUE  : " + expectedModrdn);
            }
            this.error("\nmodrdn operation failed for: " + entry + "\nExpected read result for cn: " + expectedModrdn + "\nActual result for cn: " + newDNString, null);
        }
    }

    public void modifyEntry(DXEntry entry, boolean expectedValue) {
        boolean ret;
        DXAttribute attr;
        String attrString;
        if (this.debug) {
            System.out.println("modify: " + entry);
        }
        DN myDN = entry.getDN();
        DXAttribute add = null;
        DXAttribute delete = null;
        DXAttribute replace = null;
        add = (DXAttribute)entry.get("add");
        delete = (DXAttribute)entry.get("delete");
        replace = (DXAttribute)entry.get("replace");
        if (add != null) {
            attrString = "";
            try {
                attrString = add.get().toString();
            }
            catch (Exception e) {
                // empty catch block
            }
            attr = (DXAttribute)entry.get(attrString);
            ret = false;
            try {
                this.myOps.addAttribute(myDN, (Attribute)attr);
                ret = true;
            }
            catch (NamingException e1) {
                // empty catch block
            }
            if (ret != expectedValue) {
                if (this.debug) {
                    System.out.println("\n\nRET  " + ret + "  EXPECTEDVALUE  " + expectedValue);
                }
                if (this.debug) {
                    System.out.println("\nret equals expectedValue: " + (ret == expectedValue) + "\n");
                }
                this.error("\nmodify-add operation failed for: " + entry + "\n", null);
            }
        }
        if (delete != null) {
            attrString = "";
            try {
                attrString = delete.get().toString();
            }
            catch (Exception e) {
                // empty catch block
            }
            attr = (DXAttribute)entry.get(attrString);
            ret = false;
            try {
                this.myOps.deleteAttribute(myDN, (Attribute)attr);
                ret = true;
            }
            catch (NamingException e1) {
                // empty catch block
            }
            if (ret != expectedValue) {
                if (this.debug) {
                    System.out.println("\n\nRET  " + ret + "  EXPECTEDVALUE  " + expectedValue);
                }
                if (this.debug) {
                    System.out.println("\nret equals expectedValue: " + (ret == expectedValue) + "\n");
                }
                this.error("\nmodify-delete operation failed for: " + entry + "\n", null);
            }
        }
        if (replace != null) {
            attrString = "";
            try {
                attrString = replace.get().toString();
            }
            catch (Exception e) {
                // empty catch block
            }
            attr = (DXAttribute)entry.get(attrString);
            ret = false;
            try {
                this.myOps.updateAttribute(myDN, (Attribute)attr);
                ret = true;
            }
            catch (NamingException e1) {
                // empty catch block
            }
            if (ret != expectedValue) {
                if (this.debug) {
                    System.out.println("\n\nRET  " + ret + "  EXPECTEDVALUE  " + expectedValue);
                }
                if (this.debug) {
                    System.out.println("\nret equals expectedValue: " + (ret == expectedValue) + "\n");
                }
                this.error("\nmodify-replace operation failed for: " + entry + "\n", null);
            }
        }
    }

    public int list(DXEntry entry) {
        DXAttribute listResult = (DXAttribute)entry.get("listresult");
        String myListResult = "";
        try {
            myListResult = listResult.get().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        int list = -1;
        try {
            list = Integer.parseInt(myListResult);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (listResult != null) {
            if (this.debug) {
                System.out.println("\n\nparsed listresult(DXAttribute): " + listResult + "\n to myListResult(String): " + myListResult + ", to list(int): " + list);
            }
            entry.remove("listresult");
        }
        return list;
    }

    public void listEntry(DXEntry entry, int expectedList) throws NamingException {
        if (this.debug) {
            System.out.println("\nlist: " + entry);
        }
        NamingEnumeration names = this.myOps.list(entry.getDN());
        if (this.debug) {
            this.out.println("\nlist of children:");
        }
        int i = 0;
        while (names.hasMore()) {
            ++i;
            if (!this.debug) continue;
            this.out.println(((NameClassPair)names.next()).getName());
        }
        if (i != expectedList) {
            this.error("\nList operation failed for: " + entry + "\nExpected list results: " + expectedList + "\nActual list results: " + i, null);
        }
    }

    public int search(DXEntry entry) {
        DXAttribute searchResult = (DXAttribute)entry.get("searchresult");
        String mySearch = "";
        try {
            mySearch = searchResult.get().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        int search = -1;
        try {
            search = Integer.parseInt(mySearch);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (searchResult != null) {
            if (this.debug) {
                System.out.println("\n\nparsed searchresult(DXAttribute): " + searchResult + "\n to mySearch(String): " + mySearch + ", to myResult(int): " + search);
            }
            entry.remove("searchresult");
        }
        return search;
    }

    public void searchEntry(DXEntry entry, int expectedSearch) throws NamingException {
        String filter = entry.getString("filter");
        String limit = entry.getString("limit");
        String timeout = entry.getString("timeout");
        if (limit == null) {
            limit = "0";
        }
        if (timeout == null) {
            timeout = "0";
        }
        int lim = Integer.parseInt(limit);
        int time = Integer.parseInt(timeout);
        if (this.debug) {
            System.out.println("\nSEARCH " + entry + "\n  filter: " + filter + "\n  limit: " + limit + "\n  timeout: " + timeout);
        }
        NamingEnumeration names = this.myOps.searchSubTree(entry.getDN(), filter, lim, time);
        if (this.debug) {
            this.out.println("\nNAMES:  " + names + "\n\nDN:  " + entry);
        }
        if (this.debug) {
            this.out.println("\nsubtree search results:");
        }
        int i = 0;
        while (names.hasMore()) {
            ++i;
            if (!this.debug) continue;
            this.out.println(((SearchResult)names.next()).getName());
        }
        if (i != expectedSearch) {
            this.error("\nSearch operation failed for: " + entry + "\nExpected search results: " + expectedSearch + "\nActual search results: " + i, null);
        }
    }

    public void searchOneLevelEntry(DXEntry entry, int expectedSearch) throws NamingException {
        String filter = entry.getString("filter");
        String limit = entry.getString("limit");
        String timeout = entry.getString("timeout");
        if (limit == null) {
            limit = "0";
        }
        if (timeout == null) {
            timeout = "0";
        }
        if (this.debug) {
            System.out.println("\n\nSEARCHONELEVEL: " + entry + "\n  filter: " + filter + "\n  limit: " + limit + "\n  timeout: " + timeout);
        }
        int lim = Integer.parseInt(limit);
        int time = Integer.parseInt(timeout);
        NamingEnumeration names = this.myOps.searchOneLevel(entry.getDN(), filter, lim, time);
        if (this.debug) {
            this.out.println("\n\none level search results:");
        }
        int i = 0;
        while (names.hasMore()) {
            ++i;
            if (!this.debug) continue;
            this.out.println(((SearchResult)names.next()).getName());
        }
        if (i != expectedSearch) {
            this.error("\n\nSearchOneLevel operation failed for: " + entry + "\n\nExpected search results: " + expectedSearch + "\nActual search results: " + i, null);
        }
    }

    public String read(DXEntry entry) {
        DXAttribute readResultCn = (DXAttribute)entry.get("readresultcn");
        String myReadCn = "";
        try {
            myReadCn = readResultCn.get().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (readResultCn != null) {
            if (this.debug) {
                System.out.println("\n\nparsed readresultcn (DXAttribute): " + readResultCn + "\n to myReadCn(String): " + myReadCn);
            }
            entry.remove("readresultcn");
        }
        return myReadCn;
    }

    public void readEntry(DXEntry entry, String expectedRead) throws NamingException {
        Attributes atts;
        if (this.debug) {
            System.out.println("\nread: " + entry);
        }
        if ((atts = this.myOps.read(entry.getDN())) == null) {
            throw new NamingException("\nUnable to read entry " + entry.getDN());
        }
        Attribute readCn = atts.get("cn");
        if (this.debug) {
            this.out.println("\nREAD: " + readCn);
        }
        String myReadCn = "";
        try {
            myReadCn = readCn.get().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        int compare = -2;
        compare = expectedRead.compareTo(myReadCn);
        if (compare != 0) {
            if (this.debug) {
                this.out.println("\n\nREAD CN String: " + myReadCn);
            }
            if (this.debug) {
                this.out.println("EXPECTEDVALUE : " + expectedRead);
            }
            this.error("\nRead operation failed for: " + entry + "\nExpected read result for cn: " + expectedRead + "\nActual read result for cn:   " + myReadCn, null);
        }
        DXEntry val = new DXEntry(atts);
        if (this.debug) {
            this.out.println(val);
        }
    }

    public String copy(DXEntry entry, DXAttribute command) {
        DXAttribute copyTo = (DXAttribute)entry.get("copyTo");
        String myCopyTo = "";
        try {
            myCopyTo = copyTo.get().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (copyTo != null) {
            if (this.debug) {
                System.out.println("copyTo: " + copyTo + "\ncommand: " + command + "\nmyCopyTo: " + myCopyTo);
            }
            if (this.debug) {
                System.out.println("\n\nparsed copyTo (DXAttribute): " + copyTo + "\n to myCopyTo(String): " + myCopyTo);
            }
            entry.remove("copyTo");
        }
        return myCopyTo;
    }

    public void copy(DXEntry oldEntry, String newEntry) {
        int i;
        int n;
        block19: {
            NamingEnumeration namesNew;
            DN oldDN;
            Name newDN;
            block18: {
                NamingEnumeration namesOld;
                newDN = this.myOps.postParse(newEntry);
                oldDN = oldEntry.getDN();
                if (this.debug) {
                    System.out.println("old DN: " + oldDN);
                }
                if (this.debug) {
                    System.out.println("new DN: " + newDN);
                }
                try {
                    namesOld = this.myOps.list(oldDN);
                }
                catch (NamingException e1) {
                    System.err.println("failed getting old names");
                    e1.printStackTrace();
                    return;
                }
                if (this.debug) {
                    this.out.println("\nCopy of OLD  children:");
                }
                n = 0;
                try {
                    while (namesOld.hasMore()) {
                        ++n;
                        if (!this.debug) continue;
                        this.out.println("Old Entries: " + ((NameClassPair)namesOld.next()).getName());
                    }
                }
                catch (Exception e) {
                    if (!this.debug) break block18;
                    System.out.println("List for OLD entries failed during copy process");
                }
            }
            try {
                this.myOps.copyTree(oldDN, newDN);
            }
            catch (NamingException e2) {
                System.err.println("error in copyTree()");
                e2.printStackTrace();
            }
            if (this.debug) {
                System.out.println("Copy: " + oldEntry);
            }
            try {
                namesNew = this.myOps.list(newDN);
            }
            catch (NamingException e3) {
                System.err.println("error in getting new list");
                e3.printStackTrace();
                return;
            }
            if (this.debug) {
                this.out.println("\nCopy of NEW children:");
            }
            i = 0;
            try {
                while (namesNew.hasMore()) {
                    ++i;
                    if (!this.debug) continue;
                    this.out.println("New Entries: " + ((NameClassPair)namesNew.next()).getName());
                }
            }
            catch (Exception e) {
                if (!this.debug) break block19;
                System.out.println("List for NEW entries failed during copy process");
            }
        }
        if (i != n) {
            this.error("\nCopy operation failed for: " + oldEntry + "\nExpected number of copied entries: " + n + "\nActual number of copied entries: " + i, null);
        }
    }

    public String cut(DXEntry entry, DXAttribute command) {
        DXAttribute cutTo = (DXAttribute)entry.get("cutTo");
        String myCutTo = "";
        try {
            myCutTo = cutTo.get().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (cutTo != null) {
            if (this.debug) {
                System.out.println("cutTo: " + cutTo + "\ncommand: " + command + "\nmyCutTo: " + myCutTo);
            }
            if (this.debug) {
                System.out.println("\n\nparsed cutTo (DXAttribute): " + cutTo + "\n to myCutTo(String): " + myCutTo);
            }
            entry.remove("cutTo");
        }
        return myCutTo;
    }

    public void cut(DXEntry oldEntry, String newEntry) {
        int i;
        int n;
        block19: {
            NamingEnumeration namesNew;
            DN oldDN;
            Name newDN;
            block18: {
                NamingEnumeration namesOld;
                newDN = this.myOps.postParse(newEntry);
                oldDN = oldEntry.getDN();
                if (this.debug) {
                    System.out.println("old: " + oldDN);
                }
                if (this.debug) {
                    System.out.println("new: " + newDN);
                }
                try {
                    namesOld = this.myOps.list(oldDN);
                }
                catch (NamingException e1) {
                    System.err.println("error getting namesOld");
                    e1.printStackTrace();
                    return;
                }
                if (this.debug) {
                    this.out.println("\nCut of OLD children:");
                }
                n = 0;
                try {
                    while (namesOld.hasMore()) {
                        ++n;
                        if (!this.debug) continue;
                        this.out.println("Old Entries: " + ((NameClassPair)namesOld.next()).getName());
                    }
                }
                catch (Exception e) {
                    if (!this.debug) break block18;
                    System.out.println("List for OLD entries failed during cut process");
                }
            }
            try {
                this.myOps.moveTree(oldDN, newDN);
            }
            catch (NamingException e2) {
                System.err.println("error in moveTree()");
                e2.printStackTrace();
            }
            if (this.debug) {
                System.out.println("Copy: " + oldEntry);
            }
            try {
                namesNew = this.myOps.list(newDN);
            }
            catch (NamingException e3) {
                System.err.println("error getting namesNew");
                e3.printStackTrace();
                return;
            }
            if (this.debug) {
                this.out.println("\nCut of NEW children:");
            }
            i = 0;
            try {
                while (namesNew.hasMore()) {
                    ++i;
                    if (!this.debug) continue;
                    this.out.println("New Entries: " + ((NameClassPair)namesNew.next()).getName());
                }
            }
            catch (Exception e) {
                if (!this.debug) break block19;
                System.out.println("List for NEW entries failed during cut process");
            }
        }
        if (i != n) {
            this.error("\nCut operation failed for: " + oldEntry + "\nExpected number of cut entries: " + n + "\nActual number of cut entries: " + i, null);
        }
    }

    public void connect(DXEntry entry) {
        if (this.debug) {
            System.out.println("connect: " + entry);
        }
        if (this.myOps != null) {
            try {
                this.myOps.close();
            }
            catch (NamingException e) {
                System.err.println("error in myOps.close()");
                e.printStackTrace();
            }
        }
        String url = entry.getString("url");
        String user = entry.getString("user");
        String pwd = entry.getString("pwd");
        String tracing = entry.getString("tracing");
        String version = entry.getString("ldapVersion");
        String referral = entry.getString("referral");
        String useSSL = entry.getString("useSSL");
        boolean trace = tracing != null && tracing.equalsIgnoreCase("true");
        boolean ssl = useSSL != null && useSSL.equalsIgnoreCase("true");
        this.openConnection(url, user, pwd, trace, version, referral, ssl);
    }

    public void disconnect(DXEntry entry) {
        if (this.debug) {
            System.out.println("disconnected. ");
        }
        try {
            this.myOps.close();
        }
        catch (NamingException e) {
            System.err.println("error in myOps.close()");
            e.printStackTrace();
        }
    }

    public void error(String msg, Exception e) {
        this.out.println(msg + "\n");
        if (e != null && this.printstack) {
            e.printStackTrace();
        }
        if (this.terminating) {
            System.exit(-1);
        }
    }
}

