/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.spring;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.configuration.ConfigurationProperty;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;
import liquibase.util.file.FilenameUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;

public class SpringLiquibase
implements InitializingBean,
BeanNameAware,
ResourceLoaderAware {
    protected String beanName;
    protected ResourceLoader resourceLoader;
    protected DataSource dataSource;
    protected final Logger log = LogFactory.getLogger(SpringLiquibase.class.getName());
    protected String changeLog;
    protected String contexts;
    protected String labels;
    protected String tag;
    protected Map<String, String> parameters;
    protected String defaultSchema;
    protected boolean dropFirst = false;
    protected boolean shouldRun = true;
    protected File rollbackFile;
    private boolean ignoreClasspathPrefix = true;

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }

    public void setShouldRun(boolean shouldRun) {
        this.shouldRun = shouldRun;
    }

    public String getDatabaseProductName() throws DatabaseException {
        Connection connection = null;
        Database database = null;
        String name = "unknown";
        try {
            connection = this.getDataSource().getConnection();
            database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
            name = database.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (database != null) {
                database.close();
            } else if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    connection.close();
                }
                catch (Exception e) {
                    this.log.warning("problem closing connection", e);
                }
            }
        }
        return name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String dataModel) {
        this.changeLog = dataModel;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public void afterPropertiesSet() throws LiquibaseException {
        ConfigurationProperty shouldRunProperty = LiquibaseConfiguration.getInstance().getProperty(GlobalConfiguration.class, "shouldRun");
        if (!shouldRunProperty.getValue(Boolean.class).booleanValue()) {
            LogFactory.getLogger().info("Liquibase did not run because " + LiquibaseConfiguration.getInstance().describeValueLookupLogic(shouldRunProperty) + " was set to false");
            return;
        }
        if (!this.shouldRun) {
            LogFactory.getLogger().info("Liquibase did not run because 'shouldRun' property was set to false on " + this.getBeanName() + " Liquibase Spring bean.");
            return;
        }
        Connection c = null;
        Liquibase liquibase = null;
        try {
            c = this.getDataSource().getConnection();
            liquibase = this.createLiquibase(c);
            this.generateRollbackFile(liquibase);
            this.performUpdate(liquibase);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            Database database = null;
            if (liquibase != null) {
                database = liquibase.getDatabase();
            }
            if (database != null) {
                database.close();
            }
        }
    }

    private void generateRollbackFile(Liquibase liquibase) throws LiquibaseException {
        if (this.rollbackFile != null) {
            FileWriter output = null;
            try {
                output = new FileWriter(this.rollbackFile);
                if (this.tag != null) {
                    liquibase.futureRollbackSQL(this.tag, new Contexts(this.getContexts()), new LabelExpression(this.getLabels()), (Writer)output);
                } else {
                    liquibase.futureRollbackSQL(new Contexts(this.getContexts()), new LabelExpression(this.getLabels()), (Writer)output);
                }
            }
            catch (IOException e) {
                throw new LiquibaseException("Unable to generate rollback file.", e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e) {
                    this.log.severe("Error closing output", e);
                }
            }
        }
    }

    protected void performUpdate(Liquibase liquibase) throws LiquibaseException {
        if (this.tag != null) {
            liquibase.update(this.tag, new Contexts(this.getContexts()), new LabelExpression(this.getLabels()));
        } else {
            liquibase.update(new Contexts(this.getContexts()), new LabelExpression(this.getLabels()));
        }
    }

    protected Liquibase createLiquibase(Connection c) throws LiquibaseException {
        SpringResourceOpener resourceAccessor = this.createResourceOpener();
        Liquibase liquibase = new Liquibase(this.getChangeLog(), (ResourceAccessor)resourceAccessor, this.createDatabase(c, resourceAccessor));
        liquibase.setIgnoreClasspathPrefix(this.isIgnoreClasspathPrefix());
        if (this.parameters != null) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
        }
        if (this.isDropFirst()) {
            liquibase.dropAll();
        }
        return liquibase;
    }

    protected Database createDatabase(Connection c, ResourceAccessor resourceAccessor) throws DatabaseException {
        DatabaseConnection liquibaseConnection;
        if (c == null) {
            this.log.warning("Null connection returned by liquibase datasource. Using offline unknown database");
            liquibaseConnection = new OfflineConnection("offline:unknown", resourceAccessor);
        } else {
            liquibaseConnection = new JdbcConnection(c);
        }
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(liquibaseConnection);
        if (StringUtils.trimToNull(this.defaultSchema) != null) {
            database.setDefaultSchemaName(this.defaultSchema);
        }
        return database;
    }

    public void setChangeLogParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    protected SpringResourceOpener createResourceOpener() {
        return new SpringResourceOpener(this.getChangeLog());
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setRollbackFile(File rollbackFile) {
        this.rollbackFile = rollbackFile;
    }

    public boolean isIgnoreClasspathPrefix() {
        return this.ignoreClasspathPrefix;
    }

    public void setIgnoreClasspathPrefix(boolean ignoreClasspathPrefix) {
        this.ignoreClasspathPrefix = ignoreClasspathPrefix;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getResourceLoader().toString() + ")";
    }

    public class SpringResourceOpener
    extends ClassLoaderResourceAccessor {
        private String parentFile;

        public SpringResourceOpener(String parentFile) {
            this.parentFile = parentFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void init() {
            super.init();
            try {
                Resource[] resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)SpringLiquibase.this.getResourceLoader()).getResources("");
                if (resources.length == 0 || resources.length == 1 && !resources[0].exists()) {
                    HashSet<String> liquibasePackages = new HashSet<String>();
                    for (Resource manifest : ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)SpringLiquibase.this.getResourceLoader()).getResources("META-INF/MANIFEST.MF")) {
                        if (!manifest.exists()) continue;
                        InputStream inputStream = null;
                        try {
                            inputStream = manifest.getInputStream();
                            Manifest manifestObj = new Manifest(inputStream);
                            Attributes attributes = manifestObj.getAttributes("Liquibase-Package");
                            if (attributes == null) continue;
                            for (Object attr : attributes.values()) {
                                String packages = "\\s*,\\s*";
                                for (String fullPackage : attr.toString().split(packages)) {
                                    liquibasePackages.add(fullPackage.split("\\.")[0]);
                                }
                            }
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    if (liquibasePackages.size() == 0) {
                        LogFactory.getInstance().getLog().warning("No Liquibase-Packages entry found in MANIFEST.MF. Using fallback of entire 'liquibase' package");
                        liquibasePackages.add("liquibase");
                    }
                    for (String foundPackage : liquibasePackages) {
                        for (Resource res : resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)SpringLiquibase.this.getResourceLoader()).getResources(foundPackage)) {
                            this.addRootPath(res.getURL());
                        }
                    }
                } else {
                    for (Resource res : resources) {
                        this.addRootPath(res.getURL());
                    }
                }
            }
            catch (IOException e) {
                LogFactory.getInstance().getLog().warning("Error initializing SpringLiquibase", e);
            }
        }

        @Override
        public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
            Resource[] resources;
            if (path == null) {
                return null;
            }
            HashSet<String> returnSet = new HashSet<String>();
            String tempFile = FilenameUtils.concat(FilenameUtils.getFullPath(relativeTo), path);
            for (Resource res : resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)SpringLiquibase.this.getResourceLoader()).getResources(this.adjustClasspath(tempFile))) {
                Set<String> list = super.list(null, res.getURL().toExternalForm(), includeFiles, includeDirectories, recursive);
                if (list == null) continue;
                returnSet.addAll(list);
            }
            return returnSet;
        }

        @Override
        public Set<InputStream> getResourcesAsStream(String path) throws IOException {
            if (path == null) {
                return null;
            }
            HashSet<InputStream> returnSet = new HashSet<InputStream>();
            Resource[] resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)SpringLiquibase.this.getResourceLoader()).getResources(this.adjustClasspath(path));
            if (resources == null || resources.length == 0) {
                return null;
            }
            for (Resource resource : resources) {
                LogFactory.getInstance().getLog().debug("Opening " + resource.getURL().toExternalForm() + " as " + path);
                URLConnection connection = resource.getURL().openConnection();
                connection.setUseCaches(false);
                returnSet.add(connection.getInputStream());
            }
            return returnSet;
        }

        public Resource getResource(String file) {
            return SpringLiquibase.this.getResourceLoader().getResource(this.adjustClasspath(file));
        }

        private String adjustClasspath(String file) {
            if (file == null) {
                return null;
            }
            return this.isPrefixPresent(this.parentFile) && !this.isPrefixPresent(file) ? "classpath:" + file : file;
        }

        public boolean isPrefixPresent(String file) {
            if (file == null) {
                return false;
            }
            return file.startsWith("classpath") || file.startsWith("file:") || file.startsWith("url:");
        }

        @Override
        public ClassLoader toClassLoader() {
            return SpringLiquibase.this.getResourceLoader().getClassLoader();
        }
    }
}

