/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import javax.swing.event.ChangeListener;
import org.netbeans.core.EnvironmentNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;

public final class NbPlaces {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static NbPlaces DEFAULT;

    private NbPlaces() {
    }

    public static synchronized NbPlaces getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new NbPlaces();
        }
        return DEFAULT;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    void fireChange() {
        this.cs.fireChange();
    }

    public Node environment() {
        return EnvironmentNode.find("environment");
    }

    public Node session() {
        return EnvironmentNode.find("session");
    }

    public Node[] roots() {
        return EnvironmentNode.find("roots").getChildren().getNodes();
    }

    public DataFolder toolbars() {
        return NbPlaces.findSessionFolder("Toolbars");
    }

    public DataFolder menus() {
        return NbPlaces.findSessionFolder("Menu");
    }

    public DataFolder actions() {
        return NbPlaces.findSessionFolder("Actions");
    }

    public static DataFolder findSessionFolder(String string) {
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) {
                fileObject = FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)string);
            }
            return DataFolder.findFolder((FileObject)fileObject);
        }
        catch (IOException iOException) {
            throw (IllegalStateException)new IllegalStateException("Folder not found and cannot be created: " + string).initCause(iOException);
        }
    }
}

