/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.tokenbinding;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.BadRandom;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.EllipticCurveType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.crypto.ECCUtilsBCWrapper;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.preparator.ProtocolMessagePreparator;
import de.rub.nds.tlsattacker.core.tokenbinding.TokenBindingMessage;
import de.rub.nds.tlsattacker.core.tokenbinding.TokenBindingMessageSerializer;
import de.rub.nds.tlsattacker.core.tokenbinding.TokenCalculator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.ECDSASigner;

public class TokenBindingMessagePreparator
extends ProtocolMessagePreparator<TokenBindingMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TokenBindingMessage message;

    public TokenBindingMessagePreparator(Chooser chooser, TokenBindingMessage message) {
        super(chooser, message);
        this.message = message;
    }

    @Override
    protected void prepareProtocolMessageContents() {
        this.message.setTokenbindingType(this.chooser.getConfig().getDefaultTokenBindingType().getTokenBindingTypeValue());
        this.message.setKeyParameter(this.chooser.getConfig().getDefaultTokenBindingKeyParameters().get(0).getValue());
        if (this.chooser.getConfig().getDefaultTokenBindingKeyParameters().get(0) == TokenBindingKeyParameters.ECDSAP256) {
            EllipticCurve curve = CurveFactory.getCurve(NamedGroup.SECP256R1);
            BigInteger privateKey = this.chooser.getConfig().getDefaultTokenBindingEcPrivateKey();
            LOGGER.debug("Using private Key:" + privateKey);
            Point publicKey = curve.mult(privateKey, curve.getBasePoint());
            this.message.setPoint(PointFormatter.toRawFormat(publicKey));
            this.message.setPointLength(((byte[])this.message.getPoint().getValue()).length);
            ParametersWithRandom params = new ParametersWithRandom((CipherParameters)new ECPrivateKeyParameters(privateKey, this.generateEcParameters()), (SecureRandom)new BadRandom(new Random(0L), new byte[0]));
            ECDSASigner signer = new ECDSASigner();
            signer.init(true, (CipherParameters)params);
            MessageDigest dig = null;
            try {
                dig = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new WorkflowExecutionException("Could not create SHA-256 digest", ex);
            }
            dig.update(this.generateToBeSigned());
            BigInteger[] signature = signer.generateSignature(dig.digest());
            this.message.setSignature(ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.bigIntegerToByteArray((BigInteger)signature[0]), ArrayConverter.bigIntegerToByteArray((BigInteger)signature[1])}));
        } else {
            this.message.setModulus(this.chooser.getConfig().getDefaultTokenBindingRsaModulus().toByteArray());
            this.message.setModulusLength(((byte[])this.message.getModulus().getValue()).length);
            this.message.setPublicExponent(this.chooser.getConfig().getDefaultTokenBindingRsaPublicKey().toByteArray());
            this.message.setPublicExponentLength(((byte[])this.message.getPublicExponent().getValue()).length);
        }
        TokenBindingMessageSerializer serializer = new TokenBindingMessageSerializer(this.message, this.chooser.getSelectedProtocolVersion());
        this.message.setKeyLength(serializer.serializeKey().length);
        this.message.setExtensionBytes(new byte[0]);
        this.message.setExtensionLength(((byte[])this.message.getExtensionBytes().getValue()).length);
        this.message.setSignatureLength(((byte[])this.message.getSignature().getValue()).length);
        serializer = new TokenBindingMessageSerializer(this.message, ProtocolVersion.TLS12);
        this.message.setTokenbindingsLength(serializer.serializeBinding().length);
    }

    private ECDomainParameters generateEcParameters() {
        ECDomainParameters ecParams;
        NamedGroup[] groups = new NamedGroup[]{NamedGroup.SECP256R1};
        ECPointFormat[] formats = new ECPointFormat[]{ECPointFormat.UNCOMPRESSED};
        ByteArrayInputStream is = new ByteArrayInputStream(ArrayConverter.concatenate((byte[][])new byte[][]{{EllipticCurveType.NAMED_CURVE.getValue()}, NamedGroup.SECP256R1.getValue()}));
        try {
            ecParams = ECCUtilsBCWrapper.readECParameters(groups, formats, (InputStream)is);
        }
        catch (IOException ex) {
            throw new PreparationException("Failed to generate EC domain parameters", ex);
        }
        return ecParams;
    }

    private byte[] generateToBeSigned() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(new byte[]{(Byte)this.message.getTokenbindingType().getValue()});
            stream.write(new byte[]{(Byte)this.message.getKeyParameter().getValue()});
            stream.write(TokenCalculator.calculateEKM(this.chooser, 32));
            return stream.toByteArray();
        }
        catch (CryptoException | IOException ex) {
            throw new PreparationException("Could not generate data to be Signed!", ex);
        }
    }
}

