/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.security.WSCollection;

public class WrapperServicePermission
extends Permission {
    private static final long serialVersionUID = -6520453688353960444L;
    public static String ACTION_START = "start";
    public static String ACTION_STOP = "stop";
    public static String ACTION_PAUSE = "pause";
    public static String ACTION_CONTINUE = "continue";
    public static String ACTION_INTERROGATE = "interrogate";
    public static String ACTION_USER_CODE = "userCode";
    private static int MASK_START = 1;
    private static int MASK_STOP = 2;
    private static int MASK_PAUSE = 4;
    private static int MASK_CONTINUE = 8;
    private static int MASK_INTERROGATE = 16;
    private static int MASK_USER_CODE = 32;
    private static int MASK_ALL = MASK_START | MASK_STOP | MASK_PAUSE | MASK_CONTINUE | MASK_INTERROGATE | MASK_USER_CODE;
    private int m_actionMask;

    public WrapperServicePermission(String serviceName, String actions) {
        super(serviceName);
        this.m_actionMask = this.buildActionMask(actions);
    }

    public WrapperServicePermission(String serviceName) {
        this(serviceName, "*");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WrapperServicePermission)) {
            return false;
        }
        WrapperServicePermission wsp = (WrapperServicePermission)obj;
        return this.m_actionMask == wsp.m_actionMask && this.getName().equals(wsp.getName());
    }

    public String getActions() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if ((this.m_actionMask & MASK_START) != 0) {
            if (first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(ACTION_START);
        }
        if ((this.m_actionMask & MASK_STOP) != 0) {
            if (first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(ACTION_STOP);
        }
        if ((this.m_actionMask & MASK_PAUSE) != 0) {
            if (first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(ACTION_CONTINUE);
        }
        if ((this.m_actionMask & MASK_CONTINUE) != 0) {
            if (first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(ACTION_CONTINUE);
        }
        if ((this.m_actionMask & MASK_INTERROGATE) != 0) {
            if (first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(ACTION_INTERROGATE);
        }
        if ((this.m_actionMask & MASK_USER_CODE) != 0) {
            if (first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(ACTION_USER_CODE);
        }
        return sb.toString();
    }

    public boolean implies(Permission p2) {
        if (!(p2 instanceof WrapperServicePermission)) {
            return false;
        }
        WrapperServicePermission wsp = (WrapperServicePermission)p2;
        return (this.m_actionMask & wsp.m_actionMask) == wsp.m_actionMask && this.impliesIgnoreActionMask(wsp);
    }

    public PermissionCollection newPermissionCollection() {
        return new WSCollection();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    int getActionMask() {
        return this.m_actionMask;
    }

    boolean impliesIgnoreActionMask(WrapperServicePermission p2) {
        if (this.getName().equals(p2.getName())) {
            return true;
        }
        return p2.getName().endsWith("*") && this.getName().startsWith(p2.getName().substring(0, p2.getName().length() - 1));
    }

    private int buildActionMask(String actions) {
        if (actions == ACTION_START) {
            return MASK_START;
        }
        if (actions == ACTION_STOP) {
            return MASK_STOP;
        }
        if (actions == ACTION_PAUSE) {
            return MASK_PAUSE;
        }
        if (actions == ACTION_CONTINUE) {
            return MASK_CONTINUE;
        }
        if (actions == ACTION_INTERROGATE) {
            return MASK_INTERROGATE;
        }
        if (actions == ACTION_USER_CODE) {
            return MASK_USER_CODE;
        }
        if (actions.equals("*")) {
            return MASK_ALL;
        }
        int mask = 0;
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            String action = st.nextToken();
            if (action.equals(ACTION_START)) {
                mask |= MASK_START;
                continue;
            }
            if (action.equals(ACTION_STOP)) {
                mask |= MASK_STOP;
                continue;
            }
            if (action.equals(ACTION_PAUSE)) {
                mask |= MASK_PAUSE;
                continue;
            }
            if (action.equals(ACTION_CONTINUE)) {
                mask |= MASK_CONTINUE;
                continue;
            }
            if (action.equals(ACTION_INTERROGATE)) {
                mask |= MASK_INTERROGATE;
                continue;
            }
            if (action.equals(ACTION_USER_CODE)) {
                mask |= MASK_USER_CODE;
                continue;
            }
            throw new IllegalArgumentException(WrapperManager.getRes().getString("Invalid permission action: \"{0}\"", action));
        }
        return mask;
    }
}

