/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.function.Supplier;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.tracing.TraceUtils;

public abstract class CoreAdminAPIBase
extends JerseyResource {
    protected final CoreContainer coreContainer;
    protected final CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker;
    protected final SolrQueryRequest req;
    protected final SolrQueryResponse rsp;

    public CoreAdminAPIBase(CoreContainer coreContainer, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker, SolrQueryRequest req, SolrQueryResponse rsp) {
        this.coreContainer = coreContainer;
        this.coreAdminAsyncTracker = coreAdminAsyncTracker;
        this.req = req;
        this.rsp = rsp;
    }

    public <T extends SolrJerseyResponse> T handlePotentiallyAsynchronousTask(T solrJerseyResponse, String coreName, String taskId, String actionName, Supplier<T> supplier) throws Exception {
        try {
            if (this.coreContainer == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
            }
            CoreAdminHandler.CoreAdminAsyncTracker.TaskObject taskObject = new CoreAdminHandler.CoreAdminAsyncTracker.TaskObject(taskId);
            MDCLoggingContext.setCoreName(coreName);
            TraceUtils.setDbInstance(this.req, coreName);
            if (taskId == null) {
                SolrJerseyResponse solrJerseyResponse2 = (SolrJerseyResponse)supplier.get();
                return (T)solrJerseyResponse2;
            }
            this.coreAdminAsyncTracker.submitAsyncTask(taskObject, actionName, () -> {
                SolrJerseyResponse response = (SolrJerseyResponse)supplier.get();
                V2ApiUtils.squashIntoSolrResponseWithoutHeader(this.rsp, response);
                return this.rsp;
            });
        }
        catch (CoreAdminAPIBaseException e) {
            throw e.trueException;
        }
        finally {
            this.rsp.setHttpCaching(false);
        }
        return solrJerseyResponse;
    }

    protected static class CoreAdminAPIBaseException
    extends RuntimeException {
        Exception trueException;

        public CoreAdminAPIBaseException(Exception trueException) {
            this.trueException = trueException;
        }
    }
}

