/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import com.codahale.metrics.Counter;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricsContext;

public abstract class HighlightingPluginBase
implements SolrInfoBean {
    protected Counter numRequests;
    protected SolrParams defaults;
    protected Set<String> metricNames = ConcurrentHashMap.newKeySet(1);
    protected SolrMetricsContext solrMetricsContext;

    public void init(NamedList<?> args) {
        Object o;
        if (args != null && (o = args.get("defaults")) != null && o instanceof NamedList) {
            this.defaults = ((NamedList)o).toSolrParams();
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public abstract String getDescription();

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.HIGHLIGHTER;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        this.numRequests = this.solrMetricsContext.counter("requests", this.getCategory().toString(), scope);
    }
}

