/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class SolrException
extends RuntimeException {
    public static final String ROOT_ERROR_CLASS = "root-error-class";
    public static final String ERROR_CLASS = "error-class";
    private final Map<String, String> mdcContext;
    int code = 0;
    protected NamedList<String> metadata;

    public SolrException(ErrorCode code, String msg) {
        super(msg);
        this.code = code.code;
        this.mdcContext = MDC.getCopyOfContextMap();
    }

    public SolrException(ErrorCode code, String msg, Throwable th) {
        super(msg, th);
        this.code = code.code;
        this.mdcContext = MDC.getCopyOfContextMap();
    }

    public SolrException(ErrorCode code, Throwable th) {
        super(th);
        this.code = code.code;
        this.mdcContext = MDC.getCopyOfContextMap();
    }

    protected SolrException(int code, String msg, Throwable th) {
        super(msg, th);
        this.code = code;
        this.mdcContext = MDC.getCopyOfContextMap();
    }

    public int code() {
        return this.code;
    }

    public void setMetadata(NamedList<String> metadata) {
        this.metadata = metadata;
    }

    public NamedList<String> getMetadata() {
        return this.metadata;
    }

    public String getMetadata(String key) {
        return this.metadata != null && key != null ? this.metadata.get(key) : null;
    }

    public void setMetadata(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Exception metadata cannot be null!");
        }
        if (this.metadata == null) {
            this.metadata = new NamedList();
        }
        this.metadata.add(key, value);
    }

    public String getThrowable() {
        return this.getMetadata(ERROR_CLASS);
    }

    public String getRootThrowable() {
        return this.getMetadata(ROOT_ERROR_CLASS);
    }

    @Deprecated
    public void log(Logger log) {
        SolrException.log(log, this);
    }

    @Deprecated
    public static void log(Logger log, Throwable e) {
        if (log.isErrorEnabled()) {
            log.error(e.toString(), e);
        }
    }

    @Deprecated
    public static void log(Logger log, String msg, Throwable e) {
        if (log.isErrorEnabled()) {
            log.error(msg, e);
        }
    }

    @Deprecated
    public static void log(Logger log, String msg) {
        if (log.isErrorEnabled()) {
            log.error(msg);
        }
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable cause;
        while ((cause = t.getCause()) != null) {
            t = cause;
        }
        return t;
    }

    public static SolrException wrapLuceneTragicExceptionIfNecessary(Exception e) {
        if (e instanceof SolrException) {
            SolrException solrException = (SolrException)e;
            assert (solrException.code() >= 500 && solrException.code() < 600);
            return solrException;
        }
        return new SolrException(ErrorCode.SERVER_ERROR, e.getMessage(), (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logInfoWithMdc(Logger logger, String msg) {
        Map previousMdcContext = MDC.getCopyOfContextMap();
        MDC.setContextMap(this.mdcContext);
        try {
            logger.info(msg);
        }
        finally {
            MDC.setContextMap((Map)previousMdcContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDebugWithMdc(Logger logger, String msg) {
        Map previousMdcContext = MDC.getCopyOfContextMap();
        MDC.setContextMap(this.mdcContext);
        try {
            logger.debug(msg);
        }
        finally {
            MDC.setContextMap((Map)previousMdcContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logWarnWithMdc(Logger logger, String msg) {
        Map previousMdcContext = MDC.getCopyOfContextMap();
        MDC.setContextMap(this.mdcContext);
        try {
            logger.warn(msg);
        }
        finally {
            MDC.setContextMap((Map)previousMdcContext);
        }
    }

    public static enum ErrorCode {
        BAD_REQUEST(400),
        UNAUTHORIZED(401),
        FORBIDDEN(403),
        NOT_FOUND(404),
        CONFLICT(409),
        UNSUPPORTED_MEDIA_TYPE(415),
        TOO_MANY_REQUESTS(429),
        SERVER_ERROR(500),
        SERVICE_UNAVAILABLE(503),
        INVALID_STATE(510),
        UNKNOWN(0);

        public final int code;

        private ErrorCode(int c) {
            this.code = c;
        }

        public static ErrorCode getErrorCode(int c) {
            for (ErrorCode err : ErrorCode.values()) {
                if (err.code != c) continue;
                return err;
            }
            return UNKNOWN;
        }
    }
}

