/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Constructor;
import java.nio.file.Path;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.LockFactory;

public final class CommandLineUtil {
    private CommandLineUtil() {
    }

    public static FSDirectory newFSDirectory(String clazzName, Path path) {
        return CommandLineUtil.newFSDirectory(clazzName, path, (LockFactory)FSLockFactory.getDefault());
    }

    public static FSDirectory newFSDirectory(String clazzName, Path path, LockFactory lf) {
        try {
            Class<? extends FSDirectory> clazz = CommandLineUtil.loadFSDirectoryClass(clazzName);
            return CommandLineUtil.newFSDirectory(clazz, path, lf);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(FSDirectory.class.getSimpleName() + " implementation not found: " + clazzName, e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(clazzName + " is not a " + FSDirectory.class.getSimpleName() + " implementation", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(clazzName + " constructor with " + Path.class.getSimpleName() + " as parameter not found", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating " + clazzName + " instance", e);
        }
    }

    public static Class<? extends Directory> loadDirectoryClass(String clazzName) throws ClassNotFoundException {
        return Class.forName(CommandLineUtil.adjustDirectoryClassName(clazzName)).asSubclass(Directory.class);
    }

    public static Class<? extends FSDirectory> loadFSDirectoryClass(String clazzName) throws ClassNotFoundException {
        return Class.forName(CommandLineUtil.adjustDirectoryClassName(clazzName)).asSubclass(FSDirectory.class);
    }

    private static String adjustDirectoryClassName(String clazzName) {
        if (clazzName == null || ((String)clazzName).trim().length() == 0) {
            throw new IllegalArgumentException("The " + FSDirectory.class.getSimpleName() + " implementation must not be null or empty");
        }
        if (((String)clazzName).indexOf(".") == -1) {
            clazzName = Directory.class.getPackage().getName() + "." + (String)clazzName;
        }
        return clazzName;
    }

    public static FSDirectory newFSDirectory(Class<? extends FSDirectory> clazz, Path path) throws ReflectiveOperationException {
        return CommandLineUtil.newFSDirectory(clazz, path, (LockFactory)FSLockFactory.getDefault());
    }

    public static FSDirectory newFSDirectory(Class<? extends FSDirectory> clazz, Path path, LockFactory lf) throws ReflectiveOperationException {
        Constructor<? extends FSDirectory> ctor = clazz.getConstructor(Path.class, LockFactory.class);
        return ctor.newInstance(path, lf);
    }
}

