'''OpenGL extension NV.query_resource_tag

This module customises the behaviour of the 
OpenGL.raw.GL.NV.query_resource_tag to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds the capability to associate a tag with one or more
	memory resource allocations. This tag can be reported back during
	queryResource operations and also be used to limit resource reporting to
	only those allocations with the specified tag. A tag is a previously
	reserved id and an optional text string.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/query_resource_tag.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.query_resource_tag import *
from OpenGL.raw.GL.NV.query_resource_tag import _EXTENSION_NAME

def glInitQueryResourceTagNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glGenQueryResourceTagNV.tagIds size not checked against n
glGenQueryResourceTagNV=wrapper.wrapper(glGenQueryResourceTagNV).setInputArraySize(
    'tagIds', None
)
# INPUT glDeleteQueryResourceTagNV.tagIds size not checked against n
glDeleteQueryResourceTagNV=wrapper.wrapper(glDeleteQueryResourceTagNV).setInputArraySize(
    'tagIds', None
)
### END AUTOGENERATED SECTION