/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_yue_Hans extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u963f\u62c9\u4f2f\u6587";
        final String metaValue_bn = "\u5b5f\u52a0\u62c9\u6587";
        final String metaValue_el = "\u5e0c\u814a\u6587";
        final String metaValue_gu = "\u53e4\u5409\u62c9\u7279\u6587";
        final String metaValue_he = "\u5e0c\u4f2f\u6765\u6587";
        final String metaValue_hy = "\u4e9a\u7f8e\u5c3c\u4e9a\u6587";
        final String metaValue_ja = "\u65e5\u6587";
        final String metaValue_jv = "\u722a\u54c7\u6587";
        final String metaValue_ka = "\u4e54\u6cbb\u4e9a\u6587";
        final String metaValue_km = "\u9ad8\u68c9\u6587";
        final String metaValue_kn = "\u574e\u90a3\u8fbe\u6587";
        final String metaValue_ko = "\u97e9\u6587";
        final String metaValue_la = "\u62c9\u4e01\u6587";
        final String metaValue_ml = "\u9a6c\u6765\u4e9a\u62c9\u59c6\u6587";
        final String metaValue_mn = "\u8499\u53e4\u6587";
        final String metaValue_my = "\u7f05\u7538\u6587";
        final String metaValue_or = "\u6b27\u5229\u4e9a\u6587";
        final String metaValue_sd = "\u4fe1\u5fb7\u6587";
        final String metaValue_su = "\u5dfd\u4ed6\u6587";
        final String metaValue_ta = "\u5766\u7c73\u5c14\u6587";
        final String metaValue_te = "\u6cf0\u5362\u56fa\u6587";
        final String metaValue_th = "\u6cf0\u6587";
        final String metaValue_ban = "\u5cc7\u91cc\u6587";
        final String metaValue_bas = "\u5df4\u8428\u6587";
        final String metaValue_bax = "\u5df4\u59c6\u7a46\u6587";
        final String metaValue_bug = "\u5e03\u5409\u65af\u6587";
        final String metaValue_ccp = "\u67e5\u514b\u9a6c\u6587";
        final String metaValue_chr = "\u67f4\u7f57\u57fa\u6587";
        final String metaValue_cop = "\u79d1\u666e\u7279\u6587";
        final String metaValue_mai = "\u8fc8\u8482\u5229\u6587";
        final String metaValue_men = "\u95e8\u5fb7\u6587";
        final String metaValue_peo = "\u53e4\u6ce2\u65af\u6587";
        final String metaValue_phn = "\u8153\u5c3c\u57fa\u6587";
        final String metaValue_saz = "\u7d22\u62c9\u4ec0\u7279\u62c9\u6587";
        final String metaValue_ssy = "\u8428\u970d\u6587";
        final String metaValue_uga = "\u4e4c\u52a0\u5217\u6587";
        final String metaValue_type_nu_taml = "\u5766\u7c73\u5c14\u6570\u5b57";
        final Object[][] data = new Object[][] {
            { "ksh", "\u79d1\u9686\u6587" },
            { "Ogam", "\u6b27\u7518\u6587" },
            { "mwl", "\u7c73\u5170\u5fb7\u65af\u6587" },
            { "Zsym", "\u7b26\u53f7" },
            { "cch", "\u963f\u707f\u6587" },
            { "mwr", "\u9a6c\u5c14\u5c3c\u91cc\u6587" },
            { "type.nu.lanatham", "\u5170\u7eb3\u6587\u6570\u5b57" },
            { "egl", "\u57c3\u7c73\u5229\u5b89\u6587" },
            { "mwv", "\u660e\u6253\u5a01\u6587" },
            { "Tagb", "\u5357\u5c9b\u6587" },
            { "Zsye", "\u8868\u60c5\u7b26\u53f7" },
            { "%%NJIVA", "\u96f7\u897f\u4e9a\u5c3c\u74e6\u65b9\u8a00" },
            { "xmf", "\u660e\u683c\u5217\u5c14\u6587" },
            { "ccp", metaValue_ccp },
            { "egy", "\u53e4\u57c3\u53ca\u6587" },
            { "raj", "\u62c9\u8d3e\u65af\u5766\u8bf8\u6587" },
            { "Phag", "\u516b\u601d\u5df4\u6587" },
            { "tem", "\u63d0\u59c6\u6587" },
            { "teo", "\u7279\u7d22\u6587" },
            { "rap", "\u590d\u6d3b\u5c9b\u6587" },
            { "ter", "\u6cf0\u96f7\u8bfa\u6587" },
            { "AC", "\u963f\u68ee\u677e\u5c9b" },
            { "rar", "\u62c9\u7f57\u901a\u52a0\u6587" },
            { "tet", "\u6cf0\u987f\u6587" },
            { "AD", "\u5b89\u9053\u5c14" },
            { "AE", "\u963f\u62c9\u4f2f\u8054\u5408\u5927\u516c\u56fd" },
            { "nl_BE", "\u4f5b\u5170\u8292\u6587" },
            { "AF", "\u963f\u5bcc\u6c57" },
            { "AG", "\u5b89\u63d0\u74dc\u540c\u5df4\u5e03\u8fbe" },
            { "type.ca.ethiopic", "\u8863\u7d22\u6bd4\u4e9a\u5386" },
            { "glk", "\u5409\u62c9\u57fa\u6587" },
            { "AI", "\u5b89\u572d\u62c9" },
            { "key.tz", "\u65f6\u533a" },
            { "AL", "\u963f\u5c14\u5df4\u5c3c\u4e9a" },
            { "AM", "\u4e9a\u7f8e\u5c3c\u4e9a" },
            { "Teng", "\u8c08\u683c\u74e6\u6587" },
            { "AO", "\u5b89\u54e5\u62c9" },
            { "AQ", "\u5357\u6781\u6d32" },
            { "AR", "\u963f\u6839\u5ef7" },
            { "Prti", "\u5e15\u63d0\u4e9a\u6587\uff08\u7891\u94ed\u4f53\uff09" },
            { "AS", "\u7f8e\u5c5e\u8428\u6469\u4e9a" },
            { "AT", "\u5965\u5730\u5229" },
            { "AU", "\u6fb3\u6d32" },
            { "AW", "\u8377\u5c5e\u963f\u9c81\u5df4" },
            { "AX", "\u5965\u5170\u7fa4\u5c9b" },
            { "mye", "\u59c6\u8036\u5185\u6587" },
            { "AZ", "\u4e9a\u585e\u62dc\u7136" },
            { "%%AREVELA", "\u4e9a\u7f8e\u5c3c\u4e9a\u4e1c\u90e8" },
            { "BA", "\u6ce2\u65af\u5c3c\u4e9a\u540c\u9ed1\u585e\u54e5\u7ef4\u90a3" },
            { "BB", "\u5df4\u8d1d\u591a" },
            { "ceb", "\u5bbf\u96fe\u6587" },
            { "BD", "\u5b5f\u52a0\u62c9" },
            { "kum", "\u5e93\u5bc6\u514b\u6587" },
            { "BE", "\u6bd4\u5229\u65f6" },
            { "gmh", "\u4e2d\u53e4\u9ad8\u5730\u5fb7\u6587" },
            { "BF", "\u5e03\u5409\u7eb3\u6cd5\u7d22" },
            { "BG", "\u4fdd\u52a0\u5229\u4e9a" },
            { "BH", "\u5df4\u6797" },
            { "BI", "\u84b2\u9686\u5730" },
            { "BJ", "\u8d1d\u5357" },
            { "BL", "\u5723\u5df4\u745f\u7c73" },
            { "BM", "\u767e\u6155\u8fbe" },
            { "kut", "\u5e93\u7279\u5948\u6587" },
            { "myv", "\u5384\u5c14\u5179\u4e9a\u6587" },
            { "BN", "\u6c76\u83b1" },
            { "BO", "\u73bb\u5229\u7ef4\u4e9a" },
            { "BQ", "\u8377\u5170\u52a0\u52d2\u6bd4\u533a" },
            { "BR", "\u5df4\u897f" },
            { "BS", "\u5df4\u54c8\u9a6c" },
            { "xog", "\u7d22\u52a0\u6587" },
            { "BT", "\u4e0d\u4e39" },
            { "BV", "\u5e03\u5a01\u5c9b" },
            { "BW", "\u6ce2\u672d\u90a3" },
            { "BY", "\u767d\u4fc4\u7f57\u65af" },
            { "BZ", "\u8d1d\u91cc\u65af" },
            { "Visp", "\u89c6\u89c9\u8bed\u97f3\u6587\u5b57" },
            { "type.ca.persian", "\u6ce2\u65af\u5386" },
            { "type.nu.hebr", "\u5e0c\u4f2f\u6765\u6570\u5b57" },
            { "CA", "\u52a0\u62ff\u5927" },
            { "CC", "\u79d1\u79d1\u65af\uff08\u57fa\u6797\uff09\u7fa4\u5c9b" },
            { "mzn", "\u9a6c\u8d5e\u5fb7\u5170\u6587" },
            { "CD", "\u521a\u679c\uff08\u91d1\u590f\u6c99\uff09" },
            { "CF", "\u4e2d\u975e\u5171\u548c\u56fd" },
            { "CG", "\u521a\u679c\uff08\u5e03\u62c9\u8428\uff09" },
            { "CH", "\u745e\u58eb" },
            { "CI", "\u8c61\u7259\u6d77\u5cb8" },
            { "CK", "\u5e93\u514b\u7fa4\u5c9b" },
            { "CL", "\u667a\u5229" },
            { "Kthi", "\u51ef\u63d0\u6587" },
            { "CM", "\u5580\u9ea6\u9686" },
            { "CN", "\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd" },
            { "CO", "\u54e5\u4f26\u6bd4\u4e9a" },
            { "CP", "\u514b\u91cc\u6d3e\u987f\u5c9b" },
            { "CR", "\u54e5\u65af\u5927\u9ece\u52a0" },
            { "CU", "\u53e4\u5df4" },
            { "CV", "\u7ef4\u5fb7\u89d2" },
            { "CW", "\u5e93\u62c9\u7d22" },
            { "CX", "\u5723\u8bde\u5c9b" },
            { "CY", "\u8d5b\u666e\u52d2\u65af" },
            { "type.nu.bali", "\u5cc7\u91cc\u6587\u6570\u5b57" },
            { "CZ", "\u6377\u514b" },
            { "eka", "\u827e\u5361\u6731\u514b\u6587" },
            { "vls", "\u897f\u4f5b\u5170\u5fb7\u6587" },
            { "DE", "\u5fb7\u56fd" },
            { "goh", "\u53e4\u9ad8\u5730\u65e5\u8033\u66fc\u6587" },
            { "ace", "\u4e9a\u9f50\u6587" },
            { "cgg", "\u5947\u52a0\u6587" },
            { "DG", "\u8fea\u4e9a\u54e5\u52a0\u897f\u4e9a\u5c9b" },
            { "gom", "\u5b54\u5361\u5c3c\u6587" },
            { "type.nu.deva", "\u68b5\u6587\u6570\u5b57" },
            { "DJ", "\u5409\u5e03\u5730" },
            { "DK", "\u4e39\u9ea6" },
            { "ach", "\u963f\u4fa8\u5229\u6587" },
            { "gon", "\u5188\u5fb7\u6587" },
            { "Brai", "\u76f2\u4eba\u7528\u70b9\u5b57" },
            { "Brah", "\u5a46\u7f57\u7c73\u6587" },
            { "DM", "\u591a\u7c73\u5c3c\u514b" },
            { "type.nu.armnlow", "\u5c0f\u5199\u4e9a\u7f8e\u5c3c\u4e9a\u6570\u5b57" },
            { "DO", "\u591a\u660e\u5c3c\u52a0\u5171\u548c\u56fd" },
            { "gor", "\u79d1\u9686\u8fbe\u7f57\u6587" },
            { "got", "\u54e5\u5fb7\u6587" },
            { "vmf", "\u7f8e\u8335-\u6cd5\u5170\u514b\u5c3c\u4e9a\u6587" },
            { "Mtei", "\u66fc\u5c3c\u666e\u5c14\u6587" },
            { "zun", "\u7956\u5c3c\u6587" },
            { "tig", "\u8482\u683c\u96f7\u6587" },
            { "Takr", "\u5854\u5361\u91cc\u6587\u5b57" },
            { "DZ", "\u963f\u5c14\u53ca\u5229\u4e9a" },
            { "pag", "\u6f58\u52a0\u8f9b\u6587" },
            { "type.d0.hwidth", "\u534a\u5f62" },
            { "pal", "\u5df4\u5217\u7ef4\u6587" },
            { "EA", "\u4f11\u8fbe\u4e0e\u6885\u5229\u5229\u4e9a" },
            { "chb", "\u5947\u5e03\u67e5\u6587" },
            { "pam", "\u6f58\u5e15\u5609\u6587" },
            { "EC", "\u5384\u74dc\u591a" },
            { "pap", "\u5e15\u76ae\u963f\u95e8\u6258\u6587" },
            { "ada", "\u963f\u5f53\u83ab\u6587" },
            { "EE", "\u7231\u6c99\u5c3c\u4e9a" },
            { "tiv", "\u63d0\u592b\u6587" },
            { "EG", "\u57c3\u53ca" },
            { "EH", "\u897f\u6492\u54c8\u62c9" },
            { "chg", "\u67e5\u52a0\u6587" },
            { "pau", "\u5e1b\u7409\u6587" },
            { "chk", "\u5904\u5947\u65af\u6587" },
            { "chn", "\u5951\u5974\u514b\u6587" },
            { "chm", "\u9a6c\u91cc\u6587" },
            { "chp", "\u5947\u4f69\u74e6\u626c\u6587" },
            { "cho", "\u4e54\u514b\u6258\u6587" },
            { "chr", metaValue_chr },
            { "ER", "\u5384\u5229\u5782\u4e9a" },
            { "ES", "\u897f\u73ed\u7259" },
            { "ET", "\u8863\u7d22\u6bd4\u4e9a" },
            { "EU", "\u6b27\u76df" },
            { "elx", "\u57c3\u5170\u6587" },
            { "type.ca.gregorian", "\u516c\u5386" },
            { "EZ", "\u6b27\u5143\u533a" },
            { "chy", "\u6c99\u4f0a\u5b89\u6587" },
            { "type.nu.gujr", "\u53e4\u5409\u62c9\u7279\u6570\u5b57" },
            { "Inds", "\u5370\u5ea6\u6cb3\u6d41\u57df\uff08\u54c8\u62c9\u5e15\u6587\uff09" },
            { "ady", "\u963f\u8fea\u5404\u6587" },
            { "aeb", "\u7a81\u5c3c\u65af\u963f\u62c9\u4f2f\u6587" },
            { "FI", "\u82ac\u5170" },
            { "FJ", "\u6590\u6d4e" },
            { "FK", "\u798f\u514b\u5170\u7fa4\u5c9b" },
            { "FM", "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a\u7fa4\u5c9b" },
            { "key.va", "\u533a\u57df\u53d8\u5f02" },
            { "FO", "\u6cd5\u7f57\u7fa4\u5c9b" },
            { "Taml", metaValue_ta },
            { "FR", "\u6cd5\u56fd" },
            { "Kpel", "\u514b\u57f9\u5217\u6587" },
            { "pcd", "\u5e87\u5361\u5e95\u6587" },
            { "tkl", "\u6258\u514b\u52b3\u6587" },
            { "grb", "\u683c\u5217\u535a\u6587" },
            { "type.ca.indian", "\u5370\u5ea6\u56fd\u5386" },
            { "rgn", "\u7f57\u9a6c\u683c\u8bfa\u91cc\u6587" },
            { "grc", "\u53e4\u5e0c\u814a\u6587" },
            { "GA", "\u52a0\u5f6d" },
            { "tkr", "\u67e5\u5e93\u5c14\u6587" },
            { "vot", "\u6c83\u63d0\u514b\u6587" },
            { "GB", "\u82f1\u56fd" },
            { "pcm", "\u5c3c\u65e5\u5229\u4e9a\u76ae\u94a6\u8bed" },
            { "GD", "\u683c\u745e\u90a3\u8fbe" },
            { "GE", "\u4e54\u6cbb\u4e9a\u5171\u548c\u56fd" },
            { "GF", "\u6cd5\u5c5e\u572d\u4e9a\u90a3" },
            { "GG", "\u6839\u897f\u5c9b" },
            { "GH", "\u8fe6\u7eb3" },
            { "Tale", "\u50a3\u54ea\u6587" },
            { "GI", "\u76f4\u5e03\u7f57\u9640" },
            { "afh", "\u963f\u5f17\u91cc\u5e0c\u5229\u6587" },
            { "GL", "\u683c\u9675\u5170" },
            { "enm", "\u4e2d\u53e4\u82f1\u6587" },
            { "GM", "\u7518\u6bd4\u4e9a" },
            { "GN", "\u51e0\u5185\u4e9a" },
            { "GP", "\u74dc\u5730\u6d1b\u666e" },
            { "GQ", "\u8d64\u9053\u51e0\u5185\u4e9a" },
            { "GR", "\u5e0c\u814a" },
            { "GS", "\u5357\u4f50\u6cbb\u4e9a\u5c9b\u540c\u5357\u6851\u5a01\u5947\u7fa4\u5c9b" },
            { "GT", "\u74dc\u5730\u9a6c\u62c9" },
            { "GU", "\u5173\u5c9b" },
            { "pdc", "\u5bbe\u5915\u6cd5\u5c3c\u4e9a\u5fb7\u6587" },
            { "GW", "\u51e0\u5185\u4e9a\u6bd4\u7d22" },
            { "tli", "\u7279\u6797\u57fa\u7279\u6587" },
            { "tlh", "\u514b\u6797\u8d21\u6587" },
            { "Talu", "\u897f\u53cc\u7248\u7eb3\u65b0\u50a3\u6587" },
            { "GY", "\u76d6\u4e9a\u90a3" },
            { "ckb", "\u7d22\u62c9\u5c3c\u5e93\u5c14\u5fb7\u6587" },
            { "zxx", "\u65e0\u8bed\u8a00\u5185\u5bb9" },
            { "Jurc", "\u5973\u771f\u6587\u5b57" },
            { "tly", "\u5854\u91cc\u4ec0\u6587" },
            { "pdt", "\u95e8\u8bfa\u4f4e\u5730\u5fb7\u6587" },
            { "HK", "\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a" },
            { "Vaii", "\u74e6\u4f9d\u6587" },
            { "HM", "\u8d6b\u5fb7\u5c9b\u540c\u9ea6\u514b\u5510\u7eb3\u7fa4\u5c9b" },
            { "HN", "\u5b8f\u90fd\u62c9\u65af" },
            { "HR", "\u514b\u7f57\u57c3\u897f\u4e9a" },
            { "agq", "\u4e9a\u7f55\u6587" },
            { "gsw", "\u5fb7\u6587\uff08\u745e\u58eb\uff09" },
            { "type.ca.islamic-umalqura", "\u4e4c\u59c6\u5e93\u62c9\u5386" },
            { "HT", "\u6d77\u5730" },
            { "HU", "\u5308\u7259\u5229" },
            { "rif", "\u91cc\u83f2\u4e9a\u8bfa\u6587" },
            { "tmh", "\u5854\u9a6c\u5947\u514b\u6587" },
            { "IC", "\u52a0\u90a3\u5229\u7fa4\u5c9b" },
            { "nan", "\u95fd\u5357\u8bed" },
            { "peo", metaValue_peo },
            { "ID", "\u5370\u5c3c" },
            { "type.nu.kali", "\u514b\u8036\u6570\u5b57" },
            { "IE", "\u7231\u5c14\u5170" },
            { "nap", "\u62ff\u6ce2\u91cc\u6587" },
            { "%%NDYUKA", "\u82cf\u5229\u5357\u6069\u90fd\u5361\u65b9\u8a00" },
            { "naq", "\u7eb3\u9a6c\u6587" },
            { "type.nu.sora", "\u7d22\u6717\u6851\u670b\u6570\u5b57" },
            { "zza", "\u624e\u624e\u6587" },
            { "Tang", "\u897f\u590f\u6587" },
            { "IL", "\u4ee5\u8272\u5217" },
            { "Nbat", "\u7eb3\u5df4\u6cf0\u6587\u5b57" },
            { "IM", "\u66fc\u5c9b" },
            { "IN", "\u5370\u5ea6" },
            { "type.co.eor", "\u6b27\u6d32\u6392\u5e8f\u89c4\u5219" },
            { "IO", "\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u5730" },
            { "IQ", "\u4f0a\u62c9\u514b" },
            { "IR", "\u4f0a\u6717" },
            { "IS", "\u51b0\u5c9b" },
            { "IT", "\u4e49\u5927\u5229" },
            { "Zmth", "\u6570\u5b66\u7b26\u53f7" },
            { "type.nu.thai", "\u6cf0\u6587\u6570\u5b57" },
            { "vro", "\u4f5b\u7f57\u6587" },
            { "guc", "\u74e6\u5c24\u6587" },
            { "%%POSIX", "\u7535\u8111" },
            { "type.nu.beng", "\u5b5f\u52a0\u62c9\u6570\u5b57" },
            { "pfl", "\u666e\u6cd5\u5c14\u8328\u5fb7\u6587" },
            { "JE", "\u6cfd\u897f\u5c9b" },
            { "type.ca.islamic", "\u4f0a\u65af\u5170\u5386" },
            { "Beng", metaValue_bn },
            { "JM", "\u7259\u4e70\u52a0" },
            { "JO", "\u7ea6\u65e6" },
            { "gur", "\u5f17\u62c9\u5f17\u62c9\u6587" },
            { "JP", "\u65e5\u672c" },
            { "%%1606NICT", "\u4e2d\u4e16\u7eaa\u665a\u671f\u6cd5\u6587\uff08\u81f31606\u5e74\uff09" },
            { "ain", "\u963f\u4f0a\u52aa\u6587" },
            { "Mend", metaValue_men },
            { "guz", "\u53e4\u897f\u6587" },
            { "tog", "\u4e1c\u52a0\u6587\uff08\u5c3c\u4e9a\u8428\uff09" },
            { "type.nu.knda", "\u574e\u90a3\u8fbe\u6570\u5b57" },
            { "Kali", "\u514b\u8036\u674e\u6587" },
            { "Sidd", "\u6089\u6619\u6587\u5b57" },
            { "de_CH", "\u9ad8\u5730\u5fb7\u6587\uff08\u745e\u58eb\uff09" },
            { "type.co.phonetic", "\u53d1\u97f3\u6392\u5e8f" },
            { "izh", "\u82f1\u683c\u91cc\u4e9a\u6587" },
            { "type.ca.buddhist", "\u4f5b\u5386" },
            { "KE", "\u80af\u4e9a" },
            { "419", "\u62c9\u4e01\u7f8e\u6d32" },
            { "KG", "\u5409\u5c14\u5409\u65af" },
            { "KH", "\u67ec\u57d4\u5be8" },
            { "KI", "\u5409\u91cc\u5df4\u65af" },
            { "KM", "\u845b\u6469" },
            { "Knda", metaValue_kn },
            { "KN", "\u5723\u57fa\u8328\u540c\u5c3c\u7ef4\u65af" },
            { "Zinh", "\u7ee7\u627f\u6587\u5b57\uff08Unicode\uff09" },
            { "KP", "\u5317\u97e9" },
            { "KR", "\u5357\u97e9" },
            { "Plrd", "\u67cf\u683c\u7406\u62fc\u97f3\u7b26" },
            { "KW", "\u79d1\u5a01\u7279" },
            { "tpi", "\u6258\u6bd4\u8f9b\u6587" },
            { "KY", "\u5f00\u66fc\u7fa4\u5c9b" },
            { "KZ", "\u54c8\u8428\u514b" },
            { "Cyrl", "\u65af\u62c9\u592b\u6587" },
            { "LA", "\u5bee\u56fd" },
            { "LB", "\u9ece\u5df4\u5ae9" },
            { "phn", metaValue_phn },
            { "LC", "\u5723\u9732\u897f\u4e9a" },
            { "Cyrs", "\u897f\u91cc\u5c14\u6587\uff08\u53e4\u6559\u4f1a\u65af\u62c9\u592b\u6587\u53d8\u4f53\uff09" },
            { "gwi", "\u572d\u5951\u6587" },
            { "%%LUNA1918", "\u4fc4\u7f57\u65af\u6587\u62fc\u5b57\uff081917\u5e74\u540e\uff09" },
            { "nds", "\u4f4e\u5730\u5fb7\u6587" },
            { "LI", "\u5217\u652f\u6566\u65af\u767b" },
            { "LK", "\u65af\u91cc\u5170\u5361" },
            { "akk", "\u963f\u5361\u5fb7\u6587" },
            { "cop", metaValue_cop },
            { "LR", "\u8d56\u6bd4\u745e\u4e9a" },
            { "esu", "\u4e2d\u5c24\u76ae\u514b\u6587" },
            { "LS", "\u8d56\u7d22\u6258" },
            { "Phlv", "\u5df4\u5217\u7ef4\u6587\uff08\u4e66\u4f53\uff09" },
            { "LT", "\u7acb\u9676\u5b9b" },
            { "LU", "\u5362\u68ee\u5821" },
            { "LV", "\u62c9\u8131\u7ef4\u4e9a" },
            { "Kana", "\u7247\u5047\u540d" },
            { "Sora", "\u7d22\u6717\u6851\u670b\u6587\u5b57" },
            { "LY", "\u5229\u6bd4\u4e9a" },
            { "lad", "\u62c9\u8fea\u8bfa\u6587" },
            { "vun", "\u6e29\u65e7\u6587" },
            { "akz", "\u963f\u62c9\u5df4\u9a6c\u6587" },
            { "%%LAUKIKA", "\u4f20\u7edf\u68b5\u6587" },
            { "lah", "\u62c9\u4ea8\u8fbe\u6587" },
            { "lag", "\u6717\u5409\u6587" },
            { "Thaa", "\u5854\u5b89\u90a3\u6587" },
            { "MA", "\u6469\u6d1b\u54e5" },
            { "MC", "\u6469\u7eb3\u54e5" },
            { "MD", "\u6469\u5c14\u591a\u74e6" },
            { "Nshu", "\u5973\u4e66\u6587\u5b57" },
            { "ME", "\u8499\u7279\u5185\u54e5\u7f57" },
            { "MF", "\u6cd5\u5c5e\u5723\u9a6c\u4e01" },
            { "lam", "\u5170\u5df4\u6587" },
            { "MG", "\u9a6c\u8fbe\u52a0\u65af\u52a0" },
            { "Thai", metaValue_th },
            { "MH", "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b" },
            { "ale", "\u963f\u7559\u7533\u6587" },
            { "type.nu.vaii", "\u74e6\u4f0a\u6587\u6570\u5b57" },
            { "MK", "\u9a6c\u5176\u987f" },
            { "ML", "\u9a6c\u5229" },
            { "MM", "\u7f05\u7538" },
            { "MN", "\u8499\u53e4" },
            { "new", "\u5c3c\u74e6\u5c14\u6587" },
            { "MO", "\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a" },
            { "aln", "\u76d6\u683c\u963f\u5c14\u5df4\u5c3c\u4e9a\u6587" },
            { "MP", "\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b" },
            { "MQ", "\u9a6c\u4e01\u5c3c\u514b\u5c9b" },
            { "MR", "\u8305\u5229\u5854\u5c3c\u4e9a" },
            { "MS", "\u8499\u54f2\u814a" },
            { "MT", "\u9a6c\u5c14\u4ed6" },
            { "cps", "\u5361\u76ae\u5179\u6587" },
            { "type.m0.ungegn", "\u8054\u5408\u56fd\u5730\u540d\u4e13\u5bb6\u7ec4" },
            { "MU", "\u6a21\u91cc\u897f\u65af" },
            { "alt", "\u5357\u963f\u5c14\u6cf0\u6587" },
            { "MV", "\u9a6c\u5c14\u5730\u592b" },
            { "MW", "\u9a6c\u62c9\u5a01" },
            { "MX", "\u58a8\u897f\u54e5" },
            { "type.ca.japanese", "\u65e5\u672c\u5386" },
            { "MY", "\u9a6c\u6765\u897f\u4e9a" },
            { "MZ", "\u83ab\u4e09\u6bd4\u514b" },
            { "Phli", "\u5df4\u5217\u7ef4\u6587\uff08\u7891\u94ed\u4f53\uff09" },
            { "NA", "\u7eb3\u7c73\u6bd4\u4e9a" },
            { "202", "\u6492\u54c8\u62c9\u4ee5\u5357\u975e\u6d32" },
            { "type.ca.hebrew", "\u5e0c\u4f2f\u6765\u5386" },
            { "type.co.dictionary", "\u5b57\u5178\u6392\u5e8f" },
            { "NC", "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a" },
            { "%%WADEGILE", "\u5a01\u59a5\u739b\u5f0f\u62fc\u97f3" },
            { "tru", "\u56fe\u7f57\u5c24\u6587" },
            { "%%UCRCOR", "\u7edf\u4e00\u5eb7\u6c83\u5c14\u6587\u4fee\u8ba2\u62fc\u5b57" },
            { "NE", "\u5c3c\u65e5" },
            { "NF", "\u8bfa\u798f\u514b\u5c9b" },
            { "NG", "\u5948\u53ca\u5229\u4e9a" },
            { "trv", "\u592a\u9c81\u9601\u6587" },
            { "Phlp", "\u5df4\u5217\u7ef4\u6587\uff08\u5723\u8bd7\u4f53\uff09" },
            { "NI", "\u5c3c\u52a0\u62c9\u74dc" },
            { "Hmng", "\u6768\u677e\u5f55\u82d7\u6587" },
            { "NL", "\u8377\u5170" },
            { "NO", "\u632a\u5a01" },
            { "NP", "\u5c3c\u6cca\u5c14" },
            { "NR", "\u8bfa\u9c81" },
            { "tsd", "\u7279\u8428\u514b\u5c3c\u6069\u6587" },
            { "Phnx", metaValue_phn },
            { "NU", "\u7ebd\u57c3\u5c9b" },
            { "rof", "\u5170\u535a\u6587" },
            { "tsi", "\u94a6\u897f\u5b89\u6587" },
            { "NZ", "\u7ebd\u897f\u5170" },
            { "Merc", "\u9ea6\u7f57\u57c3\u6587\uff08\u66f2\u7ebf\u5b57\u4f53\uff09" },
            { "rom", "\u5409\u666e\u8d5b\u6587" },
            { "Mero", "\u9ea6\u7f57\u57c3\u6587" },
            { "crh", "\u514b\u91cc\u7c73\u4e9a\u534a\u5c9b\u7684\u571f\u8033\u5176\u6587\uff1b\u514b\u91cc\u7c73\u4e9a\u534a\u5c9b\u7684\u5854\u5854\u5c14\u6587" },
            { "ang", "\u53e4\u82f1\u6587" },
            { "OM", "\u963f\u66fc\u738b\u56fd" },
            { "%%PETR1708", "\u4fc4\u7f57\u65af\u6587\u62fc\u5b57\uff081708 \u5e74\uff09" },
            { "anp", "\u6602\u52a0\u6587" },
            { "crs", "\u6cd5\u8bed\u514b\u91cc\u5965\u5c14\u6df7\u5408\u8bed" },
            { "Xpeo", metaValue_peo },
            { "PA", "\u5df4\u62ff\u9a6c" },
            { "type.ca.islamic-civil", "\u4f0a\u65af\u5170\u6c11\u7528\u5386" },
            { "csb", "\u5361\u8212\u5e03\u6587" },
            { "PE", "\u79d8\u9c81" },
            { "ttt", "\u7a46\u65af\u6797\u5854\u7279\u6587" },
            { "PF", "\u6cd5\u5c5e\u73bb\u91cc\u5c3c\u897f\u4e9a" },
            { "PG", "\u5df4\u5e03\u4e9a\u7ebd\u51e0\u5185\u4e9a" },
            { "PH", "\u83f2\u5f8b\u5bbe" },
            { "PK", "\u5df4\u57fa\u65af\u5766" },
            { "PL", "\u6ce2\u5170" },
            { "ewo", "\u4f9d\u6c6a\u90fd\u6587" },
            { "PM", "\u5723\u76ae\u57c3\u5c14\u540c\u5bc6\u514b\u9686\u7fa4\u5c9b" },
            { "PN", "\u76ae\u7279\u80af\u7fa4\u5c9b" },
            { "PR", "\u6ce2\u591a\u9ece\u5404" },
            { "Bali", metaValue_ban },
            { "PS", "\u5df4\u52d2\u65af\u5766\u81ea\u6cbb\u533a" },
            { "PT", "\u8461\u8404\u7259" },
            { "PW", "\u5e1b\u7409" },
            { "nia", "\u5c3c\u4e9a\u65af\u6587" },
            { "type.nu.greklow", "\u5c0f\u5199\u5e0c\u814a\u6570\u5b57" },
            { "PY", "\u5df4\u62c9\u572d" },
            { "tum", "\u56fe\u59c6\u5e03\u5361\u6587" },
            { "Hebr", metaValue_he },
            { "QA", "\u5361\u8fbe" },
            { "%%SCOTLAND", "\u82cf\u683c\u5170\u6807\u51c6\u82f1\u8bed" },
            { "jam", "\u7259\u4e70\u52a0\u514b\u91cc\u5965\u5c14\u82f1\u6587" },
            { "pms", "\u76ae\u57c3\u8499\u7279\u6587" },
            { "niu", "\u7ebd\u57c3\u6587" },
            { "QO", "\u5927\u6d0b\u6d32\u8fb9\u7586\u7fa4\u5c9b" },
            { "ext", "\u57c3\u65af\u7279\u96f7\u9a6c\u675c\u62c9\u6587" },
            { "lez", "\u5217\u5179\u5e72\u6587" },
            { "%%FONUPA", "UPA \u62fc\u97f3" },
            { "type.nu.takr", "\u5854\u5361\u91cc\u6570\u5b57" },
            { "tvl", "\u5410\u74e6\u9c81\u6587" },
            { "Tavt", "\u50a3\u62c5\u6587" },
            { "001", "\u4e16\u754c" },
            { "002", "\u975e\u6d32" },
            { "njo", "\u963f\u6c83\u90a3\u52a0\u6587" },
            { "003", "\u5317\u7f8e\u6d32" },
            { "RE", "\u7559\u5c3c\u65fa" },
            { "005", "\u5357\u7f8e\u6d32" },
            { "lfn", "\u65b0\u5171\u540c\u8bed\u8a00" },
            { "jbo", "\u903b\u8f91\u6587" },
            { "pnt", "\u65c1\u72c4\u5e0c\u814a\u6587" },
            { "Rjng", "\u62c9\u8ba9\u6587" },
            { "009", "\u5927\u6d0b\u6d32" },
            { "%%SURSILV", "\u745e\u58eb\u82cf\u745f\u74e6\u65b9\u8a00" },
            { "RO", "\u7f57\u9a6c\u5c3c\u4e9a" },
            { "RS", "\u585e\u5c14\u7ef4\u4e9a" },
            { "Mroo", "\u8c2c\u6587" },
            { "RU", "\u4fc4\u7f57\u65af" },
            { "RW", "\u5362\u5b89\u8fbe" },
            { "type.nu.talu", "\u65b0\u50a3\u4ec2\u6587\u6570\u5b57" },
            { "Ugar", metaValue_uga },
            { "Mani", "\u6469\u5c3c\u6559\u6587" },
            { "Khar", "\u5361\u7f57\u987b\u63d0\u6587" },
            { "SA", "\u6c99\u4e4c\u5730\u963f\u62c9\u4f2f" },
            { "pon", "\u6ce2\u90a3\u8d1d\u6587" },
            { "Mand", "\u66fc\u5e95\u5b89\u6587" },
            { "SB", "\u7d22\u7f57\u95e8\u7fa4\u5c9b" },
            { "twq", "\u5317\u6851\u6d77\u6587" },
            { "011", "\u897f\u975e" },
            { "SC", "\u585e\u5e2d\u5c14" },
            { "SD", "\u82cf\u4e39" },
            { "013", "\u4e2d\u7f8e" },
            { "SE", "\u745e\u5178" },
            { "014", "\u4e1c\u975e" },
            { "arc", "\u963f\u62c9\u7c73\u6587" },
            { "Loma", "\u6d1b\u9a6c\u6587" },
            { "015", "\u5317\u975e" },
            { "SG", "\u65b0\u52a0\u5761" },
            { "SH", "\u5723\u8d6b\u52d2\u62ff\u5c9b" },
            { "type.lb.strict", "\u5f3a\u5236\u6362\u884c\u6837\u5f0f" },
            { "017", "\u4e2d\u975e" },
            { "SI", "\u65af\u6d1b\u7ef4\u5c3c\u4e9a" },
            { "018", "\u975e\u6d32\u5357\u90e8" },
            { "SJ", "\u65af\u74e6\u5c14\u5df4\u7279\u7fa4\u5c9b\u540c\u626c\u9a6c\u5ef6\u5c9b" },
            { "Bamu", metaValue_bax },
            { "019", "\u7f8e\u6d32" },
            { "SK", "\u65af\u6d1b\u4f10\u514b" },
            { "Wole", "\u6c83\u96f7\u827e\u6587" },
            { "SL", "\u72ee\u5b50\u5c71" },
            { "SM", "\u5723\u9a6c\u5229\u8bfa" },
            { "SN", "\u585e\u5185\u52a0\u5c14" },
            { "SO", "\u7d22\u9a6c\u5229\u4e9a" },
            { "arn", "\u9a6c\u666e\u5207\u6587" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "arp", "\u963f\u62c9\u5e15\u970d\u6587" },
            { "SR", "\u82cf\u5229\u5357" },
            { "aro", "\u963f\u62c9\u5965\u7eb3\u6587" },
            { "SS", "\u5357\u82cf\u4e39" },
            { "ST", "\u5723\u591a\u7f8e\u540c\u666e\u6797\u897f\u6bd4" },
            { "arq", "\u963f\u5c14\u53ca\u5229\u4e9a\u963f\u62c9\u4f2f\u6587" },
            { "SV", "\u8428\u5c14\u74e6\u591a" },
            { "SX", "\u8377\u5c5e\u5723\u9a6c\u4e01" },
            { "SY", "\u53d9\u5229\u4e9a" },
            { "yao", "\u7476\u6587" },
            { "SZ", "\u53f2\u74e6\u6d4e\u5170" },
            { "arw", "\u963f\u62c9\u74e6\u514b\u6587" },
            { "arz", "\u57c3\u53ca\u963f\u62c9\u4f2f\u6587" },
            { "ary", "\u6469\u6d1b\u54e5\u963f\u62c9\u4f2f\u6587" },
            { "yap", "\u96c5\u6d66\u6587" },
            { "rtm", "\u7f57\u56fe\u9a6c\u5c9b\u6587" },
            { "TA", "\u7279\u91cc\u65af\u5766\u8fbe\u5e93\u5c3c\u4e9a\u7fa4\u5c9b" },
            { "asa", "\u963f\u82cf\u6587" },
            { "type.ms.ussystem", "\u7f8e\u5236\u5ea6\u91cf\u5355\u4f4d\u7cfb\u7edf" },
            { "021", "\u5317\u7f8e" },
            { "TC", "\u571f\u514b\u65af\u53ca\u5f00\u79d1\u65af\u7fa4\u5c9b" },
            { "yav", "\u6d0b\u535e\u6587" },
            { "TD", "\u67e5\u5fb7" },
            { "TF", "\u6cd5\u5c5e\u5357\u65b9\u5c5e\u5730" },
            { "ase", "\u7f8e\u56fd\u624b\u8bed" },
            { "TG", "\u591a\u54e5" },
            { "TH", "\u6cf0\u56fd" },
            { "TJ", "\u5854\u5409\u514b" },
            { "029", "\u52a0\u52d2\u6bd4\u6d77" },
            { "TK", "\u6258\u514b\u52b3\u7fa4\u5c9b" },
            { "TL", "\u4e1c\u5e1d\u6c76" },
            { "ybb", "\u8036\u59c6\u5df4\u6587" },
            { "type.co.searchjl", "\u97e9\u6587\u5b50\u97f3\u6392\u5e8f" },
            { "TM", "\u571f\u5e93\u66fc" },
            { "%%BOONT", "\u5e03\u6069\u7279\u6797\u65b9\u8a00" },
            { "TN", "\u7a81\u5c3c\u897f\u4e9a" },
            { "TO", "\u4e1c\u52a0" },
            { "TR", "\u571f\u8033\u5176" },
            { "TT", "\u5343\u91cc\u8fbe\u540c\u591a\u5df4\u54e5" },
            { "TV", "\u5410\u74e6\u9c81" },
            { "TW", "\u53f0\u6e7e" },
            { "ast", "\u963f\u65af\u56fe\u91cc\u4e9a\u6587" },
            { "rue", "\u5362\u68ee\u5c3c\u4e9a\u6587" },
            { "rug", "\u7f57\u7ef4\u963f\u7eb3\u6587" },
            { "Orkh", "\u9102\u5c14\u6d51\u6587" },
            { "TZ", "\u5766\u5c1a\u5c3c\u4e9a" },
            { "nmg", "\u5938\u897f\u5965\u6587" },
            { "Zzzz", "\u672a\u77e5\u6587\u5b57" },
            { "Sind", metaValue_sd },
            { "UA", "\u4e4c\u514b\u5170" },
            { "lij", "\u5229\u53e4\u91cc\u4e9a\u6587" },
            { "rup", "\u7f57\u9a6c\u5c3c\u4e9a\u8bed\u7cfb" },
            { "030", "\u4e1c\u4e9a" },
            { "tyv", "\u571f\u51e1\u6587" },
            { "sw_CD", "\u53f2\u74e6\u5e0c\u91cc\u6587\uff08\u521a\u679c\uff09" },
            { "034", "\u5357\u4e9a" },
            { "hai", "\u6d77\u8fbe\u6587" },
            { "035", "\u4e1c\u5357\u4e9a" },
            { "UG", "\u4e4c\u5e72\u8fbe" },
            { "hak", "\u5ba2\u5bb6\u8bdd" },
            { "type.co.pinyin", "\u62fc\u97f3\u6392\u5e8f" },
            { "039", "\u5357\u6b27" },
            { "Sinh", "\u9521\u5170\u6587" },
            { "UM", "\u7f8e\u56fd\u672c\u571f\u5916\u5c0f\u5c9b\u5c7f" },
            { "liv", "\u5229\u4f0f\u5c3c\u4e9a\u6587" },
            { "UN", "\u8054\u5408\u56fd" },
            { "US", "\u7f8e\u56fd" },
            { "haw", "\u590f\u5a01\u5937\u6587" },
            { "%%1959ACAD", "\u767d\u4fc4\u7f57\u65af\u6587\uff08\u5b66\u672f\uff09" },
            { "type.co.gb2312han", "\u7b80\u4f53\u4e2d\u6587\u6392\u5e8f - GB2312" },
            { "UY", "\u4e4c\u62c9\u572d" },
            { "prg", "\u666e\u9c81\u58eb\u6587" },
            { "UZ", "\u4e4c\u5179\u522b\u514b" },
            { "tzm", "\u5854\u9a6c\u9f50\u683c\u7279\u6587" },
            { "type.co.stroke", "\u7b14\u753b\u6392\u5e8f" },
            { "nnh", "\u6069\u7518\u6f8e\u6587" },
            { "VA", "\u68b5\u8482\u5188" },
            { "pro", "\u53e4\u666e\u7f57\u65fa\u65af\u6587" },
            { "VC", "\u5723\u6587\u68ee\u7279\u540c\u683c\u6797\u7eb3\u4e01\u65af" },
            { "VE", "\u59d4\u5185\u745e\u62c9" },
            { "VG", "\u82f1\u5c5e\u7ef4\u4eac\u7fa4\u5c9b" },
            { "VI", "\u7f8e\u5c5e\u7ef4\u4eac\u7fa4\u5c9b" },
            { "VN", "\u8d8a\u5357" },
            { "VU", "\u4e07\u90a3\u675c" },
            { "nog", "\u8bfa\u76d6\u6587" },
            { "rwk", "\u7f57\u74e6\u6587" },
            { "non", "\u53e4\u8bfa\u5c14\u65af\u6587" },
            { "053", "\u6fb3\u6d32\u540c\u7ebd\u897f\u5170" },
            { "%%AREVMDA", "\u4e9a\u7f8e\u5c3c\u4e9a\u897f\u90e8" },
            { "054", "\u7f8e\u62c9\u5c3c\u897f\u4e9a" },
            { "WF", "\u74e6\u5229\u65af\u540c\u5bcc\u56fe\u7eb3\u7fa4\u5c9b" },
            { "type.co.traditional", "\u4f20\u7edf\u6392\u5e8f" },
            { "057", "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a" },
            { "jgo", "\u6069\u683c\u59c6\u5df4\u6587" },
            { "lkt", "\u62c9\u79d1\u5854\u6587" },
            { "nov", "\u8bfa\u7ef4\u4e9a\u6587" },
            { "type.nu.finance", "\u91d1\u878d\u6570\u5b57" },
            { "avk", "\u79d1\u5854\u74e6\u6587" },
            { "%%HEPBURN", "\u5e73\u6587\u5f0f\u7f57\u9a6c\u5b57" },
            { "wae", "\u74e6\u745f\u6587" },
            { "WS", "\u8428\u6469\u4e9a" },
            { "Bass", metaValue_bas },
            { "type.nu.mtei", "\u66fc\u5c3c\u666e\u5c14\u6570\u5b57" },
            { "wal", "\u74e6\u62c9\u83ab\u6587" },
            { "was", "\u74e6\u7ecd\u6587" },
            { "XA", "\u4f2a\u53e3\u97f3" },
            { "war", "\u74e6\u745e\u6587" },
            { "XB", "\u4f2a Bidi" },
            { "awa", "\u963f\u74e6\u6587" },
            { "061", "\u73bb\u91cc\u5c3c\u897f\u4e9a" },
            { "XK", "\u79d1\u7d22\u6c83" },
            { "type.nu.brah", "\u5a46\u7f57\u7c73\u6570\u5b57" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u975e\u4e66\u5199\u8bed\u8a00" },
            { "Olck", "\u6851\u5854\u5229\u6587" },
            { "wbp", "\u6c83\u76ae\u745e\u6587" },
            { "Batk", "\u5df4\u5854\u514b\u6587" },
            { "Blis", "\u5e03\u5217\u65af\u6587" },
            { "YE", "\u53f6\u95e8" },
            { "nqo", "\u66fc\u5fb7\u6587\u5b57 (N\u2019Ko)" },
            { "type.co.standard", "\u6807\u51c6\u6392\u5e8f" },
            { "lmo", "\u4f26\u5df4\u5e95\u6587" },
            { "fan", "\u82b3\u65cf\u6587" },
            { "%%ROZAJ", "\u96f7\u897f\u4e9a\u65b9\u8a00" },
            { "%%SUTSILV", "\u745e\u58eb\u82cf\u5e0c\u74e6\u65b9\u8a00" },
            { "fat", "\u82b3\u8482\u6587" },
            { "Sgnw", "\u624b\u8bed\u4e66\u5199\u7b26\u53f7" },
            { "YT", "\u9a6c\u7ea6\u7279" },
            { "type.nu.cham", "\u5360\u6587\u6570\u5b57" },
            { "ZA", "\u5357\u975e" },
            { "type.nu.sund", "\u5dfd\u4ed6\u6570\u5b57" },
            { "type.lb.loose", "\u5bbd\u677e\u6362\u884c\u6837\u5f0f" },
            { "Deva", "\u5929\u57ce\u6587" },
            { "type.nu.geor", "\u4e54\u6cbb\u4e9a\u6570\u5b57" },
            { "type.co.zhuyin", "\u6ce8\u97f3\u6392\u5e8f" },
            { "Hira", "\u5e73\u5047\u540d" },
            { "ZM", "\u5c1a\u6bd4\u4e9a" },
            { "%%PINYIN", "\u6c49\u8bed\u62fc\u97f3" },
            { "ZW", "\u8f9b\u5df4\u5a01" },
            { "ZZ", "\u672a\u77e5\u533a\u57df" },
            { "Runr", "\u53e4\u5317\u6b27\u6587\u5b57" },
            { "type.ms.metric", "\u516c\u5236" },
            { "type.ca.iso8601", "\u56fd\u9645\u6807\u51c6 ISO 8601" },
            { "lol", "\u8292\u6208\u6587" },
            { "nso", "\u5317\u7d22\u6258\u6587" },
            { "type.nu.telu", "\u6cf0\u5362\u56fa\u6570\u5b57" },
            { "loz", "\u6d1b\u9f50\u6587" },
            { "Nkgb", "\u7eb3\u897f\u683c\u5df4\u6587" },
            { "jmc", "\u9a6c\u6070\u7f8e\u6587" },
            { "hif", "\u6590\u6d4e\u5370\u5730\u6587" },
            { "type.nu.hansfin", "\u5927\u5199\u7b80\u4f53\u4e2d\u6587\u6570\u5b57" },
            { "hil", "\u5e0c\u5229\u76d6\u519c\u6587" },
            { "type.nu.arabext", "\u963f\u62c9\u4f2f-\u5370\u5ea6\u6269\u5145\u6570\u5b57" },
            { "nus", "\u52aa\u57c3\u5c14\u6587" },
            { "dak", "\u8fbe\u79d1\u4ed6\u6587" },
            { "type.nu.fullwide", "\u5168\u5f62\u6570\u5b57" },
            { "hit", "\u8d6b\u68af\u6587" },
            { "dar", "\u8fbe\u5c14\u683c\u74e6\u6587" },
            { "dav", "\u53f0\u5854\u6587" },
            { "Maya", "\u739b\u96c5\u8c61\u5f62\u6587\u5b57" },
            { "lrc", "\u5317\u5362\u5c14\u6587" },
            { "Copt", metaValue_cop },
            { "nwc", "\u53e4\u5c3c\u74e6\u5c14\u6587" },
            { "udm", "\u6c83\u8482\u827e\u514b\u6587" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "\u4f0a\u65af\u5170\u65b0\u6708\u5386" },
            { "Limb", "\u6797\u5e03\u6587" },
            { "sad", "\u6851\u8fbe\u97e6\u6587" },
            { "type.nu.roman", "\u7f57\u9a6c\u6570\u5b57" },
            { "sah", "\u96c5\u5e93\u7279\u6587" },
            { "type.nu.shrd", "\u590f\u62c9\u8fbe\u6570\u5b57" },
            { "ltg", "\u62c9\u7279\u52a0\u83b1\u6587" },
            { "sam", "\u8428\u739b\u5229\u4e9a\u963f\u62c9\u59c6\u6587" },
            { "Aghb", "\u9ad8\u52a0\u7d22\u963f\u5c14\u5df4\u5c3c\u4e9a\u6587" },
            { "%%SCOUSE", "\u5229\u7269\u6d66\u65b9\u8a00" },
            { "saq", "\u8428\u5e03\u9c81\u6587" },
            { "sas", "\u6492\u6492\u514b\u6587" },
            { "sat", "\u6563\u5854\u5229\u6587" },
            { "Tfng", "\u63d0\u975e\u7eb3\u6587" },
            { "saz", metaValue_saz },
            { "jpr", "\u72b9\u592a\u6559-\u6ce2\u65af\u6587" },
            { "type.d0.npinyin", "\u6570\u503c" },
            { "type.nu.native", "\u539f\u59cb\u6570\u5b57" },
            { "sba", "\u7518\u62dc\u6587" },
            { "Guru", "\u53e4\u9c81\u7a46\u5947\u6587" },
            { "%%ALUKU", "\u963f\u9c81\u5e93\u65b9\u8a00" },
            { "lua", "\u9c81\u5df4\u9c81\u9c81\u4e9a\u6587" },
            { "%%BISCAYAN", "\u6bd4\u65af\u5f00\u65b9\u8a00" },
            { "type.d0.fwidth", "\u5168\u5f62" },
            { "sbp", "\u6851\u53e4\u6587" },
            { "lui", "\u8def\u6613\u585e\u8bfa\u6587" },
            { "nyn", "\u5c3c\u626c\u79d1\u83b1\u6587" },
            { "nym", "\u5c3c\u626c\u97e6\u9f50\u6587" },
            { "lun", "\u5362\u6069\u8fbe\u6587" },
            { "nyo", "\u5c3c\u5965\u5570\u6587" },
            { "luo", "\u5362\u5965\u6587" },
            { "fil", "\u83f2\u5f8b\u5bbe\u6587" },
            { "hmn", "\u5b5f\u6587" },
            { "del", "\u5fb7\u62c9\u74e6\u6587" },
            { "lus", "\u5362\u6652\u6587" },
            { "bal", "\u4ffe\u8def\u652f\u6587" },
            { "den", "\u65af\u62c9\u592b" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "fit", "\u6258\u5c14\u8bb7\u82ac\u5170\u6587" },
            { "luy", "\u5362\u96c5\u6587" },
            { "bar", "\u5df4\u4f10\u5229\u4e9a\u6587" },
            { "bas", metaValue_bas },
            { "bax", metaValue_bax },
            { "jrb", "\u72b9\u592a\u963f\u62c9\u4f2f\u6587" },
            { "nzi", "\u5c3c\u5179\u9a6c\u6587" },
            { "sco", "\u82cf\u683c\u5170\u6587" },
            { "scn", "\u897f\u897f\u91cc\u6587" },
            { "aa", "\u963f\u6cd5\u6587" },
            { "ab", "\u963f\u5e03\u54c8\u5179\u6587" },
            { "bbc", "\u5df4\u5854\u514b\u6258\u5df4\u6587" },
            { "ae", "\u963f\u7eac\u65af\u9640\u6587" },
            { "af", "\u5357\u975e\u8377\u5170\u6587" },
            { "ak", "\u963f\u574e\u6587" },
            { "type.nu.cakm", "\u67e5\u514b\u9a6c\u6570\u5b57" },
            { "bbj", "\u6208\u9a6c\u62c9\u6587" },
            { "am", "\u963f\u59c6\u54c8\u62c9\u6587" },
            { "Arab", metaValue_ar },
            { "an", "\u963f\u62c9\u8d21\u6587" },
            { "%%SOLBA", "\u96f7\u897f\u4e9a\u53f2\u6258\u7ef4\u8428\u65b9\u8a00" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u7247\u5047\u540d\u6216\u5e73\u5047\u540d" },
            { "as", "\u963f\u8428\u59c6\u6587" },
            { "sdc", "\u8428\u4e01\u5c3c\u4e9a-\u8428\u8428\u91cc\u6587" },
            { "Lina", "\u7ebf\u6027\u6587\u5b57\uff08A\uff09" },
            { "av", "\u963f\u74e6\u5c14\u6587" },
            { "Linb", "\u7ebf\u6027\u6587\u5b57\uff08B\uff09" },
            { "sdh", "\u5357\u5e93\u5c14\u5fb7\u6587" },
            { "ay", "\u827e\u9a6c\u62c9\u6587" },
            { "az", "\u4e9a\u585e\u62dc\u7136\u6587" },
            { "Khoj", "\u514b\u5409\u5947\u6587\u5b57" },
            { "%%OSOJS", "\u96f7\u897f\u4e9a\u6b27\u897f\u4e9a\u67ef\u65b9\u8a00" },
            { "ba", "\u5df4\u4ec0\u5ba2\u5c14\u6587" },
            { "type.co.unihan", "\u90e8\u9996\u7b14\u753b\u6392\u5e8f" },
            { "be", "\u767d\u4fc4\u7f57\u65af\u6587" },
            { "bg", "\u4fdd\u52a0\u5229\u4e9a\u6587" },
            { "bi", "\u6bd4\u65af\u62c9\u9a6c\u6587" },
            { "type.nu.java", "\u722a\u54c7\u6587\u6570\u5b57" },
            { "bm", "\u73ed\u5df4\u62c9\u6587" },
            { "bn", metaValue_bn },
            { "bo", "\u85cf\u6587" },
            { "dgr", "\u591a\u683c\u91cc\u5e03\u6587" },
            { "br", "\u5e03\u5217\u5854\u5c3c\u6587" },
            { "bs", "\u6ce2\u58eb\u5c3c\u4e9a\u6587" },
            { "see", "\u585e\u8bb7\u5361\u6587" },
            { "Mymr", metaValue_my },
            { "sei", "\u745f\u91cc\u6587" },
            { "type.nu.laoo", "\u5bee\u56fd\u6570\u5b57" },
            { "seh", "\u8d5b\u7eb3\u6587" },
            { "Nkoo", "\u897f\u975e\u4e66\u9762\u8bed\u8a00 (N\u2019Ko)" },
            { "sel", "\u745f\u5c14\u5361\u666e\u6587" },
            { "ca", "\u52a0\u6cf0\u7f57\u5c3c\u4e9a\u6587" },
            { "ses", "\u4e1c\u6851\u6d77\u6587" },
            { "ce", "\u8f66\u81e3\u6587" },
            { "ch", "\u67e5\u83ab\u6d1b\u6587" },
            { "%%REVISED", "\u5df2\u4fee\u8ba2\u7684\u62fc\u5b57\u5b66" },
            { "co", "\u79d1\u897f\u5609\u6587" },
            { "Orya", metaValue_or },
            { "cr", "\u514b\u91cc\u6587" },
            { "cs", "\u6377\u514b\u6587" },
            { "cu", "\u5b97\u6559\u65af\u62c9\u592b\u6587" },
            { "yrl", "\u5948\u6069\u52a0\u56fe\u6587" },
            { "cv", "\u695a\u74e6\u4ec0\u6587" },
            { "cy", "\u5a01\u5c14\u65af\u6587" },
            { "type.nu.ethi", "\u8863\u7d22\u6bd4\u4e9a\u6570\u5b57" },
            { "Yiii", "\u5f5d\u6587" },
            { "da", "\u4e39\u9ea6\u6587" },
            { "de", "\u5fb7\u6587" },
            { "type.cf.standard", "\u6807\u51c6\u8d27\u5e01\u683c\u5f0f" },
            { "bej", "\u8d1d\u624e\u6587" },
            { "din", "\u4e01\u5361\u6587" },
            { "jut", "\u65e5\u5fb7\u5170\u6587" },
            { "Bugi", metaValue_bug },
            { "bem", "\u522b\u59c6\u5df4\u6587" },
            { "sga", "\u53e4\u7231\u5c14\u5170\u6587" },
            { "type.nu.mong", "\u8499\u53e4\u6570\u5b57" },
            { "dv", "\u8fea\u7ef4\u897f\u6587" },
            { "bew", "\u8d1d\u5854\u7ef4\u6587" },
            { "dz", "\u5b97\u5361\u6587" },
            { "bez", "\u8d1d\u7eb3\u6587" },
            { "type.ca.chinese", "\u519c\u5386" },
            { "lzh", "\u6587\u8a00\u6587" },
            { "Lisu", "\u6817\u50f3\u6587" },
            { "dje", "\u624e\u5c14\u9a6c\u6587" },
            { "sgs", "\u8428\u83ab\u5409\u5e0c\u4e9a\u6587" },
            { "type.nu.grek", "\u5e0c\u814a\u6570\u5b57" },
            { "ee", "\u57c3\u7ef4\u6587" },
            { "bfd", "\u5bcc\u7279\u6587" },
            { "type.lb.normal", "\u4e00\u822c\u6362\u884c\u6837\u5f0f" },
            { "ro_MD", "\u6469\u5c14\u591a\u74e6\u6587" },
            { "el", metaValue_el },
            { "en", "\u82f1\u6587" },
            { "eo", "\u4e16\u754c\u6587" },
            { "bfq", "\u5df4\u8fbe\u52a0\u6587" },
            { "lzz", "\u62c9\u5179\u6587" },
            { "type.co.big5han", "\u7e41\u4f53\u4e2d\u6587\u6392\u5e8f - Big5" },
            { "es", "\u897f\u73ed\u7259\u6587" },
            { "et", "\u7231\u6c99\u5c3c\u4e9a\u6587" },
            { "Hanb", "\u6c49\u8bed\u6ce8\u97f3" },
            { "eu", "\u5df4\u65af\u514b\u6587" },
            { "Buhd", "\u5e03\u5e0c\u5fb7\u6587" },
            { "Hang", "\u97e9\u6587\u5b57" },
            { "Samr", "\u6492\u9a6c\u5229\u4e9a\u6587" },
            { "shi", "\u5e0c\u5c14\u54c8\u6587" },
            { "hsb", "\u4e0a\u7d22\u5e03\u6587" },
            { "Hani", "\u6c49\u8bed" },
            { "%%ULSTER", "\u7231\u5c14\u5170\u963f\u5c14\u65af\u7279\u65b9\u8a00" },
            { "shn", "\u63b8\u6587" },
            { "Hano", "\u54c8\u52aa\u8bfa\u6587" },
            { "fa", "\u6ce2\u65af\u6587" },
            { "Hans", "\u7b80\u4f53" },
            { "type.nu.latn", "\u963f\u62c9\u4f2f\u6570\u5b57" },
            { "Hant", "\u7e41\u4f53" },
            { "ff", "\u5bcc\u62c9\u6587" },
            { "shu", "\u963f\u62c9\u4f2f\u6587\uff08\u67e5\u5fb7\uff09" },
            { "hsn", "\u6e58\u8bed" },
            { "fi", "\u82ac\u5170\u6587" },
            { "fj", "\u6590\u6d4e\u6587" },
            { "fon", "\u4e30\u6587" },
            { "bgn", "\u897f\u4ffe\u8def\u652f\u6587" },
            { "yue", "\u7ca4\u8bed" },
            { "fo", "\u6cd5\u7f57\u6587" },
            { "type.m0.bgn", "\u7f8e\u56fd\u5730\u540d\u59d4\u5458\u4f1a" },
            { "umb", "\u59c6\u672c\u675c\u6587" },
            { "fr", "\u6cd5\u6587" },
            { "sid", "\u5e0c\u8fbe\u6469\u6587" },
            { "fy", "\u897f\u5f17\u91cc\u897f\u4e9a\u6587" },
            { "ga", "\u7231\u5c14\u5170\u6587" },
            { "gd", "\u82cf\u683c\u5170\u76d6\u5c14\u6587" },
            { "gl", "\u52a0\u5229\u897f\u4e9a\u6587" },
            { "gn", "\u74dc\u62c9\u5c3c\u6587" },
            { "bho", "\u535a\u6770\u666e\u5c14\u6587" },
            { "und", "\u672a\u77e5\u8bed\u8a00" },
            { "type.ca.ethiopic-amete-alem", "\u8863\u7d22\u6bd4\u4e9a\u5386 (Amete Alem)" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u4f0a\u65af\u5170\u5929\u6587\u5386" },
            { "gv", "\u66fc\u5c9b\u6587" },
            { "type.nu.osma", "\u5965\u65af\u66fc\u4e9a\u6570\u5b57" },
            { "ha", "\u8c6a\u6492\u6587" },
            { "he", metaValue_he },
            { "hi", "\u5317\u5370\u5ea6\u6587" },
            { "hup", "\u80e1\u5e15\u6587" },
            { "bik", "\u6bd4\u79d1\u5c14\u6587" },
            { "bin", "\u6bd4\u5c3c\u6587" },
            { "ho", "\u897f\u91cc\u83ab\u56fe\u571f\u6587" },
            { "hr", "\u514b\u7f57\u57c3\u897f\u4e9a\u6587" },
            { "ht", "\u6d77\u5730\u6587" },
            { "hu", "\u5308\u7259\u5229\u6587" },
            { "hy", metaValue_hy },
            { "hz", "\u8d6b\u96f7\u7f57\u6587" },
            { "frc", "\u5361\u771f\u6cd5\u6587" },
            { "%%FONIPA", "IPA \u62fc\u97f3" },
            { "ia", "\u56fd\u9645\u6587" },
            { "Jamo", "\u97e9\u6587\u5b57\u6bcd" },
            { "id", "\u5370\u5c3c\u6587" },
            { "type.nu.tibt", "\u897f\u85cf\u6570\u5b57" },
            { "ie", "\u56fd\u9645\u6587\uff08E\uff09" },
            { "ig", "\u4f0a\u5e03\u6587" },
            { "ii", "\u56db\u5ddd\u5f5d\u6587" },
            { "frm", "\u4e2d\u53e4\u6cd5\u6587" },
            { "%%RUMGR", "\u7f57\u66fc\u4ec0\u6587" },
            { "ik", "\u4f9d\u5974\u76ae\u7ef4\u514b\u6587" },
            { "fro", "\u53e4\u6cd5\u6587" },
            { "frp", "\u6cd5\u5170\u514b-\u666e\u7f57\u65fa\u65af\u6587" },
            { "io", "\u4f0a\u591a\u6587" },
            { "frs", "\u4e1c\u5f17\u91cc\u897f\u4e9a\u6587" },
            { "bjn", "\u73ed\u4e9a\u5c14\u6587" },
            { "frr", "\u5317\u5f17\u91cc\u897f\u4e9a\u6587" },
            { "is", "\u51b0\u5c9b\u6587" },
            { "it", "\u4e49\u5927\u5229\u6587" },
            { "iu", "\u56e0\u7ebd\u7279\u6587" },
            { "sli", "\u4e0b\u897f\u5229\u897f\u4e9a\u6587" },
            { "%%HOGNORSK", "\u9ad8\u5730\u632a\u5a01\u6587" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "\u53e4\u5357\u963f\u62c9\u4f2f\u6587" },
            { "Sara", "\u6c99\u62c9\u5824\u6587" },
            { "doi", "\u591a\u683c\u6765\u6587" },
            { "sly", "\u585e\u62c9\u4e9a\u6587" },
            { "type.nu.lepc", "\u897f\u7eb3\u6587\u6570\u5b57" },
            { "bkm", "\u5eb7\u59c6\u6587" },
            { "sma", "\u5357\u8428\u7c73\u6587" },
            { "jv", metaValue_jv },
            { "Shaw", "\u7bab\u67cf\u7eb3\u5b57\u7b26" },
            { "%%BAUDDHA", "\u4f5b\u6559\u6df7\u5408\u68b5\u6587" },
            { "mad", "\u9a6c\u90fd\u62c9\u6587" },
            { "smj", "\u9c81\u52d2\u8428\u7c73\u6587" },
            { "mag", "\u9a6c\u52a0\u4f0a\u6587" },
            { "maf", "\u9a6c\u6cd5\u6587" },
            { "mai", metaValue_mai },
            { "smn", "\u4f0a\u7eb3\u91cc\u8428\u7c73\u6587" },
            { "ka", metaValue_ka },
            { "bla", "\u9521\u514b\u9521\u5361\u6587" },
            { "mak", "\u671b\u52a0\u9521\u6587" },
            { "wuu", "\u5434\u8bed" },
            { "sms", "\u65af\u79d1\u7279\u8428\u7c73\u6587" },
            { "man", "\u66fc\u4e01\u54e5\u6587" },
            { "kg", "\u521a\u679c\u6587" },
            { "Goth", "\u6b4c\u5fb7\u6587" },
            { "ki", "\u5409\u5e93\u5c24\u6587" },
            { "mas", "\u9a6c\u8d5b\u6587" },
            { "kj", "\u5e7f\u4e9a\u9a6c\u6587" },
            { "kk", "\u54c8\u8428\u514b\u6587" },
            { "kl", "\u683c\u9675\u5170\u6587" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u5361\u52aa\u91cc\u6587" },
            { "ks", "\u5580\u4ec0\u7c73\u5c14\u6587" },
            { "Cirt", "\u8272\u65af\u6587" },
            { "Lepc", "\u96f7\u5e03\u67e5\u6587" },
            { "Avst", "\u963f\u7ef4\u65af\u9640\u6587" },
            { "ku", "\u5e93\u5c14\u5fb7\u6587" },
            { "kv", "\u79d1\u7c73\u6587" },
            { "kw", "\u5eb7\u74e6\u8033\u6587" },
            { "ky", "\u5409\u5c14\u5409\u65af\u6587" },
            { "snk", "\u7d22\u5c3c\u57fa\u6587" },
            { "la", metaValue_la },
            { "lb", "\u5362\u68ee\u5821\u6587" },
            { "type.nu.mlym", "\u9a6c\u6765\u4e9a\u62c9\u59c6\u6570\u5b57" },
            { "lg", "\u5e72\u8fbe\u6587" },
            { "Roro", "\u6717\u683c\u6717\u683c\u8c61\u5f62\u6587" },
            { "li", "\u6797\u5821\u6587" },
            { "Tibt", "\u897f\u85cf\u6587" },
            { "ln", "\u6797\u52a0\u62c9\u6587" },
            { "fur", "\u5f17\u7559\u5229\u6587" },
            { "lo", "\u5bee\u6587" },
            { "type.ms.uksystem", "\u82f1\u5236\u5ea6\u91cf\u5355\u4f4d\u7cfb\u7edf" },
            { "type.nu.lana", "\u8001\u50a3\u6587\u6570\u5b57" },
            { "lt", "\u7acb\u9676\u5b9b\u6587" },
            { "lu", "\u9c81\u5df4\u52a0\u4e39\u52a0\u6587" },
            { "lv", "\u62c9\u8131\u7ef4\u4e9a\u6587" },
            { "sog", "\u7d22\u683c\u5e95\u4e9a\u7eb3\u6587" },
            { "ListCompositionPattern", "{0}\uff0c{1}" },
            { "mg", "\u9a6c\u62c9\u52a0\u4ec0\u6587" },
            { "mh", "\u9a6c\u7ecd\u5c14\u6587" },
            { "type.co.ducet", "\u9884\u8bbe Unicode \u6392\u5e8f" },
            { "mi", "\u6bdb\u5229\u6587" },
            { "mk", "\u9a6c\u5176\u987f\u6587" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u9a6c\u62c9\u5730\u6587" },
            { "ms", "\u9a6c\u6765\u6587" },
            { "mt", "\u9a6c\u5c14\u4ed6\u6587" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "\u83ab\u514b\u6c99\u6587" },
            { "mde", "\u9a6c\u5df4\u6587" },
            { "dsb", "\u4e0b\u7d22\u5e03\u6587" },
            { "Armi", "\u7687\u5ba4\u4e9a\u7f8e\u5c3c\u4e9a\u6587" },
            { "na", "\u8bfa\u9c81\u6587" },
            { "type.co.search", "\u4e00\u822c\u7528\u9014\u641c\u5bfb" },
            { "nb", "\u5df4\u514b\u6469\u632a\u5a01\u6587" },
            { "nd", "\u5317\u5730\u6bd5\u5217\u6587" },
            { "ne", "\u5c3c\u6cca\u5c14\u6587" },
            { "ng", "\u6069\u4e1c\u52a0\u6587" },
            { "mdr", "\u66fc\u8fbe\u6587" },
            { "nl", "\u8377\u5170\u6587" },
            { "nn", "\u8010\u8bfa\u65af\u514b\u632a\u5a01\u6587" },
            { "no", "\u632a\u5a01\u6587" },
            { "nr", "\u5357\u5730\u6bd5\u5217\u6587" },
            { "nv", "\u7eb3\u74e6\u970d\u6587" },
            { "kaa", "\u5361\u62c9\u5361\u5c14\u5e15\u514b\u6587" },
            { "ny", "\u5c3c\u626c\u8d3e\u6587" },
            { "kac", "\u5361\u7434\u6587" },
            { "kab", "\u5361\u6bd4\u5c14\u6587" },
            { "%%POLYTON", "\u5e0c\u814a\u6587\u591a\u8c03\u6b63\u5b57\u6cd5" },
            { "oc", "\u5965\u514b\u897f\u5766\u6587" },
            { "kaj", "\u5361\u6377\u6587" },
            { "kam", "\u5361\u59c6\u5df4\u6587" },
            { "men", metaValue_men },
            { "%%EMODENG", "\u65e9\u671f\u73b0\u4ee3\u82f1\u8bed" },
            { "oj", "\u5965\u6770\u5e03\u74e6\u6587" },
            { "mer", "\u6885\u9c81\u6587" },
            { "type.nu.armn", "\u4e9a\u7f8e\u5c3c\u4e9a\u6570\u5b57" },
            { "om", "\u5965\u7f57\u83ab\u6587" },
            { "kaw", "\u5361\u5a01\u6587" },
            { "dtp", "\u4e2d\u90e8\u675c\u987a\u6587" },
            { "or", metaValue_or },
            { "os", "\u5965\u585e\u63d0\u6587" },
            { "%%ALALC97", "\u7f8e\u56fd\u56fd\u4f1a\u56fe\u4e66\u9986\u6807\u51c6\u65b9\u6848\u7f57\u9a6c\u5316\uff081997\u5e74\u7248\uff09" },
            { "bpy", "\u6bd4\u4ec0\u5974\u666e\u83b1\u5229\u4e9a\u6587" },
            { "kbd", "\u5361\u5df4\u5c14\u8fbe\u6587" },
            { "mfe", "\u514b\u91cc\u5965\u6587\uff08\u6a21\u91cc\u897f\u65af\uff09" },
            { "srn", "\u82cf\u62c9\u5357\u4e1c\u588e\u6587" },
            { "pa", "\u65c1\u906e\u666e\u6587" },
            { "dua", "\u675c\u4e9a\u62c9\u6587" },
            { "srr", "\u585e\u96f7\u5c14\u6587" },
            { "%%LIPAW", "\u96f7\u897f\u4e9a\u5229\u6ce2\u74e6\u65b9\u8a00" },
            { "kbl", "\u5361\u5ff5\u5e03\u6587" },
            { "pi", "\u5df4\u5229\u6587" },
            { "bqi", "\u5df4\u8d6b\u8482\u4e9a\u91cc\u6587" },
            { "pl", "\u6ce2\u5170\u6587" },
            { "dum", "\u4e2d\u53e4\u8377\u5170\u6587" },
            { "type.nu.saur", "\u7d22\u62c9\u4ec0\u7279\u62c9\u6587\u6570\u5b57" },
            { "type.ca.dangi", "\u6a80\u7eaa\u5386" },
            { "%%VALLADER", "\u745e\u58eb\u74e6\u52d2\u5fb7\u65b9\u8a00" },
            { "ps", "\u666e\u4ec0\u56fe\u6587" },
            { "pt", "\u8461\u8404\u7259\u6587" },
            { "mga", "\u4e2d\u53e4\u7231\u5c14\u5170\u6587" },
            { "key.co", "\u6392\u5e8f" },
            { "kcg", "\u5361\u5854\u5e03\u6587" },
            { "mgh", "\u9a6c\u5938\u6587" },
            { "key.cf", "\u8d27\u5e01\u683c\u5f0f" },
            { "type.nu.nkoo", "\u66fc\u5fb7\u6570\u5b57" },
            { "bra", "\u5e03\u62c9\u6770\u6587" },
            { "key.ca", "\u5386\u6cd5" },
            { "%%JAUER", "\u7c73\u5179\u6cf0\u5c14\u65b9\u8a00" },
            { "Laoo", "\u5bee\u56fd\u6587" },
            { "%%SURMIRAN", "\u745e\u58eb\u82cf\u8fc8\u62c9\u65b9\u8a00" },
            { "mgo", "\u7f8e\u5854\u6587" },
            { "type.hc.h23", "24 \u5c0f\u65f6\u5236 (0\u201323)" },
            { "type.hc.h24", "24 \u5c0f\u65f6\u5236 (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "brh", "\u5e03\u62c9\u7ef4\u6587" },
            { "type.nu.mymr", "\u7f05\u7538\u6570\u5b57" },
            { "qu", "\u76d6\u695a\u74e6\u6587" },
            { "zap", "\u8428\u6ce2\u7279\u514b\u6587" },
            { "brx", "\u535a\u591a\u6587" },
            { "Lana", "\u84dd\u62ff\u6587" },
            { "kde", "\u9a6c\u5b54\u5fb7\u6587" },
            { "%%VAIDIKA", "\u5420\u9640\u68b5\u6587" },
            { "stq", "\u6c99\u7279\u83f2\u58eb\u5170\u6587" },
            { "Ethi", "\u8863\u7d22\u6bd4\u4e9a\u6587" },
            { "%%JYUTPING", "\u9999\u6e2f\u8bed\u8a00\u5b66\u5b66\u4f1a\u7ca4\u8bed\u62fc\u97f3" },
            { "type.hc.h12", "12 \u5c0f\u65f6\u5236 (1\u201312)" },
            { "type.hc.h11", "12 \u5c0f\u65f6\u5236 (0\u201311)" },
            { "rm", "\u7f57\u66fc\u65af\u6587" },
            { "rn", "\u9686\u8fea\u6587" },
            { "key.cu", "\u8d27\u5e01" },
            { "ro", "\u7f57\u9a6c\u5c3c\u4e9a\u6587" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "\u6b27\u5229\u4e9a\u6570\u5b57" },
            { "type.nu.hanidec", "\u4e2d\u6587\u5341\u8fdb\u4f4d\u6570\u5b57" },
            { "ru", "\u4fc4\u6587" },
            { "bss", "\u963f\u5e93\u8272\u6587" },
            { "rw", "\u5362\u5b89\u8fbe\u6587" },
            { "zbl", "\u5e03\u5217\u65af\u7b26\u53f7" },
            { "kea", "\u5361\u5e03\u5a01\u5c14\u7b2c\u6587" },
            { "mic", "\u7c73\u514b\u9a6c\u514b\u6587" },
            { "suk", "\u82cf\u5e93\u9a6c\u6587" },
            { "Dupl", "\u675c\u666e\u6d1b\u4f0a\u901f\u8bb0" },
            { "sa", "\u68b5\u6587" },
            { "%%UCCOR", "\u7edf\u4e00\u5eb7\u6c83\u5c14\u6587\u62fc\u5b57" },
            { "sc", "\u6492\u4e01\u6587" },
            { "sus", "\u82cf\u82cf\u6587" },
            { "sd", metaValue_sd },
            { "se", "\u5317\u65b9\u8428\u7c73\u6587" },
            { "min", "\u7c73\u5357\u5361\u5821\u6587" },
            { "sg", "\u6851\u6208\u6587" },
            { "sh", "\u585e\u5c14\u7ef4\u4e9a\u514b\u7f57\u57c3\u897f\u4e9a\u6587" },
            { "ken", "\u80af\u626c\u6587" },
            { "si", "\u50e7\u4f3d\u7f57\u6587" },
            { "sux", "\u82cf\u7f8e\u6587" },
            { "sk", "\u65af\u6d1b\u4f10\u514b\u6587" },
            { "sl", "\u65af\u6d1b\u7ef4\u5c3c\u4e9a\u6587" },
            { "Gran", "\u683c\u5170\u4ed6\u6587\u5b57" },
            { "sm", "\u8428\u6469\u4e9a\u6587" },
            { "sn", "\u585e\u5185\u52a0\u5c14\u6587" },
            { "so", "\u7d22\u9a6c\u5229\u6587" },
            { "type.nu.arab", "\u963f\u62c9\u4f2f-\u5370\u5ea6\u6570\u5b57" },
            { "sq", "\u963f\u5c14\u5df4\u5c3c\u4e9a\u6587" },
            { "sr", "\u585e\u5c14\u7ef4\u4e9a\u6587" },
            { "ListKeyTypePattern", "{0}\uff1a{1}" },
            { "ss", "\u65af\u74e6\u7279\u6587" },
            { "type.cf.account", "\u4f1a\u8ba1\u8d27\u5e01\u683c\u5f0f" },
            { "Java", metaValue_jv },
            { "st", "\u585e\u7d22\u6258\u6587" },
            { "su", metaValue_su },
            { "%%NEDIS", "\u90a3\u63d0\u677e\u5c3c\u65b9\u8a00" },
            { "sv", "\u745e\u5178\u6587" },
            { "sw", "\u53f2\u74e6\u5e0c\u91cc\u6587" },
            { "type.nu.hantfin", "\u5927\u5199\u7e41\u4f53\u4e2d\u6587\u6570\u5b57" },
            { "ibb", "\u4f0a\u6bd4\u6bd4\u5965\u6587" },
            { "iba", "\u4f0a\u73ed\u6587" },
            { "ta", metaValue_ta },
            { "142", "\u4e9a\u6d32" },
            { "bua", "\u5e03\u91cc\u963f\u7279\u6587" },
            { "143", "\u4e2d\u4e9a" },
            { "te", metaValue_te },
            { "145", "\u897f\u4e9a" },
            { "tg", "\u5854\u5409\u514b\u6587" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "\u63d0\u683c\u5229\u5c3c\u4e9a\u6587" },
            { "kfo", "\u79d1\u7f57\u6587" },
            { "tk", "\u571f\u5e93\u66fc\u6587" },
            { "tl", "\u5854\u52a0\u8def\u65cf\u6587" },
            { "tn", "\u7a81\u5c3c\u897f\u4e9a\u6587" },
            { "to", "\u4e1c\u52a0\u6587" },
            { "bum", "\u5e03\u9c81\u6587" },
            { "dyo", "\u6731\u62c9\u6587" },
            { "type.nu.jpan", "\u5c0f\u5199\u65e5\u6587\u6570\u5b57" },
            { "tr", "\u571f\u8033\u5176\u6587" },
            { "Cakm", metaValue_ccp },
            { "ts", "\u7279\u677e\u52a0\u6587" },
            { "swb", "\u845b\u6469\u6587" },
            { "tt", "\u9791\u977c\u6587" },
            { "dyu", "\u8fea\u5c24\u62c9\u6587" },
            { "tw", "\u7279\u5a01\u6587" },
            { "ty", "\u5927\u6eaa\u5730\u6587" },
            { "%%BISKE", "San Giorgio/Bila \u65b9\u8a00" },
            { "150", "\u6b27\u6d32" },
            { "151", "\u4e1c\u6b27" },
            { "154", "\u5317\u6b27" },
            { "dzg", "\u8fbe\u8428\u6587" },
            { "155", "\u897f\u6b27" },
            { "ug", "\u7ef4\u543e\u5c14\u6587" },
            { "Kore", metaValue_ko },
            { "Ital", "\u53e4\u610f\u5927\u5229\u6587" },
            { "kgp", "\u574e\u521a\u6587" },
            { "Zyyy", "\u4e00\u822c\u6587\u5b57" },
            { "uk", "\u4e4c\u514b\u5170\u6587" },
            { "zea", "\u897f\u5170\u6587" },
            { "type.ca.coptic", "\u79d1\u666e\u7279\u5386" },
            { "ur", "\u4e4c\u90fd\u6587" },
            { "%%1994", "\u6807\u51c6\u96f7\u897f\u4e9a\u62fc\u5b57" },
            { "xal", "\u5361\u5c14\u6885\u514b\u6587" },
            { "zen", "\u6cfd\u7eb3\u52a0\u6587" },
            { "uz", "\u4e4c\u5179\u522b\u514b\u6587" },
            { "kha", "\u5361\u897f\u6587" },
            { "%%1996", "1996 \u5e74\u7684\u5fb7\u8bed\u62fc\u5b57\u5b66" },
            { "nds_NL", "\u4f4e\u5730\u8428\u514b\u900a\u6587" },
            { "Sylo", "\u5e0c\u6d1b\u5f1f\u7eb3\u683c\u91cc\u6587" },
            { "ve", "\u6e29\u8fbe\u6587" },
            { "Wara", "\u74e6\u90ce\u5947\u8482\u6587\u5b57" },
            { "type.ca.roc", "\u6c11\u56fd\u5386" },
            { "vi", "\u8d8a\u5357\u6587" },
            { "kho", "\u548c\u9617\u6587" },
            { "khq", "\u897f\u6851\u6d77\u6587" },
            { "key.hc", "\u65f6\u95f4\u5468\u671f\uff0812 \u5c0f\u65f6\u5236\u4e0e 24 \u5c0f\u65f6\u5236\uff09" },
            { "%%TARASK", "\u767d\u4fc4\u7f57\u65af\u6587\u4f20\u7edf\u62fc\u5b57" },
            { "vo", "\u6c83\u62c9\u666e\u514b\u6587" },
            { "khw", "\u79d1\u74e6\u6587" },
            { "syc", "\u53e4\u53d9\u5229\u4e9a\u6587" },
            { "Osma", "\u6b27\u65af\u66fc\u4e9a\u6587" },
            { "quc", "\u57fa\u5207\u6587" },
            { "qug", "\u94a6\u535a\u62c9\u7d22\u6d77\u5170\u76d6\u4e18\u4e9a\u6587" },
            { "gaa", "\u52a0\u65cf\u6587" },
            { "wa", "\u74e6\u9686\u6587" },
            { "gag", "\u52a0\u544a\u5179\u6587" },
            { "syr", "\u53d9\u5229\u4e9a\u6587" },
            { "Grek", metaValue_el },
            { "gan", "\u8d63\u8bed" },
            { "kiu", "\u5317\u624e\u624e\u5176\u6587" },
            { "Lydi", "\u91cc\u5e95\u4e9a\u8bed" },
            { "Xsux", "\u82cf\u7c73\u9c81\u4e9a\u7532\u6587\u6954\u5f62\u6587\u5b57" },
            { "wo", "\u6c83\u6d1b\u592b\u6587" },
            { "zgh", "\u6807\u51c6\u6469\u6d1b\u54e5\u5854\u9a6c\u585e\u7279\u6587" },
            { "ar_001", "\u73b0\u4ee3\u6807\u51c6\u963f\u62c9\u4f2f\u6587" },
            { "Cans", "\u52a0\u62ff\u5927\u539f\u4f4f\u6c11\u901a\u7528\u5b57\u7b26" },
            { "%%FONXSAMP", "X-SAMPA \u97f3\u6807" },
            { "gay", "\u52a0\u7ea6\u6587" },
            { "Mong", metaValue_mn },
            { "mnc", "\u6ee1\u65cf\u6587" },
            { "Latf", "\u62c9\u4e01\u6587\uff08\u5c16\u89d2\u4f53\u6d3b\u5b57\u53d8\u4f53\uff09" },
            { "szl", "\u897f\u5229\u897f\u4e9a\u6587" },
            { "Hluw", "\u5b89\u90a3\u6258\u5229\u4e9a\u8c61\u5f62\u6587\u5b57" },
            { "gba", "\u845b\u5df4\u4e9a\u6587" },
            { "mni", "\u66fc\u5c3c\u666e\u91cc\u6587" },
            { "Latn", metaValue_la },
            { "Latg", "\u62c9\u4e01\u6587\uff08\u76d6\u5c14\u8bed\u53d8\u4f53\uff09" },
            { "type.nu.hans", "\u5c0f\u5199\u7b80\u4f53\u4e2d\u6587\u6570\u5b57" },
            { "type.nu.hant", "\u5c0f\u5199\u7e41\u4f53\u4e2d\u6587\u6570\u5b57" },
            { "xh", "\u79d1\u8428\u6587" },
            { "type.nu.romanlow", "\u5c0f\u5199\u7f57\u9a6c\u6570\u5b57" },
            { "byn", "\u6bd4\u6797\u6587" },
            { "%%PAMAKA", "\u82cf\u5229\u5357\u5e15\u9a6c\u5361\u65b9\u8a00" },
            { "Lyci", "\u5415\u897f\u4e9a\u8bed" },
            { "osa", "\u6b27\u585e\u5947\u6587" },
            { "byv", "\u6885\u6566\u5df4\u6587" },
            { "gbz", "\u7d22\u7f57\u4e9a\u65af\u5fb7\u6559\u8fbe\u91cc\u6587" },
            { "Moon", "\u8499\u6c0f\u70b9\u5b57" },
            { "moh", "\u83ab\u970d\u514b\u6587" },
            { "kkj", "\u5361\u5e93\u6587" },
            { "%%1694ACAD", "\u65e9\u671f\u73b0\u4ee3\u6cd5\u6587" },
            { "yi", "\u610f\u7b2c\u7eea\u6587" },
            { "mos", "\u83ab\u897f\u6587" },
            { "Syrc", "\u654d\u5229\u4e9a\u6587" },
            { "Dsrt", "\u5fb7\u745f\u96f7\u7279\u6587" },
            { "yo", "\u7ea6\u9c81\u5df4\u6587" },
            { "type.nu.traditional", "\u4f20\u7edf\u6570\u5b57" },
            { "Syrj", "\u53d9\u5229\u4e9a\u6587\uff08\u897f\u65b9\u6587\u5b57\u53d8\u4f53\uff09" },
            { "ota", "\u9102\u56fe\u66fc\u571f\u8033\u5176\u6587" },
            { "Syre", "\u53d9\u5229\u4e9a\u6587\uff08\u798f\u97f3\u4f53\u6587\u5b57\u53d8\u4f53\uff09" },
            { "vai", "\u74e6\u4f0a\u6587" },
            { "za", "\u58ee\u6587" },
            { "Cari", "\u5361\u91cc\u4e9a\u6587" },
            { "kln", "\u5361\u4f26\u91d1\u6587" },
            { "zh", "\u4e2d\u6587" },
            { "Afak", "\u963f\u6cd5\u5361\u6587\u5b57" },
            { "Bopo", "\u6ce8\u97f3\u7b26\u53f7" },
            { "Perm", "\u53e4\u5f7c\u5c14\u59c6\u8bf8\u6587" },
            { "key.lb", "\u6362\u884c\u6837\u5f0f" },
            { "zu", "\u7956\u9c81\u6587" },
            { "type.co.phonebook", "\u7535\u8bdd\u7c3f\u6392\u5e8f" },
            { "%%MONOTON", "\u5e0c\u814a\u6587\u5355\u8c03\u6b63\u5b57\u6cd5" },
            { "Geor", metaValue_ka },
            { "Shrd", "\u590f\u62c9\u8fbe\u6587" },
            { "kmb", "\u91d1\u90a6\u675c\u6587" },
            { "type.nu.jpanfin", "\u5927\u5199\u65e5\u6587\u6570\u5b57" },
            { "Cham", "\u5360\u6587" },
            { "gez", "\u5409\u5179\u6587" },
            { "mrj", "\u897f\u9a6c\u91cc\u6587" },
            { "Syrn", "\u53d9\u5229\u4e9a\u6587\uff08\u4e1c\u65b9\u6587\u5b57\u53d8\u4f53\uff09" },
            { "type.nu.mymrshan", "\u7f05\u7538\u63b8\u6587\u6570\u5b57" },
            { "Elba", "\u7231\u5c14\u5df4\u6851\u6587" },
            { "Narb", "\u53e4\u5317\u963f\u62c9\u4f2f\u6587" },
            { "type.nu.olck", "\u6851\u5854\u5229\u6587\u6570\u5b57" },
            { "type.co.reformed", "\u6539\u826f\u6392\u5e8f" },
            { "Tglg", "\u5854\u52a0\u62c9\u6587" },
            { "Egyd", "\u53e4\u57c3\u53ca\u4e16\u4fd7\u4f53" },
            { "Egyh", "\u53e4\u57c3\u53ca\u50e7\u4fa3\u4f53" },
            { "%%ITIHASA", "\u53f2\u8bd7\u68b5\u6587" },
            { "Palm", "\u5e15\u7c73\u745e\u62c9\u6587\u5b57" },
            { "ebu", "\u6069\u5e03\u6587" },
            { "Egyp", "\u53e4\u57c3\u53ca\u8c61\u5f62\u6587\u5b57" },
            { "Geok", "\u4e54\u6cbb\u4e9a\u8bed\u7cfb\uff08\u963f\u7d22\u4ed6\u8def\u91cc\u548c\u52aa\u65af\u514b\u80e1\u91cc\u6587\uff09" },
            { "zh_Hans", "\u7b80\u4f53\u4e2d\u6587" },
            { "koi", "\u79d1\u7c73-\u5f7c\u5c14\u7c73\u4e9a\u514b\u6587" },
            { "Hung", "\u53e4\u5308\u7259\u5229\u6587" },
            { "kok", "\u8d21\u6839\u6587" },
            { "%%1901", "\u4f20\u7edf\u5fb7\u8bed\u62fc\u5b57\u5b66" },
            { "kos", "\u79d1\u65af\u96f7\u6069\u6587" },
            { "vec", "\u5a01\u5c3c\u65af\u6587" },
            { "type.nu.limb", "\u6797\u5e03\u6587\u6570\u5b57" },
            { "zh_Hant", "\u7e41\u4f53\u4e2d\u6587" },
            { "Sund", metaValue_su },
            { "vep", "\u7ef4\u666e\u68ee\u6587" },
            { "kpe", "\u514b\u4f69\u5217\u6587" },
            { "type.nu.khmr", "\u9ad8\u68c9\u6570\u5b57" },
            { "Tirh", metaValue_mai },
            { "ilo", "\u4f0a\u6d1b\u9614\u6587" },
            { "%%VALENCIA", "\u74e6\u4f26\u897f\u4e9a\u6587" },
            { "Cprt", "\u585e\u6d66\u8def\u65af\u6587" },
            { "%%BAKU1926", "\u7edf\u4e00\u571f\u8033\u5176\u62c9\u4e01\u5b57\u6bcd" },
            { "mua", "\u8499\u5f53\u6587" },
            { "type.nu.guru", "\u53e4\u5c14\u7a46\u5947\u6570\u5b57" },
            { "mul", "\u591a\u79cd\u8bed\u8a00" },
            { "%%PUTER", "\u745e\u58eb\u666e\u7279\u5c14\u65b9\u8a00" },
            { "cad", "\u5361\u591a\u6587" },
            { "key.ms", "\u5ea6\u91cf\u5355\u4f4d\u7cfb\u7edf" },
            { "mus", "\u514b\u91cc\u514b\u6587" },
            { "Glag", "\u683c\u62c9\u54e5\u91cc\u6587" },
            { "gil", "\u5409\u5c14\u4f2f\u7279\u7fa4\u5c9b\u6587" },
            { "%%KKCOR", "\u901a\u7528\u5eb7\u6c83\u5c14\u6587\u62fc\u5b57" },
            { "Cher", metaValue_chr },
            { "car", "\u52a0\u52d2\u6bd4\u6587" },
            { "cay", "\u5361\u5c24\u52a0\u6587" },
            { "type.nu.tamldec", metaValue_type_nu_taml },
            { "krc", "\u5361\u62c9\u67f4-\u5305\u5c14\u5361\u5c14\u6587" },
            { "inh", "\u5370\u53e4\u4ec0\u6587" },
            { "krj", "\u57fa\u90a3\u6765\u963f\u6587" },
            { "kri", "\u585e\u62c9\u5229\u6602\u514b\u91cc\u5965\u5c14\u6587" },
            { "fa_AF", "\u8fbe\u91cc\u6587" },
            { "krl", "\u5361\u7d2f\u5229\u963f\u6587" },
            { "efi", "\u57c3\u83f2\u514b\u6587" },
            { "tcy", "\u56fe\u5362\u6587" },
            { "key.nu", "\u6570\u5b57" },
            { "kru", "\u5e93\u9c81\u79d1\u6587" },
            { "ksb", "\u5c1a\u5df4\u62c9\u6587" },
            { "Telu", metaValue_te },
            { "ksf", "\u5df4\u83f2\u4e9a\u6587" },
        };
        return data;
    }
}
