%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/using-tags-to-produce-mensural-and-modern-music-from-the-same-source.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from `Documentation/snippets/new/`.
%%
%% Make any changes in `Documentation/snippets/new/`,
%% then run `scripts/auxiliar/makelsr.pl --new`.
%%
%% This file is in the public domain.
%%
%% Note: this file works from version 2.23.12.

\version "2.23.13"

\header {
%% Translation of GIT committish: 0cc270b871321ae5aa8622cea8d8262aafd16641
  texidocja = "
タグを使用して、同じ音楽に対して計量音楽譜と現代譜の両方を生成@c
することができます。このスニペットでは、@code{menrest} 関数が定義されており、@c
計量音楽における休符の位置は維持しながら、現代譜における休符は通常の位置に@c
配置しています。タグは曲の終わりにある小節線を 2 つの楽譜で異なるものに@c
するために使用していますが、区別が必要な他の場面でも用いることができます:
例えば、現代譜では @qq{全休符} (R1, R\\breve など) を使用したいが、@c
計量音楽譜では通常の休符 (r1, r\\breve など) を使用したい場合です。@c
計量音楽を現代音楽に変換する作業は通常 @qq{転写 (transcription)} と呼ばれます。
"
  doctitleja = "タグを使用して同じソースから計量音楽譜と現代譜を生成する"

%% Translation of GIT committish: 2f3474d9af596d677ed5b7ce720ae4d0954a6b51
  texidocit = "
Usando le etichette (tag), è possibile usare la stessa musica per produrre sia
la musica mensurale che quella moderna.  In questo frammento, viene introdotta
la funzione @code{menrest}, che permette alle pause mensurali di essere
posizionate precisamente sul rigo come nell'originale, ma con le pause moderne
nella posizione standard.  Le etichette vengono usate per produrre diversi
tipi di stanghetta alla fine della musica, ma possono essere usate anche
quando sono necessarie altre differenze: per esempio se si vogliono usare
@qq{pause d'intero} (R1, R\\breve, etc.) nella musica moderna, ma pause
normali (r1, r\\breve, etc.) nella versione mensurale.  La conversione di
musica mensurale nel suo equivalente moderno viene solitamente chiamata
@code{trascrizione}.

"
  doctitleit = "Usare le etichette per produrre musica mensurale e moderna dallo stesso sorgente"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
 texidocfr = "
Grâce aux balises (@emph{tags}), il est possible d'utiliser une même
source pour produire une partition de musique mensurale et moderne. Dans
cet exemple est créée la fonction @code{menrest} qui permettra de
positionner les silence comme dans la version originale, tout en
respectant leur position sur une portée standard. Les balises permettent
aussi de gérer d'autres différenciations selon les besoins, comme des
« mesures de silence » (R1, R\\breve, etc.) en notation moderne mais des
silences normaux (r1, r\\breve, etc.) en notation ancienne. L'action de
convertir de la musique mensurale en version moderne est communément
appelée « transcription ».
"

  doctitlefr = "Recours aux balises pour produire une partition ancienne et moderne à partir de la même source"

  lsrtags = "ancient-notation, vocal-music"

  texidoc = "
Using tags, it is possible to produce both mensural and modern
notation from the same music.  In this snippet, a function
@code{menrest} is introduced, allowing mensural rests to be pitched as
in the original, but with modern rests in the standard staff position.
Tags can also be used where other differences are needed: for example
using @qq{whole measure rests} (@code{R1}, @code{R\\breve}, etc.) in
modern music, but normal rests (@code{r1}, @code{r\\breve}, etc.) in
the mensural version.  Converting mensural music to its modern
equivalent is usually referred to as @qq{transcription}.
"

  doctitle = "Using tags to produce mensural and modern music from the same source"
} % begin verbatim


menrest = #(define-music-function (note)
  (ly:music?)
#{
    \tag #'mens $(make-music 'RestEvent note)
    \tag #'mod $(make-music 'RestEvent note 'pitch '())
#})

MenStyle = {
  \autoBeamOff
  \override NoteHead.style = #'petrucci
  \override Score.BarNumber.transparent = ##t
  \override Stem.neutral-direction = #up
}

finalis = \section

Music = \relative c'' {
  \set Score.tempoHideNote = ##t
  \key f \major
  \time 4/4
  g1 d'2 \menrest bes4 bes2 a2 r4 g4 fis2.
  \finalis
}

MenLyr = \lyricmode { So farre, deere life, deare life }
ModLyr = \lyricmode { So far, dear life, dear life }

\score {
  \keepWithTag #'mens {
    <<
      \new MensuralStaff
      {
        \new MensuralVoice = Cantus
          \clef "mensural-c1" \MenStyle \Music
      }
      \new Lyrics \lyricsto Cantus \MenLyr
    >>
  }
}

\score {
  \keepWithTag #'mod {
    \new ChoirStaff <<
      \new Staff
      {
        \new Voice = Sop \with {
          \remove "Note_heads_engraver"
          \consists "Completion_heads_engraver"
          \remove "Rest_engraver"
          \consists "Completion_rest_engraver" }
        {
          \shiftDurations #1 #0 { \autoBeamOff \Music }
        }
      }
      \new Lyrics \lyricsto Sop \ModLyr
    >>
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
