%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/defining-predefined-fretboards-for-other-instruments.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: f11513f36c131dab18338d6a3a729e24a927150d
  texidocja = "
定義されたフレット図のリストに、標準的なギターのフレット図以外のものを@c
追加することができます。このファイルは、ベネズエラのクアトロのために@c
調弦といくつかのフレット図を追加する例を示しています。

このファイルは和音に運指を追加し、フレット図や @code{TabStaff} に表示する@c
方法も示しています。五線譜には運指は表示されません。

これらのフレット図は弦の情報を含んでいるため、移調することができません。@c
これは将来修正される予定があります。
"
  doctitleja = "他の楽器のためのフレットボードを定義する"

%% Translation of GIT committish: 2f3474d9af596d677ed5b7ce720ae4d0954a6b51
  texidocit = "
Si possono aggiungere diagrammi dei tasti predefiniti per nuovi strumenti
oltre a quelli standard per chitarra.  Questo frammento mostra come farlo
definendo una nuova accordatura e alcuni diagrammi predefiniti per il
@emph{quatro} venezuelano.

Mostra anche come includere le diteggiature negli accordi usati come punti
di riferimento per la consultazione degli accordi e come mostrarle nel
diagramma dei tasti e in @code{TabStaff}, ma non nella musica.

Questi diagrammi non sono trasponibili perché contengono informazioni
sulle corde.  È prevista una correzione in futuro.
"
  doctitleit = "Definire diagrammi dei tasti predefiniti per altri strumenti"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
La liste des diagrammes standards prédéfinis pour la guitare peut être
augmentée d'autres définitions spécifiques à d'autres instruments. Voici
comment définir un nouvel accordage ainsi que quelques diagrammes
prédéfinis pour le « cuatro vénézuélien ».

Cet exemple illustre aussi la manière d'ajouter des doigtés aux
accords ; ils serviront de référence pour la boucle d'accord et seront
indiqués dans les diagrammes et le @code{TabStaff}, mais pas dans la
musique.

Ces diagrammes ne peuvent pas être transposés, dans la mesure où ils
contiennent des informations sur les cordes. Ceci est amené à évoluer.
"

  doctitlefr = "Création de diagrammes de fret prédéfinis pour d'autres instruments"

%% Translation of GIT committish: 069c8e54d8eaf449262a180674330b31c8c723d9
  texidoces = "
Se pueden añadir diagramas de posiciones predefinidas para
instrumentos nuevos además de los estándar que se usan para la
guitarra.  Este archivo muestra cómo se hace, definiendo una afinación
nueva y unas cuantas posiciones para el cuatro venezolano.

Este archivo también muestra cómo se pueden incluir las digitaciones
en los acordes que se usan como puntos de referencia para la búsqueda
de acordes en la tabla, y mostrarse en el diagrama de posiciones y la
tablatura @code{TabStaff}, pero no en la música.

Estas posiciones no se pueden transportar porque contienen información
de las cuerdas.  Hay planes para corregir esto en un futuro.

"
  doctitlees = "Definición de posiciones predefinidas para otros instrumentos"

%% Translation of GIT committish: f23429bc5cfa9d141ef7b4509afc46c140308a1e
  texidocde = "
Vordefinierte Bunddiagramme können für neue Instrumente hinzugefügt werden
neben denen, die schon für die Gitarre definiert sind.  Dieses Schnipsel
zeigt, wie man eine neue Saitenstimmung definiert und dann eigene vordefinierte
Bunddiagramme bestimmt.  Das Beispiel ist für das venezualische Cuatro.

Dieses Schnipsel zeigt auch, wie Fingersatz in die Akkorde eingebunden
werden kann, um als Referenzpunkt für die Akkordauswahl benutzt werden
kann.  Dieser Fingersatz wird im Bunddiagramm und in der Tabulatur,
aber nicht in den Noten angezeigt.

Diese Bunddiagramme sind nicht transponierbar, weil sie Saiteninformationen
enthalten.  Das soll in der Zukunft verbessert werden.

"
  doctitlede = "Eigene vordefinierte Bunddiagramme für andere Instrumente erstellen"

%% Translation of GIT committish: 8ffecf6be17c6ec2ff87cf31873121a8cce29b09
  texidocca = "
Es poden afegir diagrames de posicions predefinides per a
instruments nous a més dels estàndard que s'usen per a la
guitarra.  Aquest fitxer mostra com es fa, definint una afinació
nova i unes quantes posicions per al cuatro veneçolà.

Aquest fitxer també mostra com es poden incloure les digitacions
als acords que s'usen com punts de referència per a la cerca
d'acords a la taula, i mostrar-se al diagrama de posiciones i la
tabulatura @code{TabStaff}, però no a la música.

Aquestes posicions no es poden transportar perquè contenen
informació de les cordes.  Hi ha plans per corregir això en un futur.

"
  doctitleca = "Definició de posicions predefinides per a d'altres instruments"

  lsrtags = "fretted-strings"

  texidoc = "
Predefined fret diagrams can be added for new instruments in addition
to the standards used for guitar.  This file shows how this is done by
defining a new string-tuning and a few predefined fretboards for the
Venezuelan @emph{cuatro}.

This file also shows how fingerings can be included in the chords used
as reference points for the chord lookup, and displayed in the fret
diagram and the @code{TabStaff}, but not the music.

These fretboards are not transposable because they contain string
information.  This is planned to be corrected in the future.
"

  doctitle = "Defining predefined fretboards for other instruments"
} % begin verbatim


% add FretBoards for the Cuatro
%   Note: This section could be put into a separate file
%      predefined-cuatro-fretboards.ly
%      and \included into each of your compositions

cuatroTuning = #`(,(ly:make-pitch 0 6 0)
                  ,(ly:make-pitch 1 3 SHARP)
		  ,(ly:make-pitch 1 1 0)
		  ,(ly:make-pitch 0 5 0))

dSix = { <a\4 b\1 d\3 fis\2> }
dMajor = { <a\4 d\1 d\3 fis \2> }
aMajSeven = { <a\4 cis\1 e\3 g\2> }
dMajSeven = { <a\4 c\1 d\3 fis\2> }
gMajor = { <b\4 b\1 d\3 g\2> }

\storePredefinedDiagram #default-fret-table \dSix
                        #cuatroTuning
                        #"o;o;o;o;"
\storePredefinedDiagram #default-fret-table \dMajor
                        #cuatroTuning
                        #"o;o;o;3-3;"
\storePredefinedDiagram #default-fret-table \aMajSeven
                        #cuatroTuning
                        #"o;2-2;1-1;2-3;"
\storePredefinedDiagram #default-fret-table \dMajSeven
                        #cuatroTuning
                        #"o;o;o;1-1;"
\storePredefinedDiagram #default-fret-table \gMajor
                        #cuatroTuning
                        #"2-2;o;1-1;o;"

% end of potential include file /predefined-cuatro-fretboards.ly


#(set-global-staff-size 16)

primerosNames = \chordmode {
  d:6 d a:maj7 d:maj7
  g
}
primeros = {
  \dSix \dMajor \aMajSeven \dMajSeven
  \gMajor
}

\score {
  <<
    \new ChordNames {
      \set chordChanges = ##t
      \primerosNames
    }

    \new Staff {
      \new Voice \with {
        \remove "New_fingering_engraver"
      }
      \relative c'' {
        \primeros
      }
    }

    \new FretBoards {
      \set Staff.stringTunings = #cuatroTuning
%      \override FretBoard
%        #'(fret-diagram-details string-count) = 4
      \override FretBoard.fret-diagram-details.finger-code = #'in-dot
      \primeros
    }

    \new TabStaff \relative c'' {
      \set TabStaff.stringTunings = #cuatroTuning
      \primeros
    }

  >>

  \layout {
    \context {
      \Score
      \override SpacingSpanner.base-shortest-duration =
        #(ly:make-moment 1 16)
    }
  }
  \midi { }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
