"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantPlugin = void 0;
var _operators = require("rxjs/operators");
var _basic_input_output_parser = require("./parsers/basic_input_output_parser");
var _visualization_card_parser = require("./parsers/visualization_card_parser");
var _chat_routes = require("./routes/chat_routes");
var _text2viz_routes = require("./routes/text2viz_routes");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class AssistantPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "messageParsers", []);
    this.logger = initializerContext.logger.get();
  }
  async setup(core) {
    this.logger.debug('Assistant: Setup');
    const config = await this.initializerContext.config.create().pipe((0, _operators.first)()).toPromise();
    const router = core.http.createRouter();
    core.http.registerRouteHandlerContext('assistant_plugin', () => {
      return {
        config,
        logger: this.logger
      };
    });

    // Register server side APIs
    (0, _chat_routes.registerChatRoutes)(router, {
      messageParsers: this.messageParsers,
      auth: core.http.auth
    });

    // Register router for text to visualization
    if (config.next.enabled) {
      (0, _text2viz_routes.registerText2VizRoutes)(router);
    }
    core.capabilities.registerProvider(() => ({
      observability: {
        show: true
      }
    }));
    const registerMessageParser = messageParser => {
      const findItem = this.messageParsers.find(item => item.id === messageParser.id);
      if (findItem) {
        throw new Error(`There is already a messageParser whose id is ${messageParser.id}`);
      }
      this.messageParsers.push(messageParser);
    };
    registerMessageParser(_basic_input_output_parser.BasicInputOutputParser);
    registerMessageParser(_visualization_card_parser.VisualizationCardParser);
    return {
      registerMessageParser,
      removeMessageParser: parserId => {
        const findIndex = this.messageParsers.findIndex(item => item.id === parserId);
        if (findIndex < 0) {
          this.logger.error(`There is not a messageParser whose id is ${parserId}`);
        }
        this.messageParsers.splice(findIndex, 1);
      }
    };
  }
  start(core) {
    this.logger.debug('Assistant: Started');
    return {};
  }
  stop() {}
}
exports.AssistantPlugin = AssistantPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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