/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.RecordComponentInfo;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;

public class ComponentInfoWithAnnotation
extends RecordComponentInfo {
    private final AnnotationInfo[] annotations;

    ComponentInfoWithAnnotation(RecordComponentInfo info, AnnotationInfo[] annos) {
        super(info.reference, info.constantPoolOffsets, info.structOffset, info.version);
        this.attributeBytes = info.attributeBytes;
        this.constantPoolOffsets = info.constantPoolOffsets;
        this.descriptor = info.descriptor;
        this.name = info.name;
        this.signature = info.signature;
        this.signatureUtf8Offset = info.signatureUtf8Offset;
        this.tagBits = info.tagBits;
        this.annotations = annos;
    }

    @Override
    public IBinaryAnnotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    protected void initialize() {
        if (this.annotations != null) {
            AnnotationInfo[] annotationInfoArray = this.annotations;
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationInfo annotation = annotationInfoArray[n2];
                annotation.initialize();
                ++n2;
            }
        }
        super.initialize();
    }

    @Override
    protected void reset() {
        if (this.annotations != null) {
            AnnotationInfo[] annotationInfoArray = this.annotations;
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationInfo annotation = annotationInfoArray[n2];
                annotation.reset();
                ++n2;
            }
        }
        super.reset();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getName());
        if (this.annotations != null) {
            buffer.append('\n');
            AnnotationInfo[] annotationInfoArray = this.annotations;
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationInfo annotation = annotationInfoArray[n2];
                buffer.append(annotation);
                buffer.append('\n');
                ++n2;
            }
        }
        this.toStringContent(buffer);
        return buffer.toString();
    }
}

