/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.schedule;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import org.traccar.LifecycleObject;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.schedule.ScheduleTask;
import org.traccar.schedule.TaskClearStatus;
import org.traccar.schedule.TaskDeleteTemporary;
import org.traccar.schedule.TaskDeviceInactivityCheck;
import org.traccar.schedule.TaskExpirations;
import org.traccar.schedule.TaskHealthCheck;
import org.traccar.schedule.TaskReports;
import org.traccar.schedule.TaskWebSocketKeepalive;

@Singleton
public class ScheduleManager
implements LifecycleObject {
    private final Injector injector;
    private final boolean secondary;
    private ScheduledExecutorService executor;

    @Inject
    public ScheduleManager(Injector injector, Config config) {
        this.injector = injector;
        this.secondary = config.getBoolean(Keys.BROADCAST_SECONDARY);
    }

    @Override
    public void start() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        Stream.of(TaskHealthCheck.class, TaskClearStatus.class, TaskExpirations.class, TaskDeleteTemporary.class, TaskReports.class, TaskDeviceInactivityCheck.class, TaskWebSocketKeepalive.class).forEachOrdered(taskClass -> {
            ScheduleTask task = (ScheduleTask)this.injector.getInstance(taskClass);
            if (task.multipleInstances() || !this.secondary) {
                task.schedule(this.executor);
            }
        });
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }
}

