/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.GenericArray;

public class U2Array
extends GenericArray {
    private static long dataFieldOffset;
    protected static Type elemType;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        elemType = db.lookupType("u2");
        Type type = db.lookupType("Array<u2>");
        dataFieldOffset = type.getAddressField("_data").getOffset();
    }

    public U2Array(Address addr) {
        super(addr, dataFieldOffset);
    }

    public short at(int i) {
        return (short)this.getIntegerAt(i);
    }

    @Override
    public Type getElemType() {
        return elemType;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                U2Array.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

