/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.exceptions.AdjustmentException;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EllipticCurvesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EllipticCurvesExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.EllipticCurvesExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.EllipticCurvesExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EllipticCurvesExtensionHandler
extends ExtensionHandler<EllipticCurvesExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EllipticCurvesExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public void adjustTLSExtensionContext(EllipticCurvesExtensionMessage message) {
        byte[] groupBytes = (byte[])message.getSupportedGroups().getValue();
        if (groupBytes.length % 2 != 0) {
            throw new AdjustmentException("Could not create resonable NamedGroups from groupBytes");
        }
        LinkedList<NamedGroup> groupList = new LinkedList<NamedGroup>();
        for (int i = 0; i < groupBytes.length; i += 2) {
            byte[] group = Arrays.copyOfRange(groupBytes, i, i + 2);
            NamedGroup namedGroup = NamedGroup.getNamedGroup(group);
            if (namedGroup == null) {
                LOGGER.warn("Unknown EllipticCruve:" + ArrayConverter.bytesToHexString((byte[])group));
                continue;
            }
            groupList.add(namedGroup);
        }
        if (this.context.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.context.setClientNamedGroupsList(groupList);
        } else {
            this.context.setServerNamedGroupsList(groupList);
        }
    }

    @Override
    public EllipticCurvesExtensionParser getParser(byte[] message, int pointer) {
        return new EllipticCurvesExtensionParser(pointer, message);
    }

    public EllipticCurvesExtensionPreparator getPreparator(EllipticCurvesExtensionMessage message) {
        return new EllipticCurvesExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public EllipticCurvesExtensionSerializer getSerializer(EllipticCurvesExtensionMessage message) {
        return new EllipticCurvesExtensionSerializer(message);
    }
}

