/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server.process;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.jupyter.actions.CreateNotebookFactoryKt;
import com.intellij.kotlin.jupyter.core.jupyter.actions.NotebookMode;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.AbstractKotlinKernelRunnableHandler;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.DefaultKotlinKernelConfigFactory;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.KotlinKernelListener;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.ModeAwareKernelRunnableFactory;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.extensions.KernelProcessCommandLineCustomizer;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.extensions.KernelVmCommandCustomizer;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.process.KernelPortsProvider;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.process.KotlinKernelNotificationStartedEvent;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.process.KotlinKernelProcessListener;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.process.KotlinKernelProcessToolWindow;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.process.SeparateProcessKotlinKernelRunnableHandler;
import com.intellij.kotlin.jupyter.core.jupyter.toolwindow.KotlinNotebookToolWindowManager;
import com.intellij.kotlin.jupyter.core.resources.KotlinNotebookMavenArtifacts;
import com.intellij.kotlin.jupyter.core.resources.KotlinNotebookMavenArtifactsDownloader;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookProjectOptionsProvider;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunMode;
import com.intellij.kotlin.jupyter.core.settings.OptionsUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlinx.jupyter.api.ReplCompilerMode;
import org.jetbrains.kotlinx.jupyter.api.libraries.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.startup.ArgumentsKt;
import org.jetbrains.kotlinx.jupyter.startup.KernelConfig;
import org.jetbrains.kotlinx.jupyter.startup.PortsGeneratingKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0015\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0018H\u0007J\u0018\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fj\u0002`\"H\u0002R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelProcessFactory;", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/ModeAwareKernelRunnableFactory;", "<init>", "()V", "createKernelRunnableHandler", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/SeparateProcessKotlinKernelRunnableHandler;", "project", "Lcom/intellij/openapi/project/Project;", "kernelId", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterKernelId;", "notebookPath", "Ljava/nio/file/Path;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "replCompilerMode", "Lorg/jetbrains/kotlinx/jupyter/api/ReplCompilerMode;", "createKernelRunnableHandler-Po_4adE", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/nio/file/Path;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lorg/jetbrains/kotlinx/jupyter/api/ReplCompilerMode;)Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/SeparateProcessKotlinKernelRunnableHandler;", "getWorkingDir", "getJavaExecutable", "", "options", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookProjectOptionsProvider;", "_kernelPortsProvider", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelPortsProvider;", "kernelPortsProvider", "getKernelPortsProvider", "()Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelPortsProvider;", "setKernelPortsProvider", "", "getKernelPorts", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/JupyterSocketType;", "", "Lorg/jetbrains/kotlinx/jupyter/startup/KernelPorts;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKernelProcessFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelProcessFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelProcessFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,158:1\n1#2:159\n183#3,2:160\n*S KotlinDebug\n*F\n+ 1 KernelProcessFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelProcessFactory\n*L\n138#1:160,2\n*E\n"})
public final class KernelProcessFactory
extends ModeAwareKernelRunnableFactory {
    @NotNull
    private KernelPortsProvider _kernelPortsProvider = KernelProcessFactory::_kernelPortsProvider$lambda$9;

    public KernelProcessFactory() {
        super(KotlinNotebookSessionRunMode.SEPARATE_PROCESS);
    }

    @Override
    @RequiresBackgroundThread
    @NotNull
    protected SeparateProcessKotlinKernelRunnableHandler createKernelRunnableHandler-Po_4adE(@NotNull Project project, @NotNull String kernelId, @NotNull Path notebookPath, @Nullable BackedNotebookVirtualFile notebookVirtualFile, @NotNull ReplCompilerMode replCompilerMode2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kernelId, (String)"kernelId");
        Intrinsics.checkNotNullParameter((Object)notebookPath, (String)"notebookPath");
        Intrinsics.checkNotNullParameter((Object)replCompilerMode2, (String)"replCompilerMode");
        Map<JupyterSocketType, Integer> kernelPorts = this.getKernelPorts();
        KernelConfig kernelConfig = new DefaultKotlinKernelConfigFactory(project, kernelPorts, notebookPath, replCompilerMode2).create();
        KotlinNotebookProjectOptionsProvider options2 = KotlinNotebookProjectOptionsProvider.Companion.getInstance(project);
        String javaExecutable = this.getJavaExecutable(project, options2);
        Path workingDir = this.getWorkingDir(project, notebookPath);
        List $this$createKernelRunnableHandler_Po_4adE_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Path path = workingDir;
        if (path != null) {
            Path it = path;
            boolean bl2 = false;
            $this$createKernelRunnableHandler_Po_4adE_u24lambda_u241.add("-Duser.dir=" + PathsKt.getInvariantSeparatorsPathString((Path)workingDir) + "/");
        }
        $this$createKernelRunnableHandler_Po_4adE_u24lambda_u241.add("-Xmx" + options2.getHeapMaxLimitInMib() + "M");
        for (String extraArg : options2.getExtraJvmArguments()) {
            $this$createKernelRunnableHandler_Po_4adE_u24lambda_u241.add(extraArg);
        }
        KernelVmCommandCustomizer.Companion.addVmArguments($this$createKernelRunnableHandler_Po_4adE_u24lambda_u241);
        List extraJavaArgs = CollectionsKt.build((List)list);
        String classpathSeparator = File.pathSeparator;
        Iterable iterable = KotlinNotebookMavenArtifactsDownloader.Companion.getInstance(project).downloadArtifactBlocking(KotlinNotebookMavenArtifacts.INSTANCE.getKERNEL_SHADOWED(), OptionsUtilKt.getSelectedKernelVersionAsString(project));
        Intrinsics.checkNotNull((Object)classpathSeparator);
        List cmdArgs = ArgumentsKt.javaCmdLine((KernelConfig)kernelConfig, (String)javaExecutable, (String)"kernelProcessConnection", (String)CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)classpathSeparator, null, null, (int)0, null, KernelProcessFactory::createKernelRunnableHandler_Po_4adE$lambda$2, (int)30, null), (Collection)extraJavaArgs);
        Object object = new GeneralCommandLine(cmdArgs);
        GeneralCommandLine $this$createKernelRunnableHandler_Po_4adE_u24lambda_u244 = object;
        boolean bl3 = false;
        Path path2 = workingDir;
        if (path2 != null) {
            Path it = path2;
            boolean bl4 = false;
            $this$createKernelRunnableHandler_Po_4adE_u24lambda_u244.withWorkDirectory(it.toFile());
        }
        $this$createKernelRunnableHandler_Po_4adE_u24lambda_u244.withEnvironment(options2.getExtraEnvironmentVariables());
        KernelProcessCommandLineCustomizer.Companion.customize($this$createKernelRunnableHandler_Po_4adE_u24lambda_u244);
        GeneralCommandLine commandLine = object;
        Object $this$createKernelRunnableHandler_Po_4adE_u24lambda_u245 = object = new SeparateProcessKotlinKernelRunnableHandler(project, kernelId, commandLine, kernelConfig, notebookPath, notebookVirtualFile, null);
        boolean bl5 = false;
        ((AbstractKotlinKernelRunnableHandler)$this$createKernelRunnableHandler_Po_4adE_u24lambda_u245).addKernelListener((KotlinKernelListener)new KotlinKernelProcessListener(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void beforeNotificationStarted(KotlinKernelNotificationStartedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                KotlinNotebookToolWindowManager.Companion.getInstance(this.$project).showKotlinNotebookServerManagementToolWindow(new KotlinKernelProcessToolWindow(event.getSource()));
            }
        });
        ((SeparateProcessKotlinKernelRunnableHandler)$this$createKernelRunnableHandler_Po_4adE_u24lambda_u245).getProcess().startNotify();
        return object;
    }

    private final Path getWorkingDir(Project project, Path notebookPath) {
        Path path;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager fileManager = virtualFileManager;
        VirtualFile virtualFile = fileManager.findFileByNioPath(notebookPath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile notebookFile = virtualFile;
        Object object = BackedNotebookVirtualFile.Companion.takeIfBacked(notebookFile);
        if (object == null || (object = CreateNotebookFactoryKt.getMode((BackedNotebookVirtualFile)object)) == null) {
            return null;
        }
        Object mode = object;
        Path path2 = notebookPath.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Path it = path = path2.getParent();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Path notebookParentDir = Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
        return switch (WhenMappings.$EnumSwitchMapping$0[((Enum)mode).ordinal()]) {
            case 1 -> notebookParentDir;
            case 2 -> {
                Path var9_9;
                try {
                    VirtualFile v6 = ProjectUtil.guessProjectDir((Project)project);
                    var9_9 = v6 != null ? v6.toNioPath() : null;
                }
                catch (Exception <unused var>) {
                    var9_9 = notebookParentDir;
                }
                yield var9_9;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final String getJavaExecutable(Project project, KotlinNotebookProjectOptionsProvider options2) {
        File javaExecutable;
        Object object;
        Object v1;
        block3: {
            void $this$firstOrNull$iv;
            String javaHome = options2.getJdk().getPath(project);
            if (javaHome == null) {
                return "java";
            }
            File file = new File(javaHome).getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAbsoluteFile(...)");
            File binDir = FilesKt.resolve((File)file, (String)"bin");
            String[] stringArray = new String[]{"java.exe", "java"};
            stringArray = SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])stringArray), arg_0 -> KernelProcessFactory.getJavaExecutable$lambda$7(binDir, arg_0));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File executable = (File)element$iv;
                boolean bl = false;
                if (!executable.exists()) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        if ((object = (javaExecutable = (File)v1)) == null || (object = ((File)object).getAbsolutePath()) == null) {
            object = "java";
        }
        return object;
    }

    @NotNull
    public final KernelPortsProvider getKernelPortsProvider() {
        return this._kernelPortsProvider;
    }

    @TestOnly
    public final void setKernelPortsProvider(@NotNull KernelPortsProvider kernelPortsProvider) {
        Intrinsics.checkNotNullParameter((Object)kernelPortsProvider, (String)"kernelPortsProvider");
        this._kernelPortsProvider = kernelPortsProvider;
    }

    private final Map<JupyterSocketType, Integer> getKernelPorts() {
        return this._kernelPortsProvider.getKernelPorts();
    }

    private static final CharSequence createKernelRunnableHandler_Po_4adE$lambda$2(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    private static final File getJavaExecutable$lambda$7(File $binDir, String executableName) {
        Intrinsics.checkNotNullParameter((Object)executableName, (String)"executableName");
        return FilesKt.resolve((File)$binDir, (String)executableName);
    }

    private static final Map _kernelPortsProvider$lambda$9() {
        return PortsGeneratingKt.createRandomKernelPorts();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookMode.values().length];
            try {
                nArray[NotebookMode.STANDARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookMode.LIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

