/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.util;

import com.intellij.kotlin.jupyter.core.util.CursorProvider;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/kotlin/jupyter/core/util/RetargetingCursorProvider;", "Lcom/intellij/kotlin/jupyter/core/util/CursorProvider;", "component", "Ljava/awt/Component;", "boundsSource", "<init>", "(Ljava/awt/Component;Ljava/awt/Component;)V", "provideCursor", "Ljava/awt/Cursor;", "x", "", "y", "Factory", "intellij.kotlin.jupyter.core"})
public final class RetargetingCursorProvider
extends CursorProvider {
    @NotNull
    private final Component boundsSource;

    public RetargetingCursorProvider(@NotNull Component component, @NotNull Component boundsSource) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)boundsSource, (String)"boundsSource");
        super(component);
        this.boundsSource = boundsSource;
    }

    @Override
    @Nullable
    public Cursor provideCursor(int x, int y) {
        Point pointWithinSource = SwingUtilities.convertPoint(this.getComponent(), x, y, this.boundsSource);
        Component component = SwingUtilities.getDeepestComponentAt(this.boundsSource, pointWithinSource.x, pointWithinSource.y);
        if (component == null) {
            return null;
        }
        Component cursorSource = component;
        return cursorSource.getCursor();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/kotlin/jupyter/core/util/RetargetingCursorProvider$Factory;", "Lcom/intellij/kotlin/jupyter/core/util/CursorProvider$Factory;", "boundsSource", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "create", "Lcom/intellij/kotlin/jupyter/core/util/CursorProvider;", "component", "intellij.kotlin.jupyter.core"})
    public static final class Factory
    implements CursorProvider.Factory {
        @NotNull
        private final Component boundsSource;

        public Factory(@NotNull Component boundsSource) {
            Intrinsics.checkNotNullParameter((Object)boundsSource, (String)"boundsSource");
            this.boundsSource = boundsSource;
        }

        @Override
        @NotNull
        public CursorProvider create(@NotNull Component component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            return new RetargetingCursorProvider(component, this.boundsSource);
        }
    }
}

