/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class DoWhileConditionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            DoWhileConditionFixer.$$$reportNull$$$0(0);
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_DO_WHILE_STATEMENT)) {
            Document doc = editor.getDocument();
            ASTNode whileKeyword = BasicJavaAstTreeUtil.getWhileKeyword(astNode);
            ASTNode doWhileBody = BasicJavaAstTreeUtil.getDoWhileBody(astNode);
            if (doWhileBody == null || !BasicJavaAstTreeUtil.is(doWhileBody, BasicJavaElementType.BASIC_BLOCK_STATEMENT) && whileKeyword == null) {
                int startOffset = astNode.getTextRange().getStartOffset();
                doc.replaceString(startOffset, startOffset + "do".length(), (CharSequence)"do {} while()");
                return;
            }
            if (BasicJavaAstTreeUtil.getWhileCondition(astNode) == null) {
                if (whileKeyword == null) {
                    int endOffset = astNode.getTextRange().getEndOffset();
                    doc.insertString(endOffset, (CharSequence)"while()");
                } else if (BasicJavaAstTreeUtil.getLParenth(astNode) == null || BasicJavaAstTreeUtil.getRParenth(astNode) == null) {
                    TextRange whileRange = whileKeyword.getTextRange();
                    doc.replaceString(whileRange.getStartOffset(), whileRange.getEndOffset(), (CharSequence)"while()");
                } else {
                    ASTNode lParenth = BasicJavaAstTreeUtil.getLParenth(astNode);
                    if (lParenth != null) {
                        processor.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                    }
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/codeInsight/editorActions/smartEnter/DoWhileConditionFixer", "apply"));
    }
}

