/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLAttribute;

public final class XMLElement
implements IXMLElement,
Serializable {
    public static final int NO_LINE = -1;
    private static final long serialVersionUID = -2383376380548624920L;
    private final List<XMLAttribute> attributes = new ArrayList<XMLAttribute>();
    private final List<IXMLElement> children = new ArrayList<IXMLElement>(8);
    private final String systemID;
    private final int lineNr;
    private IXMLElement parent;
    private String name;
    private String fullName;
    private String namespace;
    private String content;

    public XMLElement() {
        this(null, null, null, -1);
    }

    public XMLElement(String fullName) {
        this(fullName, null, null, -1);
    }

    public XMLElement(String fullName, String systemID, int lineNr) {
        this(fullName, null, systemID, lineNr);
    }

    public XMLElement(String fullName, String namespace) {
        this(fullName, namespace, null, -1);
    }

    public XMLElement(String fullName, String namespace, String systemID, int lineNr) {
        int index;
        this.fullName = fullName;
        this.name = namespace == null ? fullName : ((index = fullName.indexOf(58)) >= 0 ? fullName.substring(index + 1) : fullName);
        this.namespace = namespace;
        this.content = null;
        this.lineNr = lineNr;
        this.systemID = systemID;
        this.parent = null;
    }

    @Override
    public IXMLElement createElement(String fullName) {
        return new XMLElement(fullName);
    }

    @Override
    public IXMLElement createElement(String fullName, String systemID, int lineNr) {
        return new XMLElement(fullName, systemID, lineNr);
    }

    @Override
    public IXMLElement createElement(String fullName, String namespace) {
        return new XMLElement(fullName, namespace);
    }

    @Override
    public IXMLElement createElement(String fullName, String namespace, String systemID, int lineNr) {
        return new XMLElement(fullName, namespace, systemID, lineNr);
    }

    @Override
    public IXMLElement getParent() {
        return this.parent;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.fullName = name;
        this.namespace = null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setName(String fullName, String namespace) {
        int index = fullName.indexOf(58);
        this.name = namespace == null || index < 0 ? fullName : fullName.substring(index + 1);
        this.fullName = fullName;
        this.namespace = namespace;
    }

    @Override
    public void addChild(IXMLElement child) {
        IXMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getName() == null && !this.children.isEmpty() && (lastChild = this.children.get(this.children.size() - 1)).getName() == null) {
            lastChild.setContent(lastChild.getContent() + child.getContent());
            return;
        }
        ((XMLElement)child).parent = this;
        this.children.add(child);
    }

    public void insertChild(IXMLElement child, int index) {
        IXMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getName() == null && !this.children.isEmpty() && (lastChild = this.children.get(this.children.size() - 1)).getName() == null) {
            lastChild.setContent(lastChild.getContent() + child.getContent());
            return;
        }
        ((XMLElement)child).parent = this;
        this.children.add(index, child);
    }

    @Override
    public void removeChild(IXMLElement child) {
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        this.children.remove(child);
    }

    @Override
    public void removeChildAtIndex(int index) {
        this.children.remove(index);
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public int getChildrenCount() {
        return this.children.size();
    }

    @Override
    public List<IXMLElement> getChildren() {
        return this.children;
    }

    @Override
    public IXMLElement getChildAtIndex(int index) throws ArrayIndexOutOfBoundsException {
        return this.children.get(index);
    }

    private XMLAttribute findAttribute(String fullName) {
        for (XMLAttribute attr : this.attributes) {
            if (!attr.getFullName().equals(fullName)) continue;
            return attr;
        }
        return null;
    }

    private XMLAttribute findAttribute(String name, String namespace) {
        for (XMLAttribute attr : this.attributes) {
            boolean found = attr.getName().equals(name);
            found = namespace == null ? (found &= attr.getNamespace() == null) : (found &= namespace.equals(attr.getNamespace()));
            if (!found) continue;
            return attr;
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.size();
    }

    @Override
    @Deprecated
    public String getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public String getAttribute(String name, String defaultValue) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    @Override
    public String getAttribute(String name, String namespace, String defaultValue) {
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    @Override
    public int getAttribute(String name, int defaultValue) {
        String value = this.getAttribute(name, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    @Override
    public int getAttribute(String name, String namespace, int defaultValue) {
        String value = this.getAttribute(name, namespace, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    @Override
    public String getAttributeType(String name) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getType();
    }

    @Override
    public String getAttributeType(String name, String namespace) {
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            return null;
        }
        return attr.getType();
    }

    @Override
    public void setAttribute(String name, String value) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            attr = new XMLAttribute(name, name, null, value, "CDATA");
            this.attributes.add(attr);
        } else {
            attr.setValue(value);
        }
    }

    @Override
    public void setAttribute(String fullName, String namespace, String value) {
        int index = fullName.indexOf(58);
        String name = fullName.substring(index + 1);
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            attr = new XMLAttribute(fullName, name, namespace, value, "CDATA");
            this.attributes.add(attr);
        } else {
            attr.setValue(value);
        }
    }

    @Override
    public void removeAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute attr = this.attributes.get(i);
            if (!attr.getFullName().equals(name)) continue;
            this.attributes.remove(i);
            return;
        }
    }

    @Override
    public void removeAttribute(String name, String namespace) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute attr = this.attributes.get(i);
            boolean found = attr.getName().equals(name);
            found = namespace == null ? (found &= attr.getNamespace() == null) : (found &= attr.getNamespace().equals(namespace));
            if (!found) continue;
            this.attributes.remove(i);
            return;
        }
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.findAttribute(name) != null;
    }

    @Override
    public boolean hasAttribute(String name, String namespace) {
        return this.findAttribute(name, namespace) != null;
    }

    @Override
    public Properties getAttributes() {
        Properties result = new Properties();
        for (XMLAttribute attr : this.attributes) {
            result.setProperty(attr.getFullName(), attr.getValue());
        }
        return result;
    }

    @Override
    public String getSystemID() {
        return this.systemID;
    }

    @Override
    public int getLineNr() {
        return this.lineNr;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public boolean equals(Object rawElement) {
        try {
            return this.equalsXMLElement((IXMLElement)rawElement);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean equalsXMLElement(IXMLElement elt) {
        if (!this.name.equals(elt.getName())) {
            return false;
        }
        if (this.attributes.size() != elt.getAttributeCount()) {
            return false;
        }
        for (XMLAttribute attr : this.attributes) {
            if (!elt.hasAttribute(attr.getName(), attr.getNamespace())) {
                return false;
            }
            String value = elt.getAttribute(attr.getName(), attr.getNamespace(), null);
            if (!attr.getValue().equals(value)) {
                return false;
            }
            String type = elt.getAttributeType(attr.getName(), attr.getNamespace());
            if (attr.getType().equals(type)) continue;
            return false;
        }
        if (this.children.size() != elt.getChildrenCount()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            IXMLElement child2;
            IXMLElement child1 = this.getChildAtIndex(i);
            if (child1.equalsXMLElement(child2 = elt.getChildAtIndex(i))) continue;
            return false;
        }
        return true;
    }
}

