/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.parameterized.BlockJUnit4ClassRunnerWithParametersFactory;
import org.junit.runners.parameterized.ParametersRunnerFactory;

public class Parameterized
extends org.junit.runners.Parameterized {
    private List<Runner> l;

    public Parameterized(Class<?> klass) throws Throwable {
        super(klass);
        FrameworkMethod parametersMethod = this.getParametersMethod();
        if (parametersMethod != null) {
            Parameters parameters = (Parameters)parametersMethod.getAnnotation(Parameters.class);
            Class<?> runnersFactory = Class.forName("org.junit.runners.Parameterized$RunnersFactory");
            Constructor<?> constructorRunnersFactory = runnersFactory.getDeclaredConstructor(Class.class);
            constructorRunnersFactory.setAccessible(true);
            Object runnersFactoryObj = constructorRunnersFactory.newInstance(klass);
            Method declaredMethod = runnersFactory.getDeclaredMethod("createRunnersForParameters", Iterable.class, String.class, ParametersRunnerFactory.class);
            declaredMethod.setAccessible(true);
            this.l = (List)declaredMethod.invoke(runnersFactoryObj, Parameterized.allParameters(klass, parametersMethod), parameters.name(), BlockJUnit4ClassRunnerWithParametersFactory.class.newInstance());
        }
    }

    protected List<Runner> getChildren() {
        return this.l;
    }

    private FrameworkMethod getParametersMethod() throws Exception {
        List methods = this.getTestClass().getAnnotatedMethods(Parameters.class);
        for (FrameworkMethod each : methods) {
            if (!each.isStatic() || !each.isPublic()) continue;
            return each;
        }
        return null;
    }

    private static Iterable<Object[]> allParameters(Class<?> klass, FrameworkMethod parametersMethod) throws Throwable {
        Object parameters = parametersMethod.invokeExplosively(null, new Object[]{klass});
        if (parameters instanceof Iterable) {
            return (Iterable)parameters;
        }
        throw new IllegalArgumentException("Wrong return type");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameters {
        public String name() default "{index}";
    }
}

