/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.inline.completion.logs.CharCategory;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.completion.ml.common.ContextSimilarityUtil;
import com.intellij.completion.ml.common.CurrentProjectInfo;
import com.intellij.completion.ml.common.LocationFeaturesUtil;
import com.intellij.completion.ml.ngram.NGram;
import com.intellij.completion.ml.util.LookupExtensionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\t\u001a\u00020\nH\u0002J0\u0010\u000e\u001a\u00020\f*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\f0\u0005\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0017*\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\f*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001e\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010 \u001a\u00020\u0019*\u00020\u00192\b\b\u0002\u0010!\u001a\u00020\u0019H\u0002J(\u0010\"\u001a\u00020\f*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0011\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0019H\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u001fH\u0002\u00a8\u0006&"}, d2={"Lcom/intellij/completion/ml/common/CommonLocationFeatures;", "Lcom/intellij/codeInsight/completion/ml/ContextFeatureProvider;", "<init>", "()V", "getName", "", "calculateFeatures", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "environment", "Lcom/intellij/codeInsight/completion/ml/CompletionEnvironment;", "addTextFeatures", "", "", "captureNearestNonEmptyLineInfo", "document", "Lcom/intellij/openapi/editor/Document;", "position", "Lcom/intellij/openapi/editor/LogicalPosition;", "previous", "", "getLineText", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "line", "", "addProjectFeatures", "project", "Lcom/intellij/openapi/project/Project;", "putNGramScorers", "putContextSimilarityScorers", "Lcom/intellij/psi/PsiElement;", "roundDown", "base", "addPsiParents", "numParents", "isAfterDot", "CaseSensitivity", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nCommonLocationFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonLocationFeatures.kt\ncom/intellij/completion/ml/common/CommonLocationFeatures\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,165:1\n1#2:166\n127#3,2:167\n*S KotlinDebug\n*F\n+ 1 CommonLocationFeatures.kt\ncom/intellij/completion/ml/common/CommonLocationFeatures\n*L\n133#1:167,2\n*E\n"})
final class CommonLocationFeatures
implements ContextFeatureProvider {
    @NotNull
    public String getName() {
        return "common";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull CompletionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Map result = new LinkedHashMap();
        this.putNGramScorers(environment);
        this.addTextFeatures(result, environment);
        Project project = environment.getLookup().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (DumbService.Companion.isDumb(project2)) {
            result.put("dumb_mode", MLFeatureValue.Companion.binary(true));
        }
        this.addProjectFeatures(result, project2);
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)codeInsightSettings, (String)"getInstance(...)");
        CaseSensitivity caseSensitive = CaseSensitivity.Companion.fromSettings(codeInsightSettings);
        if (caseSensitive != CaseSensitivity.NONE) {
            result.put("case_sensitivity", MLFeatureValue.Companion.categorical((Enum)caseSensitive));
        }
        PsiElement psiElement = environment.getParameters().getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        result.put("is_after_dot", MLFeatureValue.Companion.binary(this.isAfterDot(position)));
        this.addPsiParents(result, position, 10);
        return result;
    }

    private final void addTextFeatures(Map<String, MLFeatureValue> $this$addTextFeatures, CompletionEnvironment environment) {
        block5: {
            CharCategory it;
            int n;
            Lookup lookup = environment.getLookup();
            Intrinsics.checkNotNullExpressionValue((Object)lookup, (String)"getLookup(...)");
            Lookup lookup2 = lookup;
            Editor editor = lookup2.getTopLevelEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getTopLevelEditor(...)");
            Editor editor2 = editor;
            try {
                n = lookup2.getLookupStart();
            }
            catch (AssertionError assertionError) {
                return;
            }
            int caretOffset = n;
            LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(caretOffset);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
            LogicalPosition logicalPosition2 = logicalPosition;
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int lineStartOffset = document2.getLineStartOffset(logicalPosition2.line);
            int lineEndOffset = document2.getLineEndOffset(logicalPosition2.line);
            PsiElement psiElement = environment.getParameters().getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
            PsiElement position = psiElement;
            int prefixLength = LookupExtensionsKt.prefix(lookup2).length();
            String string = document2.getText(new TextRange(lineStartOffset, caretOffset));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String linePrefix = string;
            String string2 = document2.getText(new TextRange(caretOffset, lineEndOffset));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String lineSuffix = string2;
            int textLength = document2.getTextLength();
            int prefixToDrop = prefixLength > 0 ? prefixLength : 0;
            this.putContextSimilarityScorers(StringsKt.dropLast((String)linePrefix, (int)prefixToDrop), position, environment);
            $this$addTextFeatures.put("line_num", MLFeatureValue.Companion.float(logicalPosition2.line));
            $this$addTextFeatures.put("col_num", MLFeatureValue.Companion.float(logicalPosition2.column));
            $this$addTextFeatures.put("indent_level", MLFeatureValue.Companion.float(LocationFeaturesUtil.INSTANCE.indentLevel(linePrefix, EditorUtil.getTabSize((Editor)editor2))));
            $this$addTextFeatures.put("is_in_line_beginning", MLFeatureValue.Companion.binary(StringsKt.isBlank((CharSequence)linePrefix)));
            $this$addTextFeatures.put("is_in_line_end", MLFeatureValue.Companion.binary(StringsKt.isBlank((CharSequence)lineSuffix)));
            $this$addTextFeatures.put("prefix_length", MLFeatureValue.Companion.float(prefixLength));
            this.captureNearestNonEmptyLineInfo($this$addTextFeatures, document2, logicalPosition2, true);
            this.captureNearestNonEmptyLineInfo($this$addTextFeatures, document2, logicalPosition2, false);
            $this$addTextFeatures.put("offset", MLFeatureValue.Companion.float(caretOffset));
            $this$addTextFeatures.put("text_length", MLFeatureValue.Companion.float(textLength));
            $this$addTextFeatures.put("offset_text_length_ratio", MLFeatureValue.Companion.float(textLength == 0 ? 0.0 : (double)caretOffset / (double)textLength));
            if (!StringsKt.isBlank((CharSequence)linePrefix)) {
                $this$addTextFeatures.put("is_whitespace_before_caret", MLFeatureValue.Companion.binary(CharsKt.isWhitespace((char)StringsKt.last((CharSequence)linePrefix))));
                String trimmedPrefix = ((Object)StringsKt.trim((CharSequence)linePrefix)).toString();
                $this$addTextFeatures.put("symbols_in_line_before_caret", MLFeatureValue.Companion.float(trimmedPrefix.length()));
                CharCategory charCategory = CharCategory.Companion.find(StringsKt.last((CharSequence)trimmedPrefix));
                if (charCategory != null) {
                    it = charCategory;
                    boolean bl = false;
                    $this$addTextFeatures.put("non_space_symbol_before_caret", MLFeatureValue.Companion.categorical((Enum)it));
                }
            }
            if (!(!StringsKt.isBlank((CharSequence)lineSuffix))) break block5;
            $this$addTextFeatures.put("is_whitespace_after_caret", MLFeatureValue.Companion.binary(CharsKt.isWhitespace((char)StringsKt.first((CharSequence)lineSuffix))));
            String trimmedSuffix = ((Object)StringsKt.trim((CharSequence)lineSuffix)).toString();
            $this$addTextFeatures.put("symbols_in_line_after_caret", MLFeatureValue.Companion.float(trimmedSuffix.length()));
            CharCategory charCategory = CharCategory.Companion.find(StringsKt.first((CharSequence)trimmedSuffix));
            if (charCategory != null) {
                it = charCategory;
                boolean bl = false;
                $this$addTextFeatures.put("non_space_symbol_after_caret", MLFeatureValue.Companion.categorical((Enum)it));
            }
        }
    }

    private final void captureNearestNonEmptyLineInfo(Map<String, MLFeatureValue> $this$captureNearestNonEmptyLineInfo, Document document, LogicalPosition position, boolean previous) {
        block1: {
            int lineNumber;
            Pair pair = previous ? TuplesKt.to((Object)"previous", (Object)-1) : TuplesKt.to((Object)"following", (Object)1);
            String name = (String)pair.component1();
            int delta = ((Number)pair.component2()).intValue();
            int startLineNumber = position.line;
            String text = null;
            for (lineNumber = startLineNumber + delta; lineNumber >= 0 && lineNumber < document.getLineCount(); lineNumber += delta) {
                String string;
                String it = string = this.getLineText(document, lineNumber);
                boolean bl = false;
                text = it;
                if (!StringsKt.isBlank((CharSequence)string)) break;
            }
            $this$captureNearestNonEmptyLineInfo.put(name + "_empty_lines_count", MLFeatureValue.Companion.float(Math.abs(lineNumber - startLineNumber) - 1));
            String string = text;
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            $this$captureNearestNonEmptyLineInfo.put(name + "_non_empty_line_length", MLFeatureValue.Companion.float(it.length()));
        }
    }

    private final String getLineText(Document $this$getLineText, int line) {
        String string = $this$getLineText.getText(new TextRange($this$getLineText.getLineStartOffset(line), $this$getLineText.getLineEndOffset(line)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private final void addProjectFeatures(Map<String, MLFeatureValue> $this$addProjectFeatures, Project project) {
        CurrentProjectInfo projectInfo = CurrentProjectInfo.Companion.getInstance(project);
        if (projectInfo.isIdeaProject()) {
            $this$addProjectFeatures.put("is_idea_project", MLFeatureValue.Companion.binary(true));
        }
        $this$addProjectFeatures.put("modules_count", MLFeatureValue.Companion.numerical(CommonLocationFeatures.roundDown$default(this, projectInfo.getModulesCount(), 0, 1, null)));
        $this$addProjectFeatures.put("libraries_count", MLFeatureValue.Companion.numerical(CommonLocationFeatures.roundDown$default(this, projectInfo.getLibrariesCount(), 0, 1, null)));
        $this$addProjectFeatures.put("files_count", MLFeatureValue.Companion.numerical(CommonLocationFeatures.roundDown$default(this, projectInfo.getFilesCount(), 0, 1, null)));
    }

    private final void putNGramScorers(CompletionEnvironment environment) {
        CompletionParameters completionParameters = environment.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)completionParameters, (String)"getParameters(...)");
        for (Map.Entry<Key<NGram.Scorer>, NGram.Scorer> entry : NGram.INSTANCE.getScorers$intellij_completionMlRanking(completionParameters, 4).entrySet()) {
            Key<NGram.Scorer> key = entry.getKey();
            NGram.Scorer scorer = entry.getValue();
            environment.putUserData(key, (Object)scorer);
        }
    }

    private final void putContextSimilarityScorers(String line, PsiElement position, CompletionEnvironment environment) {
        environment.putUserData(ContextSimilarityUtil.INSTANCE.getLINE_SIMILARITY_SCORER_KEY(), (Object)ContextSimilarityUtil.INSTANCE.createLineSimilarityScorer(line));
        environment.putUserData(ContextSimilarityUtil.INSTANCE.getPARENT_SIMILARITY_SCORER_KEY(), (Object)ContextSimilarityUtil.INSTANCE.createParentSimilarityScorer(position));
    }

    private final int roundDown(int $this$roundDown, int base) {
        Object element$iv2;
        block1: {
            Sequence $this$first$iv = SequencesKt.generateSequence((Object)1, arg_0 -> CommonLocationFeatures.roundDown$lambda$4(base, arg_0));
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                int it = ((Number)element$iv2).intValue();
                boolean bl = false;
                if (!(it * base > $this$roundDown)) continue;
                break block1;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return ((Number)element$iv2).intValue();
    }

    static /* synthetic */ int roundDown$default(CommonLocationFeatures commonLocationFeatures, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 10;
        }
        return commonLocationFeatures.roundDown(n, n2);
    }

    private final void addPsiParents(Map<String, MLFeatureValue> $this$addPsiParents, PsiElement position, int numParents) {
        PsiElement psiElement = position.getParent();
        if (psiElement == null) {
            return;
        }
        PsiElement curParent = psiElement;
        int i = 1;
        if (i <= numParents) {
            while (true) {
                if (curParent.getParent() == null) {
                    return;
                }
                String parentName = "parent_" + i;
                $this$addPsiParents.put(parentName, MLFeatureValue.Companion.className$default((MLFeatureValue.Companion)MLFeatureValue.Companion, curParent.getClass(), (boolean)false, (int)2, null));
                if (curParent instanceof PsiFileSystemItem) {
                    return;
                }
                if (i == numParents) break;
                ++i;
            }
        }
    }

    private final boolean isAfterDot(PsiElement position) {
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        return prev != null && Intrinsics.areEqual((Object)prev.getText(), (Object)".");
    }

    private static final Integer roundDown$lambda$4(int $base, int it) {
        return it * $base;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/ml/common/CommonLocationFeatures$CaseSensitivity;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "ALL", "FIRST_LETTER", "Companion", "intellij.completionMlRanking"})
    private static final class CaseSensitivity
    extends Enum<CaseSensitivity> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ CaseSensitivity NONE;
        public static final /* enum */ CaseSensitivity ALL;
        public static final /* enum */ CaseSensitivity FIRST_LETTER;
        private static final /* synthetic */ CaseSensitivity[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CaseSensitivity[] values() {
            return (CaseSensitivity[])$VALUES.clone();
        }

        public static CaseSensitivity valueOf(String value) {
            return Enum.valueOf(CaseSensitivity.class, value);
        }

        @NotNull
        public static EnumEntries<CaseSensitivity> getEntries() {
            return $ENTRIES;
        }

        static {
            NONE = new CaseSensitivity();
            ALL = new CaseSensitivity();
            FIRST_LETTER = new CaseSensitivity();
            $VALUES = caseSensitivityArray = new CaseSensitivity[]{CaseSensitivity.NONE, CaseSensitivity.ALL, CaseSensitivity.FIRST_LETTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/ml/common/CommonLocationFeatures$CaseSensitivity$Companion;", "", "<init>", "()V", "fromSettings", "Lcom/intellij/completion/ml/common/CommonLocationFeatures$CaseSensitivity;", "settings", "Lcom/intellij/codeInsight/CodeInsightSettings;", "intellij.completionMlRanking"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CaseSensitivity fromSettings(@NotNull CodeInsightSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                return switch (settings.getCompletionCaseSensitive()) {
                    case 1 -> ALL;
                    case 3 -> FIRST_LETTER;
                    default -> NONE;
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

