/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.version;

public class JavaVMVersionToolkit {
    public static String decodeJavaVersion(String vmVersion) {
        String specVersion = vmVersion;
        if (vmVersion.startsWith("R") || vmVersion.startsWith("P") || vmVersion.startsWith("DEBUG-")) {
            specVersion = vmVersion.startsWith("DEBUG-") ? vmVersion.split("-")[4] : vmVersion.split("-")[3];
        }
        return JavaVMVersionToolkit.parseJavaVersion(specVersion);
    }

    public static String parseJavaVersion(String version) {
        int onePointIndex = version.indexOf("1.");
        if (onePointIndex >= 0) {
            int nextPointIndex = version.indexOf(46, onePointIndex + 2);
            if (nextPointIndex >= 0 && JavaVMVersionToolkit.isNumber(version.substring(onePointIndex + 2, nextPointIndex))) {
                return version.substring(onePointIndex, nextPointIndex);
            }
            return version.substring(onePointIndex);
        }
        return null;
    }

    private static boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isJRockitJVMName(String vmName) {
        if (vmName == null) {
            return false;
        }
        return vmName.startsWith("BEA JRockit") || vmName.startsWith("Oracle JRockit");
    }

    public static boolean isHotspotJVMName(String vmName) {
        if (vmName == null) {
            return false;
        }
        return vmName.startsWith("Java HotSpot") || JavaVMVersionToolkit.isOpenJDKJVMName(vmName) || vmName.startsWith("SAP");
    }

    public static boolean isOpenJDKJVMName(String vmName) {
        if (vmName == null) {
            return false;
        }
        return vmName.startsWith("OpenJDK");
    }
}

