/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.scanning;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationStore;
import org.jboss.resteasy.reactive.server.Cancellable;
import org.jboss.resteasy.reactive.server.handlers.CompletionStageResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.PublisherResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.UniResponseHandler;
import org.jboss.resteasy.reactive.server.model.FixedHandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class AsyncReturnTypeScanner
implements MethodScanner {
    private static final DotName CANCELLABLE = DotName.createSimple((String)Cancellable.class.getName());

    @Override
    public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
        DotName returnTypeName = method.returnType().name();
        AnnotationStore annotationStore = (AnnotationStore)methodContext.get("ANNOTATION_STORE");
        boolean isCancelable = this.determineCancelable(method, actualEndpointClass, annotationStore);
        if (returnTypeName.equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) || returnTypeName.equals((Object)ResteasyReactiveDotNames.COMPLETABLE_FUTURE)) {
            CompletionStageResponseHandler handler = new CompletionStageResponseHandler();
            handler.setCancellable(isCancelable);
            return Collections.singletonList(new FixedHandlerChainCustomizer((ServerRestHandler)handler, HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE));
        }
        if (returnTypeName.equals((Object)ResteasyReactiveDotNames.UNI)) {
            UniResponseHandler handler = new UniResponseHandler();
            handler.setCancellable(isCancelable);
            return Collections.singletonList(new FixedHandlerChainCustomizer((ServerRestHandler)handler, HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE));
        }
        if (returnTypeName.equals((Object)ResteasyReactiveDotNames.MULTI) || returnTypeName.equals((Object)ResteasyReactiveDotNames.REST_MULTI) || returnTypeName.equals((Object)ResteasyReactiveDotNames.PUBLISHER) || returnTypeName.equals((Object)ResteasyReactiveDotNames.LEGACY_PUBLISHER)) {
            return Collections.singletonList(new FixedHandlerChainCustomizer((ServerRestHandler)new PublisherResponseHandler(), HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE));
        }
        return Collections.emptyList();
    }

    private boolean determineCancelable(MethodInfo method, ClassInfo clazz, AnnotationStore annotationStore) {
        AnnotationValue value;
        AnnotationInstance instance = annotationStore.getAnnotation((AnnotationTarget)method, CANCELLABLE);
        if (instance == null && (instance = annotationStore.getAnnotation((AnnotationTarget)method.declaringClass(), CANCELLABLE)) == null && !clazz.equals(method.declaringClass())) {
            instance = annotationStore.getAnnotation((AnnotationTarget)clazz, CANCELLABLE);
        }
        if (instance != null && (value = instance.value()) != null) {
            return value.asBoolean();
        }
        return true;
    }

    @Override
    public boolean isMethodSignatureAsync(MethodInfo method) {
        DotName returnTypeName = method.returnType().name();
        return returnTypeName.equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) || returnTypeName.equals((Object)ResteasyReactiveDotNames.COMPLETABLE_FUTURE) || returnTypeName.equals((Object)ResteasyReactiveDotNames.UNI) || returnTypeName.equals((Object)ResteasyReactiveDotNames.MULTI) || returnTypeName.equals((Object)ResteasyReactiveDotNames.REST_MULTI) || returnTypeName.equals((Object)ResteasyReactiveDotNames.PUBLISHER) || returnTypeName.equals((Object)ResteasyReactiveDotNames.LEGACY_PUBLISHER);
    }
}

