/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;
import org.keycloak.storage.ReadOnlyException;

@Extension(name="x-smallrye-profile-admin", value="")
public class ClientRoleMappingsResource {
    protected static final Logger logger = Logger.getLogger(ClientRoleMappingsResource.class);
    protected KeycloakSession session;
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected RoleMapperModel user;
    protected ClientModel client;
    protected AdminEventBuilder adminEvent;
    private UriInfo uriInfo;
    protected AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected AdminPermissionEvaluator.RequirePermissionCheck viewPermission;

    public ClientRoleMappingsResource(UriInfo uriInfo, KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth, RoleMapperModel user, ClientModel client, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck manageCheck, AdminPermissionEvaluator.RequirePermissionCheck viewCheck) {
        this.uriInfo = uriInfo;
        this.session = session;
        this.realm = realm;
        this.auth = auth;
        this.user = user;
        this.client = client;
        this.managePermission = manageCheck;
        this.viewPermission = viewCheck;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_ROLE_MAPPING);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Client Role Mappings")
    @Operation(summary="Get client-level role mappings for the user or group, and the app")
    public Stream<RoleRepresentation> getClientRoleMappings() {
        this.viewPermission.require();
        return this.user.getClientRoleMappingsStream(this.client).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Client Role Mappings")
    @Operation(summary="Get effective client-level role mappings This recurses any composite roles")
    public Stream<RoleRepresentation> getCompositeClientRoleMappings(@Parameter(description="if false, return roles with their attributes") @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.viewPermission.require();
        Stream roles = this.client.getRolesStream();
        Function<RoleModel, RoleRepresentation> toBriefRepresentation = briefRepresentation ? ModelToRepresentation::toBriefRepresentation : ModelToRepresentation::toRepresentation;
        return roles.filter(arg_0 -> ((RoleMapperModel)this.user).hasRole(arg_0)).map(toBriefRepresentation);
    }

    @Path(value="available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Client Role Mappings")
    @Operation(summary="Get available client-level roles that can be mapped to the user or group")
    public Stream<RoleRepresentation> getAvailableClientRoleMappings() {
        this.viewPermission.require();
        return this.client.getRolesStream().filter(this.auth.roles()::canMapRole).filter(((Predicate<RoleModel>)arg_0 -> ((RoleMapperModel)this.user).hasDirectRole(arg_0)).negate()).map(ModelToRepresentation::toBriefRepresentation);
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Client Role Mappings")
    @Operation(summary="Add client-level roles to the user or group role mapping")
    @APIResponse(responseCode="204", description="No Content")
    public void addClientRoleMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        try {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.client.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.auth.roles().requireMapRole(roleModel);
                this.user.grantRole(roleModel);
            }
        }
        catch (ModelIllegalStateException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ModelException | ReadOnlyException me) {
            logger.warn((Object)me.getMessage(), me);
            throw new ErrorResponseException("invalid_request", "Could not add user role or group mappings!", Response.Status.BAD_REQUEST);
        }
        if (!roles.isEmpty()) {
            this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).representation(roles).success();
        }
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Tag(name="Client Role Mappings")
    @Operation(summary="Delete client-level roles from user or group role mapping")
    public void deleteClientRoleMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (roles == null) {
            roles = this.user.getClientRoleMappingsStream(this.client).peek(roleModel -> {
                this.auth.roles().requireMapRole((RoleModel)roleModel);
                this.user.deleteRoleMapping(roleModel);
            }).map(ModelToRepresentation::toBriefRepresentation).collect(Collectors.toList());
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel2 = this.client.getRole(role.getName());
                if (roleModel2 == null || !roleModel2.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.auth.roles().requireMapRole(roleModel2);
                try {
                    this.user.deleteRoleMapping(roleModel2);
                }
                catch (ModelIllegalStateException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (ModelException | ReadOnlyException me) {
                    logger.warn((Object)me.getMessage(), me);
                    throw new ErrorResponseException("invalid_request", "Could not remove user or group role mappings!", Response.Status.BAD_REQUEST);
                }
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).representation(roles).success();
    }
}

