/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;

public class BinaryArithmeticExpression
implements Expression,
DomainResultProducer {
    private final Expression lhsOperand;
    private final BinaryArithmeticOperator operator;
    private final Expression rhsOperand;
    private final BasicValuedMapping resultType;

    public BinaryArithmeticExpression(Expression lhsOperand, BinaryArithmeticOperator operator, Expression rhsOperand, BasicValuedMapping resultType) {
        this.operator = operator;
        this.lhsOperand = lhsOperand;
        this.rhsOperand = rhsOperand;
        this.resultType = resultType;
    }

    @Override
    public BasicValuedMapping getExpressionType() {
        return this.resultType;
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitBinaryArithmeticExpression(this);
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.resultType.getJdbcMapping());
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.resolveSqlSelection(creationState);
    }

    public SqlSelection resolveSqlSelection(DomainResultCreationState creationState) {
        return creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.resultType.getJdbcMapping().getJdbcJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }

    public Expression getLeftHandOperand() {
        return this.lhsOperand;
    }

    public BinaryArithmeticOperator getOperator() {
        return this.operator;
    }

    public Expression getRightHandOperand() {
        return this.rhsOperand;
    }
}

