/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.parser.gson;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.dto.ActionTypeDTOMapper;
import org.openhab.core.automation.dto.CompositeActionTypeDTO;
import org.openhab.core.automation.dto.CompositeConditionTypeDTO;
import org.openhab.core.automation.dto.CompositeTriggerTypeDTO;
import org.openhab.core.automation.dto.ConditionTypeDTOMapper;
import org.openhab.core.automation.dto.ModuleTypeDTO;
import org.openhab.core.automation.dto.TriggerTypeDTOMapper;
import org.openhab.core.automation.internal.parser.gson.AbstractGSONParser;
import org.openhab.core.automation.internal.parser.gson.ModuleTypeParsingContainer;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.automation.parser.ParsingNestedException;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.ConditionType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.TriggerType;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(immediate=true, service={Parser.class}, property={"parser.type=parser.module.type", "format=json"})
public class ModuleTypeGSONParser
extends AbstractGSONParser<ModuleType> {
    @Override
    public Set<ModuleType> parse(InputStreamReader reader) throws ParsingException {
        try {
            ModuleTypeParsingContainer mtContainer = (ModuleTypeParsingContainer)gson.fromJson((Reader)reader, ModuleTypeParsingContainer.class);
            HashSet<ModuleType> result = new HashSet<ModuleType>();
            this.addAll(result, mtContainer.triggers);
            this.addAll(result, mtContainer.conditions);
            this.addAll(result, mtContainer.actions);
            return result;
        }
        catch (Exception e) {
            throw new ParsingException(new ParsingNestedException(1, null, e));
        }
    }

    @Override
    public void serialize(Set<ModuleType> dataObjects, OutputStreamWriter writer) throws Exception {
        Map<String, List<? extends ModuleType>> map = this.createMapByType(dataObjects);
        gson.toJson(map, (Appendable)writer);
    }

    /*
     * WARNING - void declaration
     */
    private void addAll(Set<ModuleType> result, @Nullable List<? extends ModuleTypeDTO> moduleTypes) {
        if (moduleTypes != null) {
            for (ModuleTypeDTO moduleTypeDTO : moduleTypes) {
                void tO;
                ModuleTypeDTO moduleTypeDTO2 = moduleTypeDTO;
                if (moduleTypeDTO2 instanceof CompositeTriggerTypeDTO) {
                    void tO2;
                    CompositeTriggerTypeDTO cfr_ignored_0 = (CompositeTriggerTypeDTO)moduleTypeDTO2;
                    CompositeTriggerTypeDTO cfr_ignored_1 = (CompositeTriggerTypeDTO)moduleTypeDTO2;
                    result.add(TriggerTypeDTOMapper.map((CompositeTriggerTypeDTO)tO2));
                    continue;
                }
                ModuleTypeDTO moduleTypeDTO22 = moduleTypeDTO;
                if (moduleTypeDTO22 instanceof CompositeConditionTypeDTO) {
                    void tO3;
                    CompositeConditionTypeDTO cfr_ignored_2 = (CompositeConditionTypeDTO)moduleTypeDTO22;
                    CompositeConditionTypeDTO cfr_ignored_3 = (CompositeConditionTypeDTO)moduleTypeDTO22;
                    result.add(ConditionTypeDTOMapper.map((CompositeConditionTypeDTO)tO3));
                    continue;
                }
                ModuleTypeDTO moduleTypeDTO3 = moduleTypeDTO;
                if (!(moduleTypeDTO3 instanceof CompositeActionTypeDTO)) continue;
                CompositeActionTypeDTO cfr_ignored_4 = (CompositeActionTypeDTO)moduleTypeDTO3;
                CompositeActionTypeDTO cfr_ignored_5 = (CompositeActionTypeDTO)moduleTypeDTO3;
                result.add(ActionTypeDTOMapper.map((CompositeActionTypeDTO)tO));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<? extends ModuleType>> createMapByType(Set<ModuleType> dataObjects) {
        HashMap<String, List<? extends ModuleType>> map = new HashMap<String, List<? extends ModuleType>>();
        ArrayList<void> triggers = new ArrayList<void>();
        ArrayList<void> conditions = new ArrayList<void>();
        ArrayList<void> actions = new ArrayList<void>();
        for (ModuleType moduleType : dataObjects) {
            void type;
            ModuleType moduleType2 = moduleType;
            if (moduleType2 instanceof TriggerType) {
                void type2;
                TriggerType cfr_ignored_0 = (TriggerType)moduleType2;
                TriggerType cfr_ignored_1 = (TriggerType)moduleType2;
                triggers.add(type2);
                continue;
            }
            ModuleType moduleType3 = moduleType;
            if (moduleType3 instanceof ConditionType) {
                void type3;
                ConditionType cfr_ignored_2 = (ConditionType)moduleType3;
                ConditionType cfr_ignored_3 = (ConditionType)moduleType3;
                conditions.add(type3);
                continue;
            }
            ModuleType moduleType4 = moduleType;
            if (!(moduleType4 instanceof ActionType)) continue;
            ActionType cfr_ignored_4 = (ActionType)moduleType4;
            ActionType cfr_ignored_5 = (ActionType)moduleType4;
            actions.add(type);
        }
        map.put("triggers", triggers);
        map.put("conditions", conditions);
        map.put("actions", actions);
        return map;
    }
}

